/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi;

import com.intellij.execution.rmi.RemoteCastable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import gnu.trove.THashMap;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.Remote;
import java.rmi.ServerError;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteUtil {
    private static final ConcurrentFactoryMap<Pair<Class<?>, Class<?>>, Map<Method, Method>> ourRemoteToLocalMap = new ConcurrentFactoryMap<Pair<Class<?>, Class<?>>, Map<Method, Method>>(){

        @Override
        protected Map<Method, Method> create(Pair<Class<?>, Class<?>> key) {
            THashMap map = new THashMap();
            for (Method method : ((Class)key.second).getMethods()) {
                Method m = null;
                block1: for (Method candidate : ((Class)key.first).getMethods()) {
                    Class<?>[] mpts;
                    Class<?>[] cpts;
                    if (!candidate.getName().equals(method.getName()) || (cpts = candidate.getParameterTypes()).length != (mpts = method.getParameterTypes()).length) continue;
                    for (int i = 0; i < mpts.length; ++i) {
                        Class<?> cpt = cpts[i];
                        Class<?> mpt = mpts[i];
                        if (!cpt.isAssignableFrom(mpt)) continue block1;
                    }
                    m = candidate;
                    break;
                }
                if (m == null) continue;
                map.put((Object)method, m);
            }
            return map;
        }
    };

    RemoteUtil() {
    }

    @Nullable
    public static <T> T castToRemote(Object object, Class<T> clazz) {
        RemoteInvocationHandler rih;
        if (!Proxy.isProxyClass(object.getClass())) {
            return null;
        }
        InvocationHandler handler = Proxy.getInvocationHandler(object);
        if (handler instanceof RemoteInvocationHandler && clazz.isInstance((rih = (RemoteInvocationHandler)handler).myRemote)) {
            return (T)rih.myRemote;
        }
        return null;
    }

    public static <T> T castToLocal(Object remote, Class<T> clazz) {
        ClassLoader loader = clazz.getClassLoader();
        return (T)Proxy.newProxyInstance(loader, new Class[]{clazz}, (InvocationHandler)new RemoteInvocationHandler(remote, clazz, loader));
    }

    private static Class<?> tryFixReturnType(Object result, Class<?> returnType, ClassLoader loader) throws Exception {
        if (returnType.isInterface()) {
            return returnType;
        }
        if (result instanceof RemoteCastable) {
            String className = ((RemoteCastable)result).getCastToClassName();
            return Class.forName(className, true, loader);
        }
        return returnType;
    }

    public static <T> T substituteClassLoader(final T remote, final ClassLoader classLoader) throws Exception {
        return RemoteUtil.executeWithClassLoader(new ThrowableComputable<T, Exception>(){

            @Override
            public T compute() {
                Object proxy = Proxy.newProxyInstance(classLoader, remote.getClass().getInterfaces(), new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
                        return RemoteUtil.executeWithClassLoader(new ThrowableComputable<Object, Exception>(){

                            @Override
                            public Object compute() throws Exception {
                                try {
                                    return RemoteUtil.handleRemoteResult(method.invoke(remote, args), method.getReturnType(), classLoader, true);
                                }
                                catch (InvocationTargetException e) {
                                    Throwable cause = e.getCause();
                                    if (cause instanceof RuntimeException) {
                                        throw (RuntimeException)cause;
                                    }
                                    if (cause instanceof Error) {
                                        throw (Error)cause;
                                    }
                                    if (RemoteUtil.canThrow(cause, method)) {
                                        throw (Exception)cause;
                                    }
                                    throw new RuntimeException(cause);
                                }
                            }
                        }, classLoader);
                    }
                });
                return proxy;
            }
        }, classLoader);
    }

    public static <T> T handleRemoteResult(Object value, Class<? super T> clazz, Object requestor) throws Exception {
        return RemoteUtil.handleRemoteResult(value, clazz, requestor.getClass().getClassLoader(), false);
    }

    private static <T> T handleRemoteResult(Object value, Class<?> methodReturnType, ClassLoader classLoader, boolean substituteClassLoader) throws Exception {
        Object result;
        if (value instanceof Remote) {
            result = value instanceof RemoteCastable ? RemoteUtil.castToLocal(value, RemoteUtil.tryFixReturnType(value, methodReturnType, classLoader)) : (substituteClassLoader ? RemoteUtil.substituteClassLoader(value, classLoader) : value);
        } else if (value instanceof List && methodReturnType.isInterface()) {
            result = Arrays.asList((Object[])RemoteUtil.handleRemoteResult(((List)value).toArray(), Object.class, classLoader, substituteClassLoader));
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                array[i] = RemoteUtil.handleRemoteResult(array[i], Object.class, classLoader, substituteClassLoader);
            }
            result = array;
        } else {
            result = value;
        }
        return (T)result;
    }

    private static boolean canThrow(Throwable cause, Method method) {
        for (Class<?> each : method.getExceptionTypes()) {
            if (!each.isInstance(cause)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeWithClassLoader(ThrowableComputable<T, Exception> action, ClassLoader classLoader) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader prev = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(classLoader);
            T t = action.compute();
            return t;
        }
        finally {
            thread.setContextClassLoader(prev);
        }
    }

    @NotNull
    public static Throwable unwrap(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/rmi/RemoteUtil", "unwrap"));
        }
        for (Throwable candidate = e; candidate != null; candidate = candidate.getCause()) {
            Class<?> clazz = candidate.getClass();
            if (clazz == InvocationTargetException.class || clazz == UndeclaredThrowableException.class) continue;
            Throwable throwable = candidate;
            if (throwable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/RemoteUtil", "unwrap"));
            }
            return throwable;
        }
        Throwable throwable = e;
        if (throwable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/RemoteUtil", "unwrap"));
        }
        return throwable;
    }

    private static class RemoteInvocationHandler
    implements InvocationHandler {
        private final Object myRemote;
        private final Class<?> myClazz;
        private final ClassLoader myLoader;

        public RemoteInvocationHandler(Object remote, Class<?> clazz, ClassLoader loader) {
            this.myRemote = remote;
            this.myClazz = clazz;
            this.myLoader = loader;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke(this.myRemote, args);
            }
            Method m = (Method)((Map)ourRemoteToLocalMap.get(Pair.create(this.myRemote.getClass(), this.myClazz))).get(method);
            if (m == null) {
                throw new NoSuchMethodError(method.getName() + " in " + this.myRemote.getClass());
            }
            try {
                return RemoteUtil.handleRemoteResult(m.invoke(this.myRemote, args), method.getReturnType(), this.myLoader, false);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ServerError) {
                    cause = ObjectUtils.chooseNotNull(cause.getCause(), cause);
                }
                if (cause instanceof RuntimeException) {
                    throw cause;
                }
                if (cause instanceof Error) {
                    throw cause;
                }
                if (RemoteUtil.canThrow(cause, method)) {
                    throw cause;
                }
                throw new RuntimeException(cause);
            }
        }
    }
}

