/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui.properties;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.testframework.JavaAwareTestConsoleProperties;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.config.Storage;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JUnitConsoleProperties
extends JavaAwareTestConsoleProperties {
    @NonNls
    private static final String GROUP_NAME = "JUnitSupport.";
    private final JUnitConfiguration myConfiguration;

    public JUnitConsoleProperties(@NotNull JUnitConfiguration configuration, Executor executor) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/junit2/ui/properties/JUnitConsoleProperties", "<init>"));
        }
        this(configuration, (Storage)new Storage.PropertiesComponentStorage(GROUP_NAME, PropertiesComponent.getInstance()), executor);
    }

    public JUnitConsoleProperties(@NotNull JUnitConfiguration configuration, Storage storage, Executor executor) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/junit2/ui/properties/JUnitConsoleProperties", "<init>"));
        }
        super(storage, configuration.getProject(), executor);
        this.myConfiguration = configuration;
    }

    public JUnitConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    protected GlobalSearchScope initScope() {
        SourceScope sourceScope = this.myConfiguration.getPersistentData().getScope().getSourceScope((ModuleBasedConfiguration)this.myConfiguration);
        return sourceScope != null ? sourceScope.getLibrariesScope() : GlobalSearchScope.allScope((Project)this.getProject());
    }
}

