/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui;

import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.events.StateChangedEvent;
import com.intellij.execution.junit2.events.TestEvent;
import com.intellij.execution.junit2.ui.model.JUnitAdapter;
import com.intellij.execution.junit2.ui.model.JUnitRunningModel;
import com.intellij.execution.junit2.ui.model.StateEvent;
import com.intellij.execution.testframework.ui.TestsProgressAnimator;
import com.intellij.openapi.Disposable;

public class Animator
extends TestsProgressAnimator {
    public Animator(Disposable parentDisposable) {
        super(parentDisposable);
    }

    public void setModel(JUnitRunningModel model) {
        this.init(model.getTreeBuilder());
        model.addListener(new JUnitAdapter(){

            @Override
            public void onTestChanged(TestEvent event) {
                TestProxy test;
                if (event instanceof StateChangedEvent && (test = event.getSource()).isLeaf() && test.getState().getMagnitude() == 3) {
                    Animator.this.setCurrentTestCase(test);
                }
            }

            @Override
            public void onRunnerStateChanged(StateEvent event) {
                if (!event.isRunning()) {
                    Animator.this.stopMovie();
                }
            }

            @Override
            public void doDispose() {
                Animator.this.dispose();
            }
        });
    }
}

