/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.states;

import com.intellij.execution.junit2.segments.ObjectReader;
import com.intellij.execution.junit2.states.FaultyState;
import com.intellij.execution.junit2.states.JUnitDiffHyperlink;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NonNls;

public class ComparisonFailureState
extends FaultyState
implements AbstractTestProxy.AssertEqualsDiffViewerProvider {
    private DiffHyperlink myHyperlink;
    @NonNls
    protected static final String EXPECTED_VALUE_MESSAGE_TEXT = "expected:<";

    @Override
    public void initializeFrom(ObjectReader reader) {
        super.initializeFrom(reader);
        this.myHyperlink = JUnitDiffHyperlink.readFrom(reader);
    }

    @Override
    protected void printExceptionHeader(Printer printer, String message) {
        int columnIndex = message.indexOf(58);
        if (columnIndex != -1) {
            printer.print(message.substring(0, columnIndex + 1), ConsoleViewContentType.ERROR_OUTPUT);
            message = message.substring(columnIndex + 1);
        }
        if (message.trim().length() > 0) {
            int generatedMessageStart = message.indexOf(EXPECTED_VALUE_MESSAGE_TEXT);
            if (generatedMessageStart != -1) {
                message = message.substring(0, generatedMessageStart);
            }
            printer.print(message, ConsoleViewContentType.ERROR_OUTPUT);
        }
        this.myHyperlink.printOn(printer);
    }

    public String getExpected() {
        return this.myHyperlink.getLeft();
    }

    public String getActual() {
        return this.myHyperlink.getRight();
    }

    public void openDiff(Project project) {
        if (this.myHyperlink != null) {
            this.myHyperlink.openDiff(project);
        }
    }
}

