/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.configuration;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit2.configuration.JUnitConfigurable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class JUnitConfigurationModel {
    public static final int ALL_IN_PACKAGE = 0;
    public static final int CLASS = 1;
    public static final int METHOD = 2;
    public static final int PATTERN = 3;
    public static final int DIR = 4;
    private static final List<String> ourTestObjects = Arrays.asList("package", "class", "method", "pattern", "directory");
    private JUnitConfigurable myListener;
    private int myType = -1;
    private final Object[] myJUnitDocuments = new Object[5];
    private final Project myProject;

    public JUnitConfigurationModel(Project project) {
        this.myProject = project;
    }

    public boolean setType(int type) {
        if (type == this.myType) {
            return false;
        }
        if (type < 0 || type >= ourTestObjects.size()) {
            type = 1;
        }
        this.myType = type;
        this.fireTypeChanged(type);
        return true;
    }

    private void fireTypeChanged(int newType) {
        this.myListener.onTypeChanged(newType);
    }

    public void setListener(JUnitConfigurable listener) {
        this.myListener = listener;
    }

    public Object getJUnitDocument(int i) {
        return this.myJUnitDocuments[i];
    }

    public void setJUnitDocument(int i, Object doc) {
        this.myJUnitDocuments[i] = doc;
    }

    public void apply(Module module, JUnitConfiguration configuration) {
        boolean shouldUpdateName = configuration.isGeneratedName();
        this.applyTo(configuration.getPersistentData(), module);
        if (shouldUpdateName && !JavaExecutionUtil.isNewName((String)configuration.getName())) {
            configuration.setGeneratedName();
        }
    }

    private void applyTo(JUnitConfiguration.Data data, Module module) {
        block11: {
            String testObject = this.getTestObject();
            String className = this.getJUnitTextValue(1);
            data.TEST_OBJECT = testObject;
            if (testObject != "package" && testObject != "pattern" && testObject != "directory") {
                try {
                    PsiClass testClass;
                    data.METHOD_NAME = this.getJUnitTextValue(2);
                    PsiClass psiClass = testClass = !this.myProject.isDefault() && !StringUtil.isEmptyOrSpaces((String)className) ? JUnitUtil.findPsiClass((String)className, (Module)module, (Project)this.myProject) : null;
                    if (testClass != null && testClass.isValid()) {
                        data.setMainClass(testClass);
                        break block11;
                    }
                    data.MAIN_CLASS_NAME = className;
                }
                catch (ProcessCanceledException e) {
                    data.MAIN_CLASS_NAME = className;
                }
                catch (IndexNotReadyException e) {
                    data.MAIN_CLASS_NAME = className;
                }
            } else {
                if (testObject == "package") {
                    data.PACKAGE_NAME = this.getJUnitTextValue(0);
                } else if (testObject == "directory") {
                    data.setDirName(this.getJUnitTextValue(4));
                } else {
                    String[] patterns;
                    LinkedHashSet<String> set = new LinkedHashSet<String>();
                    for (String pattern : patterns = this.getJUnitTextValue(3).split("\\|\\|")) {
                        if (pattern.length() <= 0) continue;
                        set.add(pattern);
                    }
                    data.setPatterns(set);
                }
                data.MAIN_CLASS_NAME = "";
                data.METHOD_NAME = "";
            }
        }
    }

    private String getTestObject() {
        return ourTestObjects.get(this.myType);
    }

    private String getJUnitTextValue(int index) {
        return JUnitConfigurationModel.getDocumentText(index, this.myJUnitDocuments);
    }

    private static String getDocumentText(int index, Object[] documents) {
        Object document = documents[index];
        if (document instanceof PlainDocument) {
            try {
                return ((PlainDocument)document).getText(0, ((PlainDocument)document).getLength());
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
        return ((Document)document).getText();
    }

    public void reset(JUnitConfiguration configuration) {
        JUnitConfiguration.Data data = configuration.getPersistentData();
        this.setTestType(data.TEST_OBJECT);
        this.setJUnitTextValue(0, data.getPackageName());
        this.setJUnitTextValue(1, data.getMainClassName());
        this.setJUnitTextValue(2, data.getMethodName());
        this.setJUnitTextValue(3, data.getPatternPresentation());
        this.setJUnitTextValue(4, data.getDirName());
    }

    private void setJUnitTextValue(int index, String text) {
        this.setDocumentText(index, text, this.myJUnitDocuments);
    }

    private void setDocumentText(int index, final String text, Object[] documents) {
        final Object document = documents[index];
        if (document instanceof PlainDocument) {
            try {
                ((PlainDocument)document).remove(0, ((PlainDocument)document).getLength());
                ((PlainDocument)document).insertString(0, text, null);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        } else {
            WriteCommandAction.runWriteCommandAction((Project)this.myProject, (Runnable)new Runnable(){

                @Override
                public void run() {
                    ((Document)document).replaceString(0, ((Document)document).getTextLength(), (CharSequence)text);
                }
            });
        }
    }

    private void setTestType(String testObject) {
        this.setType(ourTestObjects.indexOf(testObject));
    }
}

