/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.junit2.configuration.JUnitConfigurable;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JUnitConfiguration
extends ModuleBasedConfiguration<JavaRunConfigurationModule>
implements CommonJavaRunConfigurationParameters,
RefactoringListenerProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.junit.JUnitConfiguration");
    public static final String DEFAULT_PACKAGE_NAME = ExecutionBundle.message((String)"default.package.presentable.name", (Object[])new Object[0]);
    @NonNls
    public static final String TEST_CLASS = "class";
    @NonNls
    public static final String TEST_PACKAGE = "package";
    @NonNls
    public static final String TEST_DIRECTORY = "directory";
    @NonNls
    public static final String TEST_METHOD = "method";
    @NonNls
    private static final String PATTERN_EL_NAME = "pattern";
    @NonNls
    public static final String TEST_PATTERN = "pattern";
    @NonNls
    private static final String TEST_CLASS_ATT_NAME = "testClass";
    @NonNls
    private static final String PATTERNS_EL_NAME = "patterns";
    private final Data myData;
    @NonNls
    public static final String JUNIT_START_CLASS = "com.intellij.rt.execution.junit.JUnitStarter";
    public boolean ALTERNATIVE_JRE_PATH_ENABLED;
    public String ALTERNATIVE_JRE_PATH;
    final RefactoringListeners.Accessor<PsiPackage> myPackage = new RefactoringListeners.Accessor<PsiPackage>(){

        public void setName(String qualifiedName) {
            boolean generatedName = JUnitConfiguration.this.isGeneratedName();
            ((JUnitConfiguration)JUnitConfiguration.this).myData.PACKAGE_NAME = qualifiedName;
            if (generatedName) {
                JUnitConfiguration.this.setGeneratedName();
            }
        }

        public PsiPackage getPsiElement() {
            String qualifiedName = JUnitConfiguration.this.myData.getPackageName();
            return qualifiedName != null ? JavaPsiFacade.getInstance((Project)JUnitConfiguration.this.getProject()).findPackage(qualifiedName) : null;
        }

        public void setPsiElement(PsiPackage psiPackage) {
            this.setName(psiPackage.getQualifiedName());
        }
    };
    final RefactoringListeners.Accessor<PsiClass> myClass = new RefactoringListeners.Accessor<PsiClass>(){

        public void setName(@NotNull String qualifiedName) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/junit/JUnitConfiguration$2", "setName"));
            }
            boolean generatedName = JUnitConfiguration.this.isGeneratedName();
            ((JUnitConfiguration)JUnitConfiguration.this).myData.MAIN_CLASS_NAME = qualifiedName;
            if (generatedName) {
                JUnitConfiguration.this.setGeneratedName();
            }
        }

        public PsiClass getPsiElement() {
            return ((JavaRunConfigurationModule)JUnitConfiguration.this.getConfigurationModule()).findClass(JUnitConfiguration.this.myData.getMainClassName());
        }

        public void setPsiElement(PsiClass psiClass) {
            Module originalModule = ((JavaRunConfigurationModule)JUnitConfiguration.this.getConfigurationModule()).getModule();
            JUnitConfiguration.this.setMainClass(psiClass);
            JUnitConfiguration.this.restoreOriginalModule(originalModule);
        }
    };

    public JUnitConfiguration(String name, Project project, ConfigurationFactory configurationFactory) {
        this(name, project, new Data(), configurationFactory);
    }

    private JUnitConfiguration(String name, Project project, Data data, ConfigurationFactory configurationFactory) {
        super(name, (RunConfigurationModule)new JavaRunConfigurationModule(project, false), configurationFactory);
        this.myData = data;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/junit/JUnitConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/execution/junit/JUnitConfiguration", "getState"));
        }
        return TestObject.fromString(this.myData.TEST_OBJECT, this.getProject(), this, env);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new JUnitConfigurable(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/JUnitConfiguration", "getConfigurationEditor"));
        }
        return settingsEditorGroup;
    }

    public Data getPersistentData() {
        return this.myData;
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        RefactoringElementListener listener = this.myData.getTestObject(this.getProject(), this).getListener(element, this);
        return RunConfigurationExtension.wrapRefactoringElementListener((PsiElement)element, (RunConfigurationBase)this, (RefactoringElementListener)listener);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        this.myData.getTestObject(this.getProject(), this).checkConfiguration();
        JavaRunConfigurationExtensionManager.checkConfigurationIsValid((RunConfigurationBase)this);
    }

    public Collection<Module> getValidModules() {
        if (TEST_PACKAGE.equals(this.myData.TEST_OBJECT) || "pattern".equals(this.myData.TEST_OBJECT)) {
            return Arrays.asList(ModuleManager.getInstance((Project)this.getProject()).getModules());
        }
        try {
            this.myData.getTestObject(this.getProject(), this).checkConfiguration();
        }
        catch (RuntimeConfigurationError e) {
            return Arrays.asList(ModuleManager.getInstance((Project)this.getProject()).getModules());
        }
        catch (RuntimeConfigurationException runtimeConfigurationException) {
            // empty catch block
        }
        return JavaRunConfigurationModule.getModulesForClass((Project)this.getProject(), (String)this.myData.getMainClassName());
    }

    protected ModuleBasedConfiguration createInstance() {
        return new JUnitConfiguration(this.getName(), this.getProject(), this.myData.clone(), JUnitConfigurationType.getInstance().getConfigurationFactories()[0]);
    }

    public String suggestedName() {
        return this.myData.getGeneratedName((JavaRunConfigurationModule)this.getConfigurationModule());
    }

    public String getActionName() {
        return this.getTestObject().suggestActionName();
    }

    public void setVMParameters(String value) {
        this.myData.setVMParameters(value);
    }

    public String getVMParameters() {
        return this.myData.getVMParameters();
    }

    public void setProgramParameters(String value) {
        this.myData.setProgramParameters(value);
    }

    public String getProgramParameters() {
        return this.myData.getProgramParameters();
    }

    public void setWorkingDirectory(String value) {
        this.myData.setWorkingDirectory(value);
    }

    public String getWorkingDirectory() {
        return this.myData.getWorkingDirectory();
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/junit/JUnitConfiguration", "setEnvs"));
        }
        this.myData.setEnvs(envs);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.myData.getEnvs();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/JUnitConfiguration", "getEnvs"));
        }
        return map;
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myData.PASS_PARENT_ENVS = passParentEnvs;
    }

    public boolean isPassParentEnvs() {
        return this.myData.PASS_PARENT_ENVS;
    }

    public boolean isAlternativeJrePathEnabled() {
        return this.ALTERNATIVE_JRE_PATH_ENABLED;
    }

    public void setAlternativeJrePathEnabled(boolean enabled) {
        this.ALTERNATIVE_JRE_PATH_ENABLED = enabled;
    }

    public String getAlternativeJrePath() {
        return this.ALTERNATIVE_JRE_PATH;
    }

    public void setAlternativeJrePath(String path) {
        this.ALTERNATIVE_JRE_PATH = path;
    }

    public String getRunClass() {
        Data data = this.getPersistentData();
        return data.TEST_OBJECT != TEST_CLASS && data.TEST_OBJECT != TEST_METHOD ? null : data.getMainClassName();
    }

    public String getPackage() {
        Data data = this.getPersistentData();
        return !Comparing.strEqual((String)data.TEST_OBJECT, (String)TEST_PACKAGE) ? null : data.getPackageName();
    }

    public void beClassConfiguration(PsiClass testClass) {
        this.setMainClass(testClass);
        this.myData.TEST_OBJECT = TEST_CLASS;
        this.setGeneratedName();
    }

    public void setMainClass(PsiClass testClass) {
        boolean shouldUpdateName = this.isGeneratedName();
        this.setModule(this.myData.setMainClass(testClass));
        if (shouldUpdateName) {
            this.setGeneratedName();
        }
    }

    public void beMethodConfiguration(Location<PsiMethod> methodLocation) {
        this.setModule(this.myData.setTestMethod(methodLocation));
        this.setGeneratedName();
    }

    @NotNull
    public Module[] getModules() {
        if (TEST_PACKAGE.equals(this.myData.TEST_OBJECT) && this.getPersistentData().getScope() == TestSearchScope.WHOLE_PROJECT) {
            if (Module.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/JUnitConfiguration", "getModules"));
            }
            return Module.EMPTY_ARRAY;
        }
        Module[] moduleArray = super.getModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/JUnitConfiguration", "getModules"));
        }
        return moduleArray;
    }

    public TestObject getTestObject() {
        return this.myData.getTestObject(this.getProject(), this);
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element dirNameElement;
        String mode;
        Element forkModeElement;
        PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPaths(element);
        super.readExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().readExternal((RunConfigurationBase)this, element);
        this.readModule(element);
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
        DefaultJDOMExternalizer.readExternal((Object)this.getPersistentData(), (Element)element);
        EnvironmentVariablesComponent.readExternal((Element)element, this.getPersistentData().getEnvs());
        Element patternsElement = element.getChild(PATTERNS_EL_NAME);
        if (patternsElement != null) {
            LinkedHashSet<String> tests = new LinkedHashSet<String>();
            Iterator i$ = patternsElement.getChildren("pattern").iterator();
            while (i$.hasNext()) {
                Element o;
                Element patternElement = o = (Element)i$.next();
                tests.add(patternElement.getAttributeValue(TEST_CLASS_ATT_NAME));
            }
            this.myData.setPatterns(tests);
        }
        if ((forkModeElement = element.getChild("fork_mode")) != null && (mode = forkModeElement.getAttributeValue("value")) != null) {
            this.setForkMode(mode);
        }
        if ((dirNameElement = element.getChild("dir")) != null) {
            String dirName = dirNameElement.getAttributeValue("value");
            this.getPersistentData().setDirName(FileUtil.toSystemDependentName((String)dirName));
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().writeExternal((RunConfigurationBase)this, element);
        this.writeModule(element);
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
        Data persistentData = this.getPersistentData();
        DefaultJDOMExternalizer.writeExternal((Object)persistentData, (Element)element);
        EnvironmentVariablesComponent.writeExternal((Element)element, persistentData.getEnvs());
        String dirName = persistentData.getDirName();
        if (!dirName.isEmpty()) {
            Element dirNameElement = new Element("dir");
            dirNameElement.setAttribute("value", FileUtil.toSystemIndependentName((String)dirName));
            element.addContent(dirNameElement);
        }
        Element patternsElement = new Element(PATTERNS_EL_NAME);
        for (String o : persistentData.getPatterns()) {
            Element patternElement = new Element("pattern");
            patternElement.setAttribute(TEST_CLASS_ATT_NAME, o);
            patternsElement.addContent(patternElement);
        }
        String forkMode = this.getForkMode();
        if (!forkMode.equals("none")) {
            Element forkModeElement = new Element("fork_mode");
            forkModeElement.setAttribute("value", forkMode);
            element.addContent(forkModeElement);
        }
        element.addContent(patternsElement);
        PathMacroManager.getInstance((ComponentManager)this.getProject()).collapsePathsRecursively(element);
    }

    public void configureClasspath(JavaParameters javaParameters) throws CantRunException {
        RunConfigurationModule module = this.getConfigurationModule();
        String jreHome = this.isAlternativeJrePathEnabled() ? this.getAlternativeJrePath() : null;
        int pathType = 7;
        if (this.myData.getScope() == TestSearchScope.WHOLE_PROJECT) {
            JavaParametersUtil.configureProject((Project)module.getProject(), (JavaParameters)javaParameters, (int)7, (String)jreHome);
        } else {
            JavaParametersUtil.configureModule((RunConfigurationModule)module, (JavaParameters)javaParameters, (int)7, (String)jreHome);
        }
    }

    public void setForkMode(@NotNull String forkMode) {
        if (forkMode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/execution/junit/JUnitConfiguration", "setForkMode"));
        }
        this.myData.FORK_MODE = forkMode;
    }

    public String getForkMode() {
        return this.myData.FORK_MODE;
    }

    public boolean collectOutputFromProcessHandler() {
        return false;
    }

    public void bePatternConfiguration(List<PsiClass> classes, PsiMethod method) {
        String methodSufiix;
        this.myData.TEST_OBJECT = "pattern";
        HashSet<String> patterns = new HashSet<String>();
        if (method != null) {
            this.myData.METHOD_NAME = method.getName();
            methodSufiix = "," + this.myData.METHOD_NAME;
        } else {
            methodSufiix = "";
        }
        for (PsiClass pattern : classes) {
            patterns.add(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)pattern) + methodSufiix);
        }
        this.myData.setPatterns(patterns);
        Module module = PatternConfigurationProducer.findModule(this, ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule(), patterns);
        if (module == null) {
            this.myData.setScope(TestSearchScope.WHOLE_PROJECT);
            this.setModule(null);
        } else {
            this.setModule(module);
        }
        this.setGeneratedName();
    }

    public static class Data
    implements Cloneable {
        public String PACKAGE_NAME;
        private String DIR_NAME;
        public String MAIN_CLASS_NAME;
        public String METHOD_NAME;
        public String TEST_OBJECT = "class";
        public String VM_PARAMETERS;
        public String PARAMETERS;
        public String WORKING_DIRECTORY;
        private String FORK_MODE = "none";
        private Set<String> myPattern = new LinkedHashSet<String>();
        public String ENV_VARIABLES;
        private Map<String, String> myEnvs = new LinkedHashMap<String, String>();
        public boolean PASS_PARENT_ENVS = true;
        public TestSearchScope.Wrapper TEST_SEARCH_SCOPE = new TestSearchScope.Wrapper();

        public boolean equals(Object object) {
            if (!(object instanceof Data)) {
                return false;
            }
            Data second = (Data)object;
            return Comparing.equal((String)this.TEST_OBJECT, (String)second.TEST_OBJECT) && Comparing.equal((String)this.getMainClassName(), (String)second.getMainClassName()) && Comparing.equal((String)this.getPackageName(), (String)second.getPackageName()) && Comparing.equal((String)this.getMethodName(), (String)second.getMethodName()) && Comparing.equal((String)this.getWorkingDirectory(), (String)second.getWorkingDirectory()) && Comparing.equal((String)this.VM_PARAMETERS, (String)second.VM_PARAMETERS) && Comparing.equal((String)this.PARAMETERS, (String)second.PARAMETERS) && Comparing.equal(this.myPattern, second.myPattern) && Comparing.equal((String)this.FORK_MODE, (String)second.FORK_MODE) && Comparing.equal((String)this.DIR_NAME, (String)second.DIR_NAME);
        }

        public int hashCode() {
            return Comparing.hashcode((Object)this.TEST_OBJECT) ^ Comparing.hashcode((Object)this.getMainClassName()) ^ Comparing.hashcode((Object)this.getPackageName()) ^ Comparing.hashcode((Object)this.getMethodName()) ^ Comparing.hashcode((Object)this.getWorkingDirectory()) ^ Comparing.hashcode((Object)this.VM_PARAMETERS) ^ Comparing.hashcode((Object)this.PARAMETERS) ^ Comparing.hashcode(this.myPattern) ^ Comparing.hashcode((Object)this.FORK_MODE) ^ Comparing.hashcode((Object)this.DIR_NAME);
        }

        public TestSearchScope getScope() {
            return this.TEST_SEARCH_SCOPE.getScope();
        }

        public Data clone() {
            try {
                Data data = (Data)super.clone();
                data.TEST_SEARCH_SCOPE = new TestSearchScope.Wrapper();
                data.setScope(this.getScope());
                data.myEnvs = new LinkedHashMap<String, String>(this.myEnvs);
                return data;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public void setVMParameters(String value) {
            this.VM_PARAMETERS = value;
        }

        public String getVMParameters() {
            return this.VM_PARAMETERS;
        }

        public void setProgramParameters(String value) {
            this.PARAMETERS = value;
        }

        public String getProgramParameters() {
            return this.PARAMETERS;
        }

        public void setWorkingDirectory(String value) {
            this.WORKING_DIRECTORY = ExternalizablePath.urlValue((String)value);
        }

        public String getWorkingDirectory() {
            return ExternalizablePath.localPathValue((String)this.WORKING_DIRECTORY);
        }

        public Module setTestMethod(Location<PsiMethod> methodLocation) {
            PsiMethod method = (PsiMethod)methodLocation.getPsiElement();
            this.METHOD_NAME = method.getName();
            this.TEST_OBJECT = JUnitConfiguration.TEST_METHOD;
            return this.setMainClass(methodLocation instanceof MethodLocation ? ((MethodLocation)methodLocation).getContainingClass() : method.getContainingClass());
        }

        public String getGeneratedName(JavaRunConfigurationModule configurationModule) {
            if (JUnitConfiguration.TEST_PACKAGE.equals(this.TEST_OBJECT) || JUnitConfiguration.TEST_DIRECTORY.equals(this.TEST_OBJECT)) {
                String moduleName = this.TEST_SEARCH_SCOPE.getScope() == TestSearchScope.WHOLE_PROJECT ? "" : configurationModule.getModuleName();
                String packageName = this.getPackageName();
                if (packageName.length() == 0) {
                    if (moduleName.length() > 0) {
                        return ExecutionBundle.message((String)"default.junit.config.name.all.in.module", (Object[])new Object[]{moduleName});
                    }
                    return DEFAULT_PACKAGE_NAME;
                }
                if (moduleName.length() > 0) {
                    return ExecutionBundle.message((String)"default.junit.config.name.all.in.package.in.module", (Object[])new Object[]{packageName, moduleName});
                }
                return packageName;
            }
            if ("pattern".equals(this.TEST_OBJECT)) {
                int size = this.myPattern.size();
                if (size == 0) {
                    return "Temp suite";
                }
                String fqName = this.myPattern.iterator().next();
                return (fqName.contains("*") ? fqName : StringUtil.getShortName((String)fqName)) + (size > 1 ? " and " + (size - 1) + " more" : "");
            }
            String className = JavaExecutionUtil.getPresentableClassName((String)this.getMainClassName());
            if (JUnitConfiguration.TEST_METHOD.equals(this.TEST_OBJECT)) {
                return className + '.' + this.getMethodName();
            }
            return className;
        }

        public String getMainClassName() {
            return this.MAIN_CLASS_NAME != null ? this.MAIN_CLASS_NAME : "";
        }

        public String getPackageName() {
            return this.PACKAGE_NAME != null ? this.PACKAGE_NAME : "";
        }

        public String getMethodName() {
            return this.METHOD_NAME != null ? this.METHOD_NAME : "";
        }

        public String getDirName() {
            return this.DIR_NAME != null ? this.DIR_NAME : "";
        }

        public Set<String> getPatterns() {
            return this.myPattern;
        }

        public String getPatternPresentation() {
            ArrayList<String> enabledTests = new ArrayList<String>();
            for (String pattern : this.myPattern) {
                enabledTests.add(pattern);
            }
            return StringUtil.join(enabledTests, (String)"||");
        }

        public void setPatterns(Set<String> pattern) {
            this.myPattern = pattern;
        }

        public TestObject getTestObject(Project project, JUnitConfiguration configuration) {
            return TestObject.fromString(this.TEST_OBJECT, project, configuration, null);
        }

        public Module setMainClass(PsiClass testClass) {
            this.MAIN_CLASS_NAME = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)testClass);
            PsiPackage containingPackage = JUnitUtil.getContainingPackage((PsiClass)testClass);
            this.PACKAGE_NAME = containingPackage != null ? containingPackage.getQualifiedName() : "";
            return JavaExecutionUtil.findModule((PsiClass)testClass);
        }

        public void setScope(TestSearchScope scope) {
            this.TEST_SEARCH_SCOPE.setScope(scope);
        }

        public Map<String, String> getEnvs() {
            return this.myEnvs;
        }

        public void setEnvs(Map<String, String> envs) {
            this.myEnvs = envs;
        }

        public void setDirName(String dirName) {
            this.DIR_NAME = dirName;
        }
    }
}

