/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.compiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootCopyingHandlerProvider;
import org.jetbrains.jps.incremental.artifacts.instructions.FileCopyingHandler;
import org.jetbrains.jps.maven.compiler.MavenResourceFileProcessor;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenResourceFileFilter;
import org.jetbrains.jps.maven.model.impl.MavenWebArtifactConfiguration;
import org.jetbrains.jps.maven.model.impl.ResourceRootConfiguration;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.artifact.JpsArtifact;

public class MavenWebArtifactRootCopyingHandlerProvider
extends ArtifactRootCopyingHandlerProvider {
    private static final Logger LOG = Logger.getInstance(MavenWebArtifactRootCopyingHandlerProvider.class);

    @Nullable
    public FileCopyingHandler createCustomHandler(@NotNull JpsArtifact artifact, @NotNull File root, @NotNull JpsModel model, @NotNull BuildDataPaths buildDataPaths) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        if (buildDataPaths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider", "createCustomHandler"));
        }
        JpsMavenExtensionService mavenExtensionService = JpsMavenExtensionService.getInstance();
        if (!mavenExtensionService.hasMavenProjectConfiguration(buildDataPaths)) {
            return null;
        }
        MavenProjectConfiguration projectConfiguration = mavenExtensionService.getMavenProjectConfiguration(buildDataPaths);
        MavenWebArtifactConfiguration artifactResourceConfiguration = projectConfiguration.webArtifactConfigs.get(artifact.getName());
        if (artifactResourceConfiguration == null) {
            return null;
        }
        ResourceRootConfiguration rootConfiguration = artifactResourceConfiguration.getRootConfiguration(root);
        if (rootConfiguration == null) {
            return null;
        }
        MavenModuleResourceConfiguration moduleResourceConfiguration = projectConfiguration.moduleConfigurations.get(artifactResourceConfiguration.moduleName);
        if (moduleResourceConfiguration == null) {
            LOG.debug("Maven resource configuration not found for module " + artifactResourceConfiguration.moduleName);
            return null;
        }
        MavenResourceFileProcessor fileProcessor = new MavenResourceFileProcessor(projectConfiguration, model.getProject(), moduleResourceConfiguration);
        return new MavenWebRootCopyingHandler(fileProcessor, rootConfiguration, moduleResourceConfiguration, root);
    }

    private static class MavenWebRootCopyingHandler
    extends FileCopyingHandler {
        private final MavenResourceFileProcessor myFileProcessor;
        @NotNull
        private final ResourceRootConfiguration myRootConfiguration;
        @NotNull
        private final MavenModuleResourceConfiguration myModuleResourceConfiguration;
        @NotNull
        private final File myRoot;
        private FileFilter myFileFilter;
        private boolean myMainWebAppRoot;

        private MavenWebRootCopyingHandler(@NotNull MavenResourceFileProcessor fileProcessor, @NotNull ResourceRootConfiguration rootConfiguration, @NotNull MavenModuleResourceConfiguration moduleResourceConfiguration, @NotNull File root) {
            if (fileProcessor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenWebRootCopyingHandler", "<init>"));
            }
            if (rootConfiguration == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenWebRootCopyingHandler", "<init>"));
            }
            if (moduleResourceConfiguration == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenWebRootCopyingHandler", "<init>"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenWebRootCopyingHandler", "<init>"));
            }
            this.myFileProcessor = fileProcessor;
            this.myRootConfiguration = rootConfiguration;
            this.myModuleResourceConfiguration = moduleResourceConfiguration;
            this.myRoot = root;
            this.myFileFilter = new MavenResourceFileFilter(this.myRoot, this.myRootConfiguration);
            String relativePath = FileUtil.getRelativePath((String)FileUtil.toSystemIndependentName((String)moduleResourceConfiguration.directory), (String)FileUtil.toSystemIndependentName((String)rootConfiguration.directory), (char)'/');
            this.myMainWebAppRoot = relativePath != null && "src/main/webapp".equals(StringUtil.trimEnd((String)relativePath, (String)"/"));
        }

        public void copyFile(@NotNull File from, @NotNull File to, @NotNull CompileContext context) throws IOException {
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenWebRootCopyingHandler", "copyFile"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenWebRootCopyingHandler", "copyFile"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenWebRootCopyingHandler", "copyFile"));
            }
            this.myFileProcessor.copyFile(from, to, this.myRootConfiguration, context, this.myMainWebAppRoot ? this.myFileFilter : FileUtilRt.ALL_FILES);
        }

        public void writeConfiguration(@NotNull PrintWriter out) {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenWebRootCopyingHandler", "writeConfiguration"));
            }
            out.print("maven hash:");
            out.println(this.myModuleResourceConfiguration.computeModuleConfigurationHash() + 31 * this.myRootConfiguration.computeConfigurationHash());
        }

        @NotNull
        public FileFilter createFileFilter() {
            FileFilter fileFilter = this.myMainWebAppRoot ? FileUtilRt.ALL_FILES : this.myFileFilter;
            if (fileFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/maven/compiler/MavenWebArtifactRootCopyingHandlerProvider$MavenWebRootCopyingHandler", "createFileFilter"));
            }
            return fileFilter;
        }
    }
}

