/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.util.Arrays;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.internal.consumer.AbstractLongRunningOperation;
import org.gradle.tooling.internal.consumer.BlockingResultHandler;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.async.AsyncConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.ConsumerAction;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.model.UnsupportedMethodException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelBuilder<T>
extends AbstractLongRunningOperation<DefaultModelBuilder<T>>
implements ModelBuilder<T> {
    private final Class<T> modelType;
    private final AsyncConsumerActionExecutor connection;

    public DefaultModelBuilder(Class<T> modelType, AsyncConsumerActionExecutor connection, ConnectionParameters parameters) {
        super(parameters);
        this.modelType = modelType;
        this.connection = connection;
    }

    @Override
    protected DefaultModelBuilder<T> getThis() {
        return this;
    }

    @Override
    public T get() throws GradleConnectionException {
        BlockingResultHandler<T> handler = new BlockingResultHandler<T>(this.modelType);
        this.get(handler);
        return handler.getResult();
    }

    @Override
    public void get(ResultHandler<? super T> handler) throws IllegalStateException {
        final ConsumerOperationParameters operationParameters = this.getConsumerOperationParameters();
        this.connection.run(new ConsumerAction<T>(){

            @Override
            public ConsumerOperationParameters getParameters() {
                return operationParameters;
            }

            @Override
            public T run(ConsumerConnection connection) {
                return connection.run(DefaultModelBuilder.this.modelType, operationParameters);
            }
        }, new ResultHandlerAdapter<T>(handler));
    }

    @Override
    public DefaultModelBuilder<T> forTasks(String ... tasks) {
        this.operationParamsBuilder.setTasks(Arrays.asList(tasks));
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultHandlerAdapter<T>
    extends org.gradle.tooling.internal.consumer.ResultHandlerAdapter<T> {
        public ResultHandlerAdapter(ResultHandler<? super T> handler) {
            super(handler);
        }

        @Override
        protected String connectionFailureMessage(Throwable failure) {
            String message = String.format("Could not fetch model of type '%s' using %s.", DefaultModelBuilder.this.modelType.getSimpleName(), DefaultModelBuilder.this.connection.getDisplayName());
            if (!(failure instanceof UnsupportedMethodException) && failure instanceof UnsupportedOperationException) {
                message = message + "\nMost likely the model of that type is not supported in the target Gradle version.\nTo resolve the problem you can change/upgrade the Gradle version the tooling api connects to.";
            }
            return message;
        }
    }
}

