/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.incremental.storage.OneToManyPathsMapping;

public class SourceToOutputMappingImpl
implements SourceToOutputMapping {
    private final OneToManyPathsMapping myMapping;

    public SourceToOutputMappingImpl(File storePath) throws IOException {
        this.myMapping = new OneToManyPathsMapping(storePath);
    }

    @Override
    public void setOutputs(@NotNull String srcPath, @NotNull Collection<String> outputs) throws IOException {
        if (srcPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/storage/SourceToOutputMappingImpl", "setOutputs"));
        }
        if (outputs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/incremental/storage/SourceToOutputMappingImpl", "setOutputs"));
        }
        this.myMapping.update(srcPath, outputs);
    }

    @Override
    public void setOutput(@NotNull String srcPath, @NotNull String outputPath) throws IOException {
        if (srcPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/storage/SourceToOutputMappingImpl", "setOutput"));
        }
        if (outputPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/incremental/storage/SourceToOutputMappingImpl", "setOutput"));
        }
        this.myMapping.update(srcPath, outputPath);
    }

    @Override
    public void appendOutput(@NotNull String srcPath, @NotNull String outputPath) throws IOException {
        if (srcPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/storage/SourceToOutputMappingImpl", "appendOutput"));
        }
        if (outputPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/incremental/storage/SourceToOutputMappingImpl", "appendOutput"));
        }
        this.myMapping.appendData(srcPath, outputPath);
    }

    @Override
    public void remove(@NotNull String srcPath) throws IOException {
        if (srcPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/storage/SourceToOutputMappingImpl", "remove"));
        }
        this.myMapping.remove(srcPath);
    }

    @Override
    public void removeOutput(@NotNull String sourcePath, @NotNull String outputPath) throws IOException {
        if (sourcePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/storage/SourceToOutputMappingImpl", "removeOutput"));
        }
        if (outputPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/incremental/storage/SourceToOutputMappingImpl", "removeOutput"));
        }
        this.myMapping.removeData(sourcePath, outputPath);
    }

    @Override
    @NotNull
    public Collection<String> getSources() throws IOException {
        Collection<String> collection = this.myMapping.getKeys();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/storage/SourceToOutputMappingImpl", "getSources"));
        }
        return collection;
    }

    @Override
    @Nullable
    public Collection<String> getOutputs(@NotNull String srcPath) throws IOException {
        if (srcPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/storage/SourceToOutputMappingImpl", "getOutputs"));
        }
        return this.myMapping.getState(srcPath);
    }

    @Override
    @NotNull
    public Iterator<String> getSourcesIterator() throws IOException {
        Iterator<String> iterator = this.myMapping.getKeysIterator();
        if (iterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/storage/SourceToOutputMappingImpl", "getSourcesIterator"));
        }
        return iterator;
    }

    public void flush(boolean memoryCachesOnly) {
        this.myMapping.flush(memoryCachesOnly);
    }

    public void close() throws IOException {
        this.myMapping.close();
    }

    public void clean() throws IOException {
        this.myMapping.clean();
    }
}

