/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.instructions;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactCompilerInstructionCreator;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactCompilerInstructionCreatorBase;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactInstructionsBuilderImpl;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.JarDestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.JarInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.SkipAllInstructionCreator;

public class PackIntoArchiveInstructionCreator
extends ArtifactCompilerInstructionCreatorBase {
    private final DestinationInfo myJarDestination;
    private final JarInfo myJarInfo;
    private final String myPathInJar;

    public PackIntoArchiveInstructionCreator(ArtifactInstructionsBuilderImpl builder, JarInfo jarInfo, String pathInJar, DestinationInfo jarDestination) {
        super(builder);
        this.myJarInfo = jarInfo;
        this.myPathInJar = pathInJar;
        this.myJarDestination = jarDestination;
    }

    @Override
    @Nullable
    protected DestinationInfo createDirectoryDestination() {
        return new JarDestinationInfo(this.myPathInJar, this.myJarInfo, this.myJarDestination);
    }

    @Override
    protected JarDestinationInfo createFileDestination(@NotNull String pathInJar) {
        if (pathInJar == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/artifacts/instructions/PackIntoArchiveInstructionCreator", "createFileDestination"));
        }
        return new JarDestinationInfo(this.childPathInJar(pathInJar), this.myJarInfo, this.myJarDestination);
    }

    @Override
    protected void onAdded(ArtifactRootDescriptor descriptor) {
        this.myJarInfo.addContent(StringUtil.trimStart((String)((JarDestinationInfo)descriptor.getDestinationInfo()).getPathInJar(), (String)"/"), descriptor);
    }

    private String childPathInJar(String fileName) {
        return this.myPathInJar.length() == 0 ? fileName : this.myPathInJar + "/" + fileName;
    }

    @Override
    public PackIntoArchiveInstructionCreator subFolder(@NotNull String directoryName) {
        if (directoryName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/artifacts/instructions/PackIntoArchiveInstructionCreator", "subFolder"));
        }
        return new PackIntoArchiveInstructionCreator(this.myInstructionsBuilder, this.myJarInfo, this.childPathInJar(directoryName), this.myJarDestination);
    }

    @Override
    public ArtifactCompilerInstructionCreator archive(@NotNull String archiveFileName) {
        String outputPath;
        if (archiveFileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/artifacts/instructions/PackIntoArchiveInstructionCreator", "archive"));
        }
        JarDestinationInfo destination = this.createFileDestination(archiveFileName);
        JarInfo jarInfo = new JarInfo(destination);
        if (!this.myInstructionsBuilder.registerJarFile(jarInfo, outputPath = this.myJarDestination.getOutputPath() + "/" + archiveFileName)) {
            return new SkipAllInstructionCreator(this.myInstructionsBuilder);
        }
        this.myJarInfo.addJar(destination.getPathInJar(), jarInfo);
        return new PackIntoArchiveInstructionCreator(this.myInstructionsBuilder, jarInfo, "", destination);
    }
}

