/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.instructions;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.artifacts.instructions.FileCopyingHandler;

public class FilterCopyHandler
extends FileCopyingHandler {
    private final FileFilter myFilter;

    public FilterCopyHandler(@NotNull FileFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/artifacts/instructions/FilterCopyHandler", "<init>"));
        }
        this.myFilter = filter;
    }

    @Override
    public void copyFile(@NotNull File from, @NotNull File to, @NotNull CompileContext context) throws IOException {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/artifacts/instructions/FilterCopyHandler", "copyFile"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/incremental/artifacts/instructions/FilterCopyHandler", "copyFile"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/jps/incremental/artifacts/instructions/FilterCopyHandler", "copyFile"));
        }
        FileUtil.copyContent((File)from, (File)to);
    }

    @Override
    public void writeConfiguration(@NotNull PrintWriter out) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/artifacts/instructions/FilterCopyHandler", "writeConfiguration"));
        }
    }

    @Override
    @NotNull
    public FileFilter createFileFilter() {
        FileFilter fileFilter = this.myFilter;
        if (fileFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/artifacts/instructions/FilterCopyHandler", "createFileFilter"));
        }
        return fileFilter;
    }
}

