/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.artifacts.JpsBuilderArtifactService;
import org.jetbrains.jps.incremental.artifacts.impl.JpsArtifactUtil;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactOutputPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;

public class ArtifactSorter {
    private final JpsModel myModel;
    private Map<JpsArtifact, JpsArtifact> myArtifactToSelfIncludingName;
    private List<JpsArtifact> mySortedArtifacts;

    public ArtifactSorter(JpsModel model) {
        this.myModel = model;
    }

    public Map<JpsArtifact, JpsArtifact> getArtifactToSelfIncludingNameMap() {
        if (this.myArtifactToSelfIncludingName == null) {
            this.myArtifactToSelfIncludingName = this.computeArtifactToSelfIncludingNameMap();
        }
        return this.myArtifactToSelfIncludingName;
    }

    public List<JpsArtifact> getArtifactsSortedByInclusion() {
        if (this.mySortedArtifacts == null) {
            this.mySortedArtifacts = this.doGetSortedArtifacts();
        }
        return this.mySortedArtifacts;
    }

    private List<JpsArtifact> doGetSortedArtifacts() {
        GraphGenerator<JpsArtifact> graph = this.createArtifactsGraph();
        DFSTBuilder builder = new DFSTBuilder(graph);
        builder.buildDFST();
        ArrayList<JpsArtifact> names = new ArrayList<JpsArtifact>();
        names.addAll(graph.getNodes());
        Collections.sort(names, builder.comparator());
        return names;
    }

    private Map<JpsArtifact, JpsArtifact> computeArtifactToSelfIncludingNameMap() {
        final HashMap<JpsArtifact, JpsArtifact> result = new HashMap<JpsArtifact, JpsArtifact>();
        GraphGenerator<JpsArtifact> graph = this.createArtifactsGraph();
        block0: for (JpsArtifact artifact : graph.getNodes()) {
            Iterator in = graph.getIn((Object)artifact);
            while (in.hasNext()) {
                JpsArtifact next = (JpsArtifact)in.next();
                if (!next.equals(artifact)) continue;
                result.put(artifact, artifact);
                continue block0;
            }
        }
        final DFSTBuilder builder = new DFSTBuilder(graph);
        builder.buildDFST();
        if (builder.isAcyclic() && result.isEmpty()) {
            return Collections.emptyMap();
        }
        TIntArrayList sccs = builder.getSCCs();
        sccs.forEach(new TIntProcedure(){
            int myTNumber = 0;

            public boolean execute(int size) {
                if (size > 1) {
                    for (int j = 0; j < size; ++j) {
                        JpsArtifact artifact = (JpsArtifact)builder.getNodeByTNumber(this.myTNumber + j);
                        result.put(artifact, artifact);
                    }
                }
                this.myTNumber += size;
                return true;
            }
        });
        for (int i = 0; i < graph.getNodes().size(); ++i) {
            JpsArtifact artifact = (JpsArtifact)builder.getNodeByTNumber(i);
            if (result.containsKey(artifact)) continue;
            Iterator in = graph.getIn((Object)artifact);
            while (in.hasNext()) {
                JpsArtifact next = (JpsArtifact)result.get(in.next());
                if (next == null) continue;
                result.put(artifact, next);
            }
        }
        return result;
    }

    @NotNull
    public static Set<JpsArtifact> addIncludedArtifacts(@NotNull Collection<JpsArtifact> artifacts) {
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/artifacts/impl/ArtifactSorter", "addIncludedArtifacts"));
        }
        HashSet<JpsArtifact> result = new HashSet<JpsArtifact>();
        for (JpsArtifact artifact : artifacts) {
            ArtifactSorter.collectIncludedArtifacts(artifact, new HashSet<JpsArtifact>(), result, true);
        }
        HashSet<JpsArtifact> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/artifacts/impl/ArtifactSorter", "addIncludedArtifacts"));
        }
        return hashSet;
    }

    private static void collectIncludedArtifacts(JpsArtifact artifact, final Set<JpsArtifact> processed, final Set<JpsArtifact> result, final boolean withOutputPathOnly) {
        if (!processed.add(artifact)) {
            return;
        }
        if (!withOutputPathOnly || !StringUtil.isEmpty((String)artifact.getOutputPath())) {
            result.add(artifact);
        }
        ArtifactSorter.processIncludedArtifacts(artifact, new Consumer<JpsArtifact>(){

            public void consume(JpsArtifact included) {
                ArtifactSorter.collectIncludedArtifacts(included, processed, result, withOutputPathOnly);
            }
        });
    }

    private GraphGenerator<JpsArtifact> createArtifactsGraph() {
        return GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new ArtifactsGraph(this.myModel)));
    }

    private static void processIncludedArtifacts(JpsArtifact artifact, final Consumer<JpsArtifact> consumer) {
        JpsArtifactUtil.processPackagingElements((JpsPackagingElement)artifact.getRootElement(), new Processor<JpsPackagingElement>(){

            public boolean process(JpsPackagingElement element) {
                if (element instanceof JpsArtifactOutputPackagingElement) {
                    JpsArtifact included = (JpsArtifact)((JpsArtifactOutputPackagingElement)element).getArtifactReference().resolve();
                    if (included != null) {
                        consumer.consume((Object)included);
                    }
                    return false;
                }
                return true;
            }
        });
    }

    private static class ArtifactsGraph
    implements GraphGenerator.SemiGraph<JpsArtifact> {
        private final Set<JpsArtifact> myArtifactNodes;

        public ArtifactsGraph(JpsModel model) {
            this.myArtifactNodes = new LinkedHashSet<JpsArtifact>(JpsBuilderArtifactService.getInstance().getArtifacts(model, true));
        }

        public Collection<JpsArtifact> getNodes() {
            return this.myArtifactNodes;
        }

        public Iterator<JpsArtifact> getIn(JpsArtifact artifact) {
            final LinkedHashSet included = new LinkedHashSet();
            Consumer<JpsArtifact> consumer = new Consumer<JpsArtifact>(){

                public void consume(JpsArtifact artifact) {
                    if (ArtifactsGraph.this.myArtifactNodes.contains(artifact)) {
                        included.add(artifact);
                    }
                }
            };
            ArtifactSorter.processIncludedArtifacts(artifact, (Consumer<JpsArtifact>)((Consumer)consumer));
            return included.iterator();
        }
    }
}

