/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTarget;
import org.jetbrains.jps.incremental.artifacts.JpsBuilderArtifactService;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.artifact.JpsArtifact;

public class ArtifactBuildTargetType
extends BuildTargetType<ArtifactBuildTarget> {
    public static final ArtifactBuildTargetType INSTANCE = new ArtifactBuildTargetType();

    public ArtifactBuildTargetType() {
        super("artifact");
    }

    @Override
    @NotNull
    public List<ArtifactBuildTarget> computeAllTargets(@NotNull JpsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/artifacts/ArtifactBuildTargetType", "computeAllTargets"));
        }
        Collection<JpsArtifact> artifacts = JpsBuilderArtifactService.getInstance().getArtifacts(model, true);
        ArrayList<ArtifactBuildTarget> targets = new ArrayList<ArtifactBuildTarget>(artifacts.size());
        for (JpsArtifact artifact : artifacts) {
            if (StringUtil.isEmpty((String)artifact.getOutputPath())) continue;
            targets.add(new ArtifactBuildTarget(artifact));
        }
        ArrayList<ArtifactBuildTarget> arrayList = targets;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/artifacts/ArtifactBuildTargetType", "computeAllTargets"));
        }
        return arrayList;
    }

    @NotNull
    public Loader createLoader(@NotNull JpsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/artifacts/ArtifactBuildTargetType", "createLoader"));
        }
        Loader loader = new Loader(model);
        if (loader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/artifacts/ArtifactBuildTargetType", "createLoader"));
        }
        return loader;
    }

    private static class Loader
    extends BuildTargetLoader<ArtifactBuildTarget> {
        private final Map<String, JpsArtifact> myArtifacts = new HashMap<String, JpsArtifact>();

        public Loader(JpsModel model) {
            for (JpsArtifact artifact : JpsBuilderArtifactService.getInstance().getArtifacts(model, true)) {
                this.myArtifacts.put(artifact.getName(), artifact);
            }
        }

        @Override
        @Nullable
        public ArtifactBuildTarget createTarget(@NotNull String targetId) {
            if (targetId == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/artifacts/ArtifactBuildTargetType$Loader", "createTarget"));
            }
            JpsArtifact artifact = this.myArtifacts.get(targetId);
            return artifact != null ? new ArtifactBuildTarget(artifact) : null;
        }
    }
}

