/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.ConcurrentHashSet;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.MappingFailedException;
import com.intellij.util.io.PersistentEnumeratorBase;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.TimingLog;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.api.RequestFuture;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.builders.impl.DirtyFilesHolderBase;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.cmdline.BuildRunner;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BuildOperations;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.BuilderRegistry;
import org.jetbrains.jps.incremental.ChainedTargetsBuildListener;
import org.jetbrains.jps.incremental.ChunkBuildOutputConsumerImpl;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompileContextImpl;
import org.jetbrains.jps.incremental.CompileScope;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.FSCache;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.incremental.MessageHandler;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.RebuildRequestedException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.fs.BuildFSState;
import org.jetbrains.jps.incremental.java.ExternalJavacDescriptor;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.BuildingTargetProgressMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.DoneSomethingNotification;
import org.jetbrains.jps.incremental.messages.FileDeletedEvent;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.incremental.storage.BuildTargetConfiguration;
import org.jetbrains.jps.incremental.storage.OneToManyPathsMapping;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.service.SharedThreadPool;
import org.jetbrains.jps.util.JpsPathUtil;

public class IncProjectBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.IncProjectBuilder");
    private static final String CLASSPATH_INDEX_FINE_NAME = "classpath.index";
    private static final boolean GENERATE_CLASSPATH_INDEX = Boolean.parseBoolean(System.getProperty("generate.classpath.index", "false"));
    private static final GlobalContextKey<Set<BuildTarget<?>>> TARGET_WITH_CLEARED_OUTPUT = GlobalContextKey.create("_targets_with_cleared_output_");
    public static final int MAX_BUILDER_THREADS;
    private final ProjectDescriptor myProjectDescriptor;
    private final BuilderRegistry myBuilderRegistry;
    private final Map<String, String> myBuilderParams;
    private final CanceledStatus myCancelStatus;
    @Nullable
    private final Callbacks.ConstantAffectionResolver myConstantSearch;
    private final List<MessageHandler> myMessageHandlers = new ArrayList<MessageHandler>();
    private final MessageHandler myMessageDispatcher = new MessageHandler(){

        @Override
        public void processMessage(BuildMessage msg) {
            for (MessageHandler h : IncProjectBuilder.this.myMessageHandlers) {
                h.processMessage(msg);
            }
        }
    };
    private final boolean myIsTestMode;
    private volatile float myTargetsProcessed = 0.0f;
    private final float myTotalTargetsWork;
    private final int myTotalModuleLevelBuilderCount;
    private final List<Future> myAsyncTasks = Collections.synchronizedList(new ArrayList());

    public IncProjectBuilder(ProjectDescriptor pd, BuilderRegistry builderRegistry, Map<String, String> builderParams, CanceledStatus cs, @Nullable Callbacks.ConstantAffectionResolver constantSearch, boolean isTestMode) {
        this.myProjectDescriptor = pd;
        this.myBuilderRegistry = builderRegistry;
        this.myBuilderParams = builderParams;
        this.myCancelStatus = cs;
        this.myConstantSearch = constantSearch;
        this.myTotalTargetsWork = pd.getBuildTargetIndex().getAllTargets().size();
        this.myTotalModuleLevelBuilderCount = builderRegistry.getModuleLevelBuilderCount();
        this.myIsTestMode = isTestMode;
    }

    public void addMessageHandler(MessageHandler handler) {
        this.myMessageHandlers.add(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkUpToDate(CompileScope scope) {
        context = null;
        try {
            context = this.createContext(scope);
            fsState = this.myProjectDescriptor.fsState;
            i$ = this.myProjectDescriptor.getBuildTargetIndex().getAllTargets().iterator();
            block9: while (i$.hasNext() != false) {
                target = i$.next();
                if (!scope.isAffected(target)) continue;
                BuildOperations.ensureFSStateInitialized(context, target);
                var7_8 = toRecompile = fsState.getSourcesToRecompile(context, target);
                synchronized (var7_8) {
                    i$ = toRecompile.values().iterator();
                    while (true) {
                        if (i$.hasNext()) {
                            files = i$.next();
                            i$ = files.iterator();
                            ** break block14
                        }
                        continue block9;
                        break;
                    }
                }
            }
            return;
        }
        catch (Exception e) {
            IncProjectBuilder.LOG.info((Throwable)e);
            this.myMessageDispatcher.processMessage(DoneSomethingNotification.INSTANCE);
            return;
        }
        finally {
            if (context != null) {
                IncProjectBuilder.flushContext(context);
            }
        }
lbl-1000:
        // 1 sources

        {
            do {
                if (!i$.hasNext()) ** continue;
            } while (!scope.isAffected(target, file = i$.next()));
            this.myMessageDispatcher.processMessage(DoneSomethingNotification.INSTANCE);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build(CompileScope scope, boolean forceCleanCaches) throws RebuildRequestedException {
        memWatcher = LowMemoryWatcher.register((Runnable)new Runnable(){

            @Override
            public void run() {
                ((IncProjectBuilder)IncProjectBuilder.this).myProjectDescriptor.dataManager.flush(false);
                ((IncProjectBuilder)IncProjectBuilder.this).myProjectDescriptor.timestamps.getStorage().force();
            }
        });
        this.startTempDirectoryCleanupTask();
        context = null;
        try {
            context = this.createContext(scope);
            this.runBuild(context, forceCleanCaches);
            this.myProjectDescriptor.dataManager.saveVersion();
            IncProjectBuilder.reportRebuiltModules(context);
        }
        catch (StopBuildException e) {
            block31: {
                IncProjectBuilder.reportRebuiltModules(context);
                msg = e.getMessage();
                if (StringUtil.isEmptyOrSpaces((String)msg)) break block31;
                this.myMessageDispatcher.processMessage(new ProgressMessage((String)msg));
            }
            memWatcher.stop();
            IncProjectBuilder.flushContext(context);
            status = context == null ? CanceledStatus.NULL : context.getCancelStatus();
            msg = this.myAsyncTasks;
            synchronized (msg) {
                i$ = this.myAsyncTasks.iterator();
                while (i$.hasNext() != false) {
                    task = i$.next();
                    if (status.isCanceled()) {
                        return;
                    }
                    IncProjectBuilder.waitForTask(status, task);
                }
                return;
            }
            catch (BuildDataCorruptedException e) {
                IncProjectBuilder.LOG.info((Throwable)e);
                this.requestRebuild(e, e);
                memWatcher.stop();
                IncProjectBuilder.flushContext(context);
                status = context == null ? CanceledStatus.NULL : context.getCancelStatus();
                msg = this.myAsyncTasks;
                synchronized (msg) {
                    i$ = this.myAsyncTasks.iterator();
                    while (i$.hasNext() != false) {
                        task = i$.next();
                        if (status.isCanceled()) {
                            return;
                        }
                        IncProjectBuilder.waitForTask(status, task);
                    }
                    return;
                }
                catch (ProjectBuildException e) {
                    block32: {
                        try {
                            IncProjectBuilder.LOG.info((Throwable)e);
                            cause = e.getCause();
                            if (cause instanceof PersistentEnumeratorBase.CorruptedException || cause instanceof MappingFailedException || cause instanceof IOException || cause instanceof BuildDataCorruptedException) {
                                this.requestRebuild(e, cause);
                                break block32;
                            }
                            errMessage = e.getMessage();
                            if (StringUtil.isEmptyOrSpaces((String)errMessage)) {
                                msg = new CompilerMessage("", cause != null ? cause : e);
                            } else {
                                causeMessage = cause != null ? cause.getMessage() : "";
                                msg = new CompilerMessage("", BuildMessage.Kind.ERROR, StringUtil.isEmptyOrSpaces((String)causeMessage) != false || errMessage.trim().endsWith(causeMessage) != false ? errMessage : errMessage + ": " + causeMessage);
                            }
                            this.myMessageDispatcher.processMessage(msg);
                        }
                        catch (Throwable var13_25) {
                            memWatcher.stop();
                            IncProjectBuilder.flushContext(context);
                            status = context == null ? CanceledStatus.NULL : context.getCancelStatus();
                            var15_27 = this.myAsyncTasks;
                            synchronized (var15_27) {
                                ** break block33
                            }
lbl-1000:
                            // 2 sources

                            {
                                while (i$.hasNext() != false) {
                                    task = i$.next();
                                    if (status.isCanceled()) {
                                        return;
                                    }
                                    IncProjectBuilder.waitForTask(status, task);
                                }
                                return;
                            }
lbl-1000:
                            // 2 sources

                            {
                                while (i$.hasNext() != false) {
                                    task = i$.next();
                                    if (status.isCanceled()) {
                                        return;
                                    }
                                    IncProjectBuilder.waitForTask(status, task);
                                }
                                return;
                            }
lbl-1000:
                            // 1 sources

                            {
                                i$ = this.myAsyncTasks.iterator();
                                while (i$.hasNext() != false) {
                                    task = i$.next();
                                    if (status.isCanceled()) {
                                        throw var13_25;
                                    }
                                    IncProjectBuilder.waitForTask(status, task);
                                }
                                throw var13_25;
                            }
                        }
                    }
                    memWatcher.stop();
                    IncProjectBuilder.flushContext(context);
                    status = context == null ? CanceledStatus.NULL : context.getCancelStatus();
                    var6_15 = this.myAsyncTasks;
                    synchronized (var6_15) {
                        i$ = this.myAsyncTasks.iterator();
                        ** GOTO lbl-1000
                    }
                }
            }
        }
        memWatcher.stop();
        IncProjectBuilder.flushContext(context);
        status = context == null ? CanceledStatus.NULL : context.getCancelStatus();
        var6_12 = this.myAsyncTasks;
        synchronized (var6_12) {
            i$ = this.myAsyncTasks.iterator();
            ** GOTO lbl-1000
        }
    }

    private void requestRebuild(Exception e, Throwable cause) throws RebuildRequestedException {
        this.myMessageDispatcher.processMessage(new CompilerMessage("", BuildMessage.Kind.INFO, "Internal caches are corrupted or have outdated format, forcing project rebuild: " + e.getMessage()));
        throw new RebuildRequestedException(cause);
    }

    private static void waitForTask(@NotNull CanceledStatus status, Future task) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/IncProjectBuilder", "waitForTask"));
        }
        try {
            while (true) {
                try {
                    task.get(500L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException ignored) {
                    if (!status.isCanceled()) continue;
                }
                break;
            }
        }
        catch (Throwable th) {
            LOG.info(th);
        }
    }

    private static void reportRebuiltModules(CompileContextImpl context) {
        Set modules = (Set)BuildTargetConfiguration.MODULES_WITH_TARGET_CONFIG_CHANGED_KEY.get((UserDataHolder)context);
        if (modules == null || modules.isEmpty()) {
            return;
        }
        StringBuilder message = new StringBuilder();
        if (modules.size() > 1) {
            message.append("Modules ");
            int namesLimit = 5;
            int idx = 0;
            Iterator iterator = modules.iterator();
            while (iterator.hasNext()) {
                JpsModule module = (JpsModule)iterator.next();
                if (idx == 5 && iterator.hasNext()) {
                    message.append(" and ").append(modules.size() - 5).append(" others");
                    break;
                }
                if (idx > 0) {
                    message.append(", ");
                }
                message.append("\"").append(module.getName()).append("\"");
                ++idx;
            }
            message.append(" were");
        } else {
            message.append("Module \"").append(((JpsModule)modules.iterator().next()).getName()).append("\" was");
        }
        message.append(" fully rebuilt due to project configuration");
        if (ModuleBuildTarget.REBUILD_ON_DEPENDENCY_CHANGE.booleanValue()) {
            message.append("/dependencies");
        }
        message.append(" changes");
        context.processMessage(new CompilerMessage("", BuildMessage.Kind.INFO, message.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void flushContext(CompileContext context) {
        ExternalJavacDescriptor descriptor;
        if (context != null) {
            ProjectDescriptor pd = context.getProjectDescriptor();
            pd.timestamps.getStorage().force();
            pd.dataManager.flush(false);
        }
        if ((descriptor = (ExternalJavacDescriptor)ExternalJavacDescriptor.KEY.get(context)) != null) {
            try {
                RequestFuture future = descriptor.client.sendShutdownRequest();
                future.waitFor(500L, TimeUnit.MILLISECONDS);
            }
            finally {
                descriptor.process.destroyProcess();
            }
            ExternalJavacDescriptor.KEY.set(context, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBuild(CompileContextImpl context, boolean forceCleanCaches) throws ProjectBuildException {
        context.setDone(0.0f);
        LOG.info("Building project; isRebuild:" + context.isProjectRebuild() + "; isMake:" + context.isMake() + " parallel compilation:" + BuildRunner.PARALLEL_BUILD_ENABLED);
        context.addBuildListener(new ChainedTargetsBuildListener(context));
        for (TargetBuilder<?, ?> targetBuilder : this.myBuilderRegistry.getTargetBuilders()) {
            targetBuilder.buildStarted(context);
        }
        for (ModuleLevelBuilder moduleLevelBuilder : this.myBuilderRegistry.getModuleLevelBuilders()) {
            moduleLevelBuilder.buildStarted(context);
        }
        try {
            if (context.isProjectRebuild() || forceCleanCaches) {
                this.cleanOutputRoots(context);
            }
            context.processMessage(new ProgressMessage("Running 'before' tasks"));
            IncProjectBuilder.runTasks(context, this.myBuilderRegistry.getBeforeTasks());
            TimingLog.LOG.debug("'before' tasks finished");
            context.processMessage(new ProgressMessage("Checking sources"));
            this.buildChunks(context);
            TimingLog.LOG.debug("Building targets finished");
            context.processMessage(new ProgressMessage("Running 'after' tasks"));
            IncProjectBuilder.runTasks(context, this.myBuilderRegistry.getAfterTasks());
            TimingLog.LOG.debug("'after' tasks finished");
        }
        catch (Throwable throwable) {
            for (TargetBuilder<?, ?> targetBuilder : this.myBuilderRegistry.getTargetBuilders()) {
                targetBuilder.buildFinished(context);
            }
            for (ModuleLevelBuilder moduleLevelBuilder : this.myBuilderRegistry.getModuleLevelBuilders()) {
                moduleLevelBuilder.buildFinished(context);
            }
            context.processMessage(new ProgressMessage("Finished, saving caches..."));
            throw throwable;
        }
        for (TargetBuilder targetBuilder : this.myBuilderRegistry.getTargetBuilders()) {
            targetBuilder.buildFinished(context);
        }
        for (ModuleLevelBuilder moduleLevelBuilder : this.myBuilderRegistry.getModuleLevelBuilders()) {
            moduleLevelBuilder.buildFinished(context);
        }
        context.processMessage(new ProgressMessage("Finished, saving caches..."));
    }

    private void startTempDirectoryCleanupTask() {
        File systemRoot = Utils.getSystemRoot();
        String tempPath = System.getProperty("java.io.tmpdir", null);
        if (StringUtil.isEmptyOrSpaces((String)tempPath)) {
            return;
        }
        File tempDir = new File(tempPath);
        if (!FileUtil.isAncestor((File)systemRoot, (File)tempDir, (boolean)true)) {
            return;
        }
        final File[] files = tempDir.listFiles();
        if (files != null && files.length != 0) {
            FutureTask<Object> task = new FutureTask<Object>(new Runnable(){

                @Override
                public void run() {
                    for (File tempFile : files) {
                        FileUtil.delete((File)tempFile);
                    }
                }
            }, null);
            Thread thread = new Thread(task, "Temp directory cleanup");
            thread.setPriority(1);
            thread.setDaemon(true);
            thread.start();
            this.myAsyncTasks.add(task);
        }
    }

    private CompileContextImpl createContext(CompileScope scope) throws ProjectBuildException {
        CompileContextImpl context = new CompileContextImpl(scope, this.myProjectDescriptor, this.myMessageDispatcher, this.myBuilderParams, this.myCancelStatus);
        this.myProjectDescriptor.setFSCache(context.isProjectRebuild() ? FSCache.NO_CACHE : new FSCache());
        JavaBuilderUtil.CONSTANT_SEARCH_SERVICE.set((UserDataHolder)context, (Object)this.myConstantSearch);
        return context;
    }

    private void cleanOutputRoots(CompileContext context) throws ProjectBuildException {
        ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
        JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(projectDescriptor.getProject());
        boolean shouldClear = configuration.isClearOutputDirectoryOnRebuild();
        if (shouldClear) {
            this.clearOutputs(context);
        } else {
            for (BuildTarget<?> target : projectDescriptor.getBuildTargetIndex().getAllTargets()) {
                if (!context.getScope().isAffected(target)) continue;
                IncProjectBuilder.clearOutputFilesUninterruptibly(context, target);
            }
        }
        try {
            projectDescriptor.timestamps.getStorage().clean();
        }
        catch (IOException e) {
            throw new ProjectBuildException("Error cleaning timestamps storage", e);
        }
        try {
            projectDescriptor.dataManager.clean();
        }
        catch (IOException e) {
            throw new ProjectBuildException("Error cleaning compiler storages", e);
        }
        this.myProjectDescriptor.fsState.clearAll();
    }

    public static void clearOutputFiles(CompileContext context, BuildTarget<?> target) throws IOException {
        SourceToOutputMapping map = context.getProjectDescriptor().dataManager.getSourceToOutputMap(target);
        THashSet dirsToDelete = target instanceof ModuleBasedTarget ? new THashSet(FileUtil.FILE_HASHING_STRATEGY) : null;
        for (String srcPath : map.getSources()) {
            Collection<String> outs = map.getOutputs(srcPath);
            if (outs == null || outs.isEmpty()) continue;
            ArrayList<String> deletedPaths = new ArrayList<String>();
            for (String out : outs) {
                BuildOperations.deleteRecursively(out, deletedPaths, (Set<File>)dirsToDelete);
            }
            if (deletedPaths.isEmpty()) continue;
            context.processMessage(new FileDeletedEvent(deletedPaths));
        }
        IncProjectBuilder.registerTargetsWithClearedOutput(context, Collections.singletonList(target));
        if (dirsToDelete != null) {
            FSOperations.pruneEmptyDirs(context, (Set<File>)dirsToDelete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerTargetsWithClearedOutput(CompileContext context, Collection<? extends BuildTarget<?>> targets) {
        GlobalContextKey<Set<BuildTarget<?>>> globalContextKey = TARGET_WITH_CLEARED_OUTPUT;
        synchronized (globalContextKey) {
            Set data = (Set)context.getUserData(TARGET_WITH_CLEARED_OUTPUT);
            if (data == null) {
                data = new THashSet();
                context.putUserData(TARGET_WITH_CLEARED_OUTPUT, data);
            }
            data.addAll(targets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isTargetOutputCleared(CompileContext context, BuildTarget<?> target) {
        GlobalContextKey<Set<BuildTarget<?>>> globalContextKey = TARGET_WITH_CLEARED_OUTPUT;
        synchronized (globalContextKey) {
            Set data = (Set)context.getUserData(TARGET_WITH_CLEARED_OUTPUT);
            return data != null && data.contains(target);
        }
    }

    private void clearOutputs(CompileContext context) throws ProjectBuildException {
        MultiMap rootsToDelete = MultiMap.createSet();
        HashSet<File> allSourceRoots = new HashSet<File>();
        ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
        List<BuildTarget<?>> allTargets = projectDescriptor.getBuildTargetIndex().getAllTargets();
        for (BuildTarget<?> target : allTargets) {
            if (!context.getScope().isAffected(target)) continue;
            Collection<File> outputs = target.getOutputRoots(context);
            for (File file : outputs) {
                rootsToDelete.putValue((Object)file, target);
            }
        }
        ModuleExcludeIndex moduleIndex = projectDescriptor.getModuleExcludeIndex();
        for (BuildTarget<?> target : allTargets) {
            for (BuildRootDescriptor descriptor : projectDescriptor.getBuildRootIndex().getTargetRoots(target, context)) {
                File rootFile;
                if (descriptor.isGenerated() || !moduleIndex.isInContent(rootFile = descriptor.getRootFile()) || moduleIndex.isExcluded(rootFile)) continue;
                allSourceRoots.add(rootFile);
            }
        }
        ArrayList<File> filesToDelete = new ArrayList<File>();
        for (Map.Entry entry : rootsToDelete.entrySet()) {
            context.checkCanceled();
            boolean okToDelete = true;
            File outputRoot = (File)entry.getKey();
            if (!moduleIndex.isExcluded(outputRoot)) {
                if (JpsPathUtil.isUnder(allSourceRoots, (File)outputRoot)) {
                    okToDelete = false;
                } else {
                    Set<File> _outRoot = Collections.singleton(outputRoot);
                    for (File srcRoot : allSourceRoots) {
                        if (!JpsPathUtil.isUnder(_outRoot, (File)srcRoot)) continue;
                        okToDelete = false;
                        break;
                    }
                }
            }
            if (okToDelete) {
                File[] children = outputRoot.listFiles();
                if (children != null) {
                    for (File child : children) {
                        if (child.delete()) continue;
                        filesToDelete.add(child);
                    }
                } else if (!outputRoot.delete()) {
                    filesToDelete.add(outputRoot);
                }
                IncProjectBuilder.registerTargetsWithClearedOutput(context, (Collection)entry.getValue());
                continue;
            }
            context.processMessage(new CompilerMessage("", BuildMessage.Kind.WARNING, "Output path " + outputRoot.getPath() + " intersects with a source root. Only files that were created by build will be cleaned."));
            for (BuildTarget target : (Collection)entry.getValue()) {
                IncProjectBuilder.clearOutputFilesUninterruptibly(context, target);
            }
        }
        context.processMessage(new ProgressMessage("Cleaning output directories..."));
        this.myAsyncTasks.add(FileUtil.asyncDelete(filesToDelete));
    }

    private static void clearOutputFilesUninterruptibly(CompileContext context, BuildTarget<?> target) {
        try {
            IncProjectBuilder.clearOutputFiles(context, target);
        }
        catch (Throwable e) {
            LOG.info(e);
            String reason = e.getMessage();
            if (reason == null) {
                reason = e.getClass().getName();
            }
            context.processMessage(new CompilerMessage("", BuildMessage.Kind.WARNING, "Problems clearing output files for target \"" + target.getPresentableName() + "\": " + reason));
        }
    }

    private static void runTasks(CompileContext context, List<BuildTask> tasks) throws ProjectBuildException {
        for (BuildTask task : tasks) {
            task.build(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildChunks(CompileContextImpl context) throws ProjectBuildException {
        try {
            if (BuildRunner.PARALLEL_BUILD_ENABLED && MAX_BUILDER_THREADS > 1) {
                new BuildParallelizer(context).buildInParallel();
            } else {
                CompileScope scope = context.getScope();
                ProjectDescriptor pd = context.getProjectDescriptor();
                BuildTargetIndex targetIndex = pd.getBuildTargetIndex();
                for (BuildTargetChunk chunk : targetIndex.getSortedTargetChunks(context)) {
                    try {
                        this.buildChunkIfAffected(context, scope, chunk);
                    }
                    finally {
                        context.updateCompilationStartStamp();
                        pd.dataManager.closeSourceToOutputStorages(Collections.singleton(chunk));
                        pd.dataManager.flush(true);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ProjectBuildException(e);
        }
    }

    private void buildChunkIfAffected(CompileContext context, CompileScope scope, BuildTargetChunk chunk) throws ProjectBuildException {
        if (IncProjectBuilder.isAffected(scope, chunk)) {
            this.buildTargetsChunk(context, chunk);
        } else {
            this.updateDoneFraction(context, chunk.getTargets().size());
        }
    }

    private static boolean isAffected(CompileScope scope, BuildTargetChunk chunk) {
        for (BuildTarget<?> target : chunk.getTargets()) {
            if (!scope.isAffected(target)) continue;
            return true;
        }
        return false;
    }

    private boolean runBuildersForChunk(CompileContext context, BuildTargetChunk chunk) throws ProjectBuildException, IOException {
        Set<BuildTarget<?>> targets = chunk.getTargets();
        if (targets.size() > 1) {
            HashSet<ModuleBuildTarget> moduleTargets = new HashSet<ModuleBuildTarget>();
            for (BuildTarget<?> target : targets) {
                if (target instanceof ModuleBuildTarget) {
                    moduleTargets.add((ModuleBuildTarget)target);
                    continue;
                }
                context.processMessage(new CompilerMessage("", BuildMessage.Kind.ERROR, "Cannot build " + target.getPresentableName() + " because it is included into a circular dependency"));
                return false;
            }
            return this.runModuleLevelBuilders(context, new ModuleChunk(moduleTargets));
        }
        BuildTarget<?> target = targets.iterator().next();
        if (target instanceof ModuleBuildTarget) {
            return this.runModuleLevelBuilders(context, new ModuleChunk(Collections.singleton((ModuleBuildTarget)target)));
        }
        IncProjectBuilder.cleanOldOutputs(context, target);
        List<TargetBuilder<?, ?>> builders = BuilderRegistry.getInstance().getTargetBuilders();
        for (TargetBuilder<?, ?> builder : builders) {
            BuildOperations.buildTarget(target, context, builder);
            this.updateDoneFraction(context, 1.0f / (float)builders.size());
        }
        return true;
    }

    private static <T extends BuildRootDescriptor> void cleanOldOutputs(final CompileContext context, final BuildTarget<T> target) throws ProjectBuildException, IOException {
        if (!context.getScope().isBuildForced(target)) {
            BuildOperations.cleanOutputsCorrespondingToChangedFiles(context, new DirtyFilesHolderBase<T, BuildTarget<T>>(context){

                @Override
                public void processDirtyFiles(@NotNull FileProcessor<T, BuildTarget<T>> processor) throws IOException {
                    if (processor == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/IncProjectBuilder$4", "processDirtyFiles"));
                    }
                    context.getProjectDescriptor().fsState.processFilesToRecompile(context, target, processor);
                }
            });
        }
    }

    private void updateDoneFraction(CompileContext context, float delta) {
        this.myTargetsProcessed += delta;
        float processed = this.myTargetsProcessed;
        context.setDone(processed / this.myTotalTargetsWork);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildTargetsChunk(CompileContext context, BuildTargetChunk chunk) throws ProjectBuildException {
        try {
            this.sendBuildingTargetMessages(chunk.getTargets(), BuildingTargetProgressMessage.Event.STARTED);
            Utils.ERRORS_DETECTED_KEY.set((UserDataHolder)context, (Object)Boolean.FALSE);
            for (BuildTarget<?> buildTarget : chunk.getTargets()) {
                BuildOperations.ensureFSStateInitialized(context, buildTarget);
            }
            boolean doneSomething = this.processDeletedPaths(context, chunk.getTargets());
            this.myProjectDescriptor.fsState.beforeChunkBuildStart(context, chunk);
            doneSomething |= this.runBuildersForChunk(context, chunk);
            IncProjectBuilder.onChunkBuildComplete(context, chunk);
        }
        catch (BuildDataCorruptedException e) {
            try {
                throw e;
                catch (ProjectBuildException e2) {
                    throw e2;
                }
                catch (Throwable e3) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(chunk.getPresentableName()).append(": ").append(e3.getClass().getName());
                    String exceptionMessage = e3.getMessage();
                    if (exceptionMessage == null) throw new ProjectBuildException(stringBuilder.toString(), e3);
                    stringBuilder.append(": ").append(exceptionMessage);
                    throw new ProjectBuildException(stringBuilder.toString(), e3);
                }
            }
            catch (Throwable throwable) {
                for (BuildRootDescriptor buildRootDescriptor : context.getProjectDescriptor().getBuildRootIndex().clearTempRoots(context)) {
                    context.getProjectDescriptor().fsState.clearRecompile(buildRootDescriptor);
                }
                try {
                    Map map = (Map)Utils.REMOVED_SOURCES_KEY.get((UserDataHolder)context);
                    if (map != null) {
                        for (Map.Entry entry : map.entrySet()) {
                            BuildTarget target = (BuildTarget)entry.getKey();
                            Collection paths = (Collection)entry.getValue();
                            if (paths == null) continue;
                            for (String path : paths) {
                                this.myProjectDescriptor.fsState.registerDeleted(target, new File(path), null);
                            }
                        }
                    }
                }
                catch (IOException e4) {
                    throw new ProjectBuildException(e4);
                }
                finally {
                    Utils.REMOVED_SOURCES_KEY.set((UserDataHolder)context, null);
                }
                this.sendBuildingTargetMessages(chunk.getTargets(), BuildingTargetProgressMessage.Event.FINISHED);
                throw throwable;
            }
        }
        for (BuildRootDescriptor buildRootDescriptor : context.getProjectDescriptor().getBuildRootIndex().clearTempRoots(context)) {
            context.getProjectDescriptor().fsState.clearRecompile(buildRootDescriptor);
        }
        try {
            Map map = (Map)Utils.REMOVED_SOURCES_KEY.get((UserDataHolder)context);
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    BuildTarget target = (BuildTarget)entry.getKey();
                    Collection paths = (Collection)entry.getValue();
                    if (paths == null) continue;
                    for (String path : paths) {
                        this.myProjectDescriptor.fsState.registerDeleted(target, new File(path), null);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ProjectBuildException(e);
        }
        finally {
            Utils.REMOVED_SOURCES_KEY.set((UserDataHolder)context, null);
        }
        this.sendBuildingTargetMessages(chunk.getTargets(), BuildingTargetProgressMessage.Event.FINISHED);
    }

    private void sendBuildingTargetMessages(@NotNull Set<? extends BuildTarget<?>> targets, @NotNull BuildingTargetProgressMessage.Event event) {
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/IncProjectBuilder", "sendBuildingTargetMessages"));
        }
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/incremental/IncProjectBuilder", "sendBuildingTargetMessages"));
        }
        this.myMessageDispatcher.processMessage(new BuildingTargetProgressMessage(targets, event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createClasspathIndex(BuildTargetChunk chunk) {
        THashSet outputDirs = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        for (BuildTarget<?> target : chunk.getTargets()) {
            File outputDir;
            if (!(target instanceof ModuleBuildTarget) || (outputDir = ((ModuleBuildTarget)target).getOutputDir()) == null || !outputDirs.add(outputDir)) continue;
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(new File(outputDir, CLASSPATH_INDEX_FINE_NAME)));
                try {
                    IncProjectBuilder.writeIndex(writer, outputDir, "");
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static void writeIndex(BufferedWriter writer, File file, String path) throws IOException {
        writer.write(path);
        writer.write(10);
        File[] files = file.listFiles();
        if (files != null) {
            for (File child : files) {
                String _path = path.isEmpty() ? child.getName() : path + "/" + child.getName();
                IncProjectBuilder.writeIndex(writer, child, _path);
            }
        }
    }

    private boolean processDeletedPaths(CompileContext context, Set<? extends BuildTarget<?>> targets) throws ProjectBuildException {
        boolean doneSomething = false;
        try {
            HashMap<BuildTarget<Object>, Collection<String>> targetToRemovedSources = new HashMap<BuildTarget<Object>, Collection<String>>();
            THashSet dirsToDelete = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            for (BuildTarget<?> target : targets) {
                Collection<String> pathsForIteration;
                Collection<String> deletedPaths = this.myProjectDescriptor.fsState.getAndClearDeletedPaths(target);
                if (deletedPaths.isEmpty()) continue;
                targetToRemovedSources.put(target, deletedPaths);
                if (IncProjectBuilder.isTargetOutputCleared(context, target)) continue;
                boolean shouldPruneEmptyDirs = target instanceof ModuleBasedTarget;
                SourceToOutputMapping sourceToOutputStorage = context.getProjectDescriptor().dataManager.getSourceToOutputMap(target);
                ProjectBuilderLogger logger = context.getLoggingManager().getProjectBuilderLogger();
                if (this.myIsTestMode) {
                    pathsForIteration = new ArrayList<String>(deletedPaths);
                    Collections.sort((List)pathsForIteration);
                } else {
                    pathsForIteration = deletedPaths;
                }
                for (String deletedSource : pathsForIteration) {
                    OneToManyPathsMapping sourceToFormMap;
                    Collection<String> boundForms;
                    Collection<String> outputs = sourceToOutputStorage.getOutputs(deletedSource);
                    if (outputs != null && !outputs.isEmpty()) {
                        ArrayList<String> deletedOutputPaths = new ArrayList<String>();
                        for (String output : outputs) {
                            boolean deleted = BuildOperations.deleteRecursively(output, deletedOutputPaths, (Set<File>)(shouldPruneEmptyDirs ? dirsToDelete : null));
                            if (!deleted) continue;
                            doneSomething = true;
                        }
                        if (!deletedOutputPaths.isEmpty()) {
                            if (logger.isEnabled()) {
                                logger.logDeletedFiles(deletedOutputPaths);
                            }
                            context.processMessage(new FileDeletedEvent(deletedOutputPaths));
                        }
                    }
                    if (!(target instanceof ModuleBuildTarget) || (boundForms = (sourceToFormMap = context.getProjectDescriptor().dataManager.getSourceToFormMap()).getState(deletedSource)) == null) continue;
                    for (String formPath : boundForms) {
                        File formFile = new File(formPath);
                        if (!formFile.exists()) continue;
                        FSOperations.markDirty(context, formFile);
                    }
                    sourceToFormMap.remove(deletedSource);
                }
            }
            if (!targetToRemovedSources.isEmpty()) {
                Map existing = (Map)Utils.REMOVED_SOURCES_KEY.get((UserDataHolder)context);
                if (existing != null) {
                    for (Map.Entry entry : existing.entrySet()) {
                        Collection paths = (Collection)targetToRemovedSources.get(entry.getKey());
                        if (paths != null) {
                            paths.addAll((Collection)entry.getValue());
                            continue;
                        }
                        targetToRemovedSources.put((BuildTarget<Object>)entry.getKey(), (Collection<String>)entry.getValue());
                    }
                }
                Utils.REMOVED_SOURCES_KEY.set((UserDataHolder)context, targetToRemovedSources);
            }
            FSOperations.pruneEmptyDirs(context, (Set<File>)dirsToDelete);
        }
        catch (IOException e) {
            throw new ProjectBuildException(e);
        }
        return doneSomething;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runModuleLevelBuilders(final CompileContext context, final ModuleChunk chunk) throws ProjectBuildException, IOException {
        for (BuilderCategory category : BuilderCategory.values()) {
            for (ModuleLevelBuilder builder : this.myBuilderRegistry.getBuilders(category)) {
                builder.chunkBuildStarted(context, chunk);
            }
        }
        boolean doneSomething = false;
        boolean rebuildFromScratchRequested = false;
        float stageCount = this.myTotalModuleLevelBuilderCount;
        int modulesInChunk = chunk.getModules().size();
        int buildersPassed = 0;
        ChunkBuildOutputConsumerImpl outputConsumer = new ChunkBuildOutputConsumerImpl(context);
        try {
            boolean nextPassRequired;
            block7: do {
                nextPassRequired = false;
                this.myProjectDescriptor.fsState.beforeNextRoundStart(context, chunk);
                DirtyFilesHolderBase<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder = new DirtyFilesHolderBase<JavaSourceRootDescriptor, ModuleBuildTarget>(context){

                    @Override
                    public void processDirtyFiles(@NotNull FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget> processor) throws IOException {
                        if (processor == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/incremental/IncProjectBuilder$5", "processDirtyFiles"));
                        }
                        FSOperations.processFilesToRecompile(context, chunk, processor);
                    }
                };
                if (!JavaBuilderUtil.isForcedRecompilationAllJavaModules(context)) {
                    Map<ModuleBuildTarget, Set<File>> cleanedSources = BuildOperations.cleanOutputsCorrespondingToChangedFiles(context, dirtyFilesHolder);
                    for (Map.Entry<ModuleBuildTarget, Set<File>> entry : cleanedSources.entrySet()) {
                        ModuleBuildTarget target = entry.getKey();
                        Set<File> files = entry.getValue();
                        if (files.isEmpty()) continue;
                        SourceToOutputMapping mapping = context.getProjectDescriptor().dataManager.getSourceToOutputMap(target);
                        for (File srcFile : files) {
                            mapping.setOutputs(srcFile.getPath(), Collections.<String>emptyList());
                        }
                    }
                }
                for (BuilderCategory category : BuilderCategory.values()) {
                    List<ModuleLevelBuilder> builders = this.myBuilderRegistry.getBuilders(category);
                    if (category == BuilderCategory.CLASS_POST_PROCESSOR) {
                        IncProjectBuilder.saveInstrumentedClasses(outputConsumer);
                    }
                    if (builders.isEmpty()) continue;
                    for (ModuleLevelBuilder builder : builders) {
                        this.processDeletedPaths(context, chunk.getTargets());
                        ModuleLevelBuilder.ExitCode buildResult = builder.build(context, chunk, (DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget>)dirtyFilesHolder, outputConsumer);
                        doneSomething |= buildResult != ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                        if (buildResult == ModuleLevelBuilder.ExitCode.ABORT) {
                            throw new StopBuildException("Builder " + builder.getPresentableName() + " requested build stop");
                        }
                        context.checkCanceled();
                        if (buildResult == ModuleLevelBuilder.ExitCode.ADDITIONAL_PASS_REQUIRED) {
                            if (!nextPassRequired) {
                                this.myTargetsProcessed -= (float)(buildersPassed * modulesInChunk) / stageCount;
                                this.myTargetsProcessed += (float)(buildersPassed * modulesInChunk) / (stageCount += (float)this.myTotalModuleLevelBuilderCount);
                            }
                            nextPassRequired = true;
                        } else if (buildResult == ModuleLevelBuilder.ExitCode.CHUNK_REBUILD_REQUIRED) {
                            if (!rebuildFromScratchRequested && !JavaBuilderUtil.isForcedRecompilationAllJavaModules(context)) {
                                LOG.info("Builder " + builder.getPresentableName() + " requested rebuild of module chunk " + chunk.getName());
                                rebuildFromScratchRequested = true;
                                try {
                                    context.getProjectDescriptor().fsState.clearContextRoundData(context);
                                    FSOperations.markDirty(context, chunk, null);
                                    this.myTargetsProcessed -= (float)(buildersPassed * modulesInChunk) / stageCount;
                                    stageCount = this.myTotalModuleLevelBuilderCount;
                                    buildersPassed = 0;
                                    nextPassRequired = true;
                                    outputConsumer.clear();
                                    continue block7;
                                }
                                catch (Exception e) {
                                    throw new ProjectBuildException(e);
                                }
                            }
                            LOG.debug("Builder " + builder.getPresentableName() + " requested second chunk rebuild");
                        }
                        ++buildersPassed;
                        this.updateDoneFraction(context, (float)modulesInChunk / stageCount);
                    }
                }
            } while (nextPassRequired);
        }
        finally {
            IncProjectBuilder.saveInstrumentedClasses(outputConsumer);
            outputConsumer.fireFileGeneratedEvents();
            outputConsumer.clear();
            for (BuilderCategory category : BuilderCategory.values()) {
                for (ModuleLevelBuilder builder : this.myBuilderRegistry.getBuilders(category)) {
                    builder.chunkBuildFinished(context, chunk);
                }
            }
        }
        return doneSomething;
    }

    private static void saveInstrumentedClasses(ChunkBuildOutputConsumerImpl outputConsumer) throws IOException {
        for (CompiledClass compiledClass : outputConsumer.getCompiledClasses().values()) {
            if (!compiledClass.isDirty()) continue;
            compiledClass.save();
        }
    }

    private static void onChunkBuildComplete(CompileContext context, @NotNull BuildTargetChunk chunk) throws IOException {
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/incremental/IncProjectBuilder", "onChunkBuildComplete"));
        }
        ProjectDescriptor pd = context.getProjectDescriptor();
        BuildFSState fsState = pd.fsState;
        fsState.clearContextRoundData(context);
        fsState.clearContextChunk(context);
        BuildOperations.markTargetsUpToDate(context, chunk);
    }

    private static CompileContext createContextWrapper(CompileContext delegate) {
        ClassLoader loader = delegate.getClass().getClassLoader();
        UserDataHolderBase localDataHolder = new UserDataHolderBase();
        ConcurrentHashSet deletedKeysSet = new ConcurrentHashSet();
        final Class<UserDataHolder> dataHolderInterface = UserDataHolder.class;
        Class<MessageHandler> messageHandlerInterface = MessageHandler.class;
        return (CompileContext)Proxy.newProxyInstance(loader, new Class[]{CompileContext.class}, new InvocationHandler((Set)deletedKeysSet, localDataHolder, messageHandlerInterface, delegate){
            final /* synthetic */ Set val$deletedKeysSet;
            final /* synthetic */ UserDataHolderBase val$localDataHolder;
            final /* synthetic */ Class val$messageHandlerInterface;
            final /* synthetic */ CompileContext val$delegate;
            {
                this.val$deletedKeysSet = set;
                this.val$localDataHolder = userDataHolderBase;
                this.val$messageHandlerInterface = clazz2;
                this.val$delegate = compileContext;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                BuildMessage msg;
                Class<?> declaringClass = method.getDeclaringClass();
                if (dataHolderInterface.equals(declaringClass)) {
                    Object firstArgument = args[0];
                    if (!(firstArgument instanceof GlobalContextKey)) {
                        boolean isWriteOperation;
                        boolean bl = isWriteOperation = args.length == 2;
                        if (isWriteOperation) {
                            if (args[1] == null) {
                                this.val$deletedKeysSet.add(firstArgument);
                            } else {
                                this.val$deletedKeysSet.remove(firstArgument);
                            }
                        } else if (this.val$deletedKeysSet.contains(firstArgument)) {
                            return null;
                        }
                        Object result = method.invoke((Object)this.val$localDataHolder, args);
                        if (isWriteOperation || result != null) {
                            return result;
                        }
                    }
                } else if (this.val$messageHandlerInterface.equals(declaringClass) && (msg = (BuildMessage)args[0]).getKind() == BuildMessage.Kind.ERROR) {
                    Utils.ERRORS_DETECTED_KEY.set((UserDataHolder)this.val$localDataHolder, (Object)Boolean.TRUE);
                }
                try {
                    return method.invoke((Object)this.val$delegate, args);
                }
                catch (InvocationTargetException e) {
                    Throwable targetEx = e.getTargetException();
                    if (targetEx instanceof ProjectBuildException) {
                        throw targetEx;
                    }
                    throw e;
                }
            }
        });
    }

    static {
        int maxThreads = Math.min(6, Runtime.getRuntime().availableProcessors() - 1);
        try {
            maxThreads = Math.max(1, Integer.parseInt(System.getProperty("compile.parallel.max.threads", Integer.toString(maxThreads))));
        }
        catch (NumberFormatException ignored) {
            maxThreads = Math.max(1, maxThreads);
        }
        MAX_BUILDER_THREADS = maxThreads;
    }

    private class BuildParallelizer {
        private final BoundedTaskExecutor myParallelBuildExecutor = new BoundedTaskExecutor((Executor)SharedThreadPool.getInstance(), MAX_BUILDER_THREADS);
        private final CompileContext myContext;
        private final AtomicReference<Throwable> myException = new AtomicReference();
        private final Object myQueueLock = new Object();
        private final CountDownLatch myTasksCountDown;
        private final List<BuildChunkTask> myTasks;

        private BuildParallelizer(CompileContext context) {
            this.myContext = context;
            ProjectDescriptor pd = this.myContext.getProjectDescriptor();
            BuildTargetIndex targetIndex = pd.getBuildTargetIndex();
            List<BuildTargetChunk> chunks = targetIndex.getSortedTargetChunks(this.myContext);
            this.myTasks = new ArrayList<BuildChunkTask>(chunks.size());
            THashMap targetToTask = new THashMap();
            for (BuildTargetChunk chunk : chunks) {
                BuildChunkTask task = new BuildChunkTask(chunk);
                this.myTasks.add(task);
                for (BuildTarget<?> target : chunk.getTargets()) {
                    targetToTask.put(target, task);
                }
            }
            for (BuildChunkTask task : this.myTasks) {
                for (BuildTarget<?> target : task.getChunk().getTargets()) {
                    for (BuildTarget<?> dependency : targetIndex.getDependencies(target, this.myContext)) {
                        BuildChunkTask depTask = (BuildChunkTask)targetToTask.get(dependency);
                        if (depTask == null || depTask == task) continue;
                        task.addDependency(depTask);
                    }
                }
            }
            this.myTasksCountDown = new CountDownLatch(this.myTasks.size());
        }

        public void buildInParallel() throws IOException, ProjectBuildException {
            ArrayList<BuildChunkTask> initialTasks = new ArrayList<BuildChunkTask>();
            for (BuildChunkTask task : this.myTasks) {
                if (!task.isReady()) continue;
                initialTasks.add(task);
            }
            this.queueTasks(initialTasks);
            try {
                this.myTasksCountDown.await();
            }
            catch (InterruptedException e) {
                LOG.info((Throwable)e);
            }
            Throwable throwable = this.myException.get();
            if (throwable instanceof ProjectBuildException) {
                throw (ProjectBuildException)throwable;
            }
            if (throwable != null) {
                throw new ProjectBuildException(throwable);
            }
        }

        private void queueTasks(List<BuildChunkTask> tasks) {
            ArrayList<BuildTargetChunk> chunksToLog = LOG.isDebugEnabled() ? new ArrayList<BuildTargetChunk>() : null;
            for (BuildChunkTask task : tasks) {
                if (chunksToLog != null) {
                    chunksToLog.add(task.getChunk());
                }
                this.queueTask(task);
            }
            if (chunksToLog != null && !chunksToLog.isEmpty()) {
                StringBuilder logBuilder = new StringBuilder("Queuing " + chunksToLog.size() + " chunks in parallel: ");
                Collections.sort(chunksToLog, new Comparator<BuildTargetChunk>(){

                    @Override
                    public int compare(BuildTargetChunk o1, BuildTargetChunk o2) {
                        return o1.toString().compareTo(o2.toString());
                    }
                });
                for (BuildTargetChunk chunk : chunksToLog) {
                    logBuilder.append(chunk.toString()).append("; ");
                }
                LOG.debug(logBuilder.toString());
            }
        }

        private void queueTask(final BuildChunkTask task) {
            final CompileContext chunkLocalContext = IncProjectBuilder.createContextWrapper(this.myContext);
            this.myParallelBuildExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        try {
                            if (BuildParallelizer.this.myException.get() == null) {
                                IncProjectBuilder.this.buildChunkIfAffected(chunkLocalContext, BuildParallelizer.this.myContext.getScope(), task.getChunk());
                            }
                        }
                        finally {
                            BuildParallelizer.this.myContext.updateCompilationStartStamp();
                            ((IncProjectBuilder)IncProjectBuilder.this).myProjectDescriptor.dataManager.closeSourceToOutputStorages(Collections.singletonList(task.getChunk()));
                            ((IncProjectBuilder)IncProjectBuilder.this).myProjectDescriptor.dataManager.flush(true);
                        }
                    }
                    catch (Throwable e) {
                        BuildParallelizer.this.myException.compareAndSet(null, e);
                        LOG.info(e);
                    }
                    finally {
                        List<BuildChunkTask> nextTasks;
                        LOG.debug("Finished compilation of " + task.getChunk().toString());
                        BuildParallelizer.this.myTasksCountDown.countDown();
                        Object object = BuildParallelizer.this.myQueueLock;
                        synchronized (object) {
                            nextTasks = task.markAsFinishedAndGetNextReadyTasks();
                        }
                        if (!nextTasks.isEmpty()) {
                            BuildParallelizer.this.queueTasks(nextTasks);
                        }
                    }
                }
            });
        }
    }

    private static class BuildChunkTask {
        private final BuildTargetChunk myChunk;
        private final Set<BuildChunkTask> myNotBuiltDependencies = new THashSet();
        private final List<BuildChunkTask> myTasksDependsOnThis = new ArrayList<BuildChunkTask>();

        private BuildChunkTask(BuildTargetChunk chunk) {
            this.myChunk = chunk;
        }

        public BuildTargetChunk getChunk() {
            return this.myChunk;
        }

        public boolean isReady() {
            return this.myNotBuiltDependencies.isEmpty();
        }

        public void addDependency(BuildChunkTask dependency) {
            if (this.myNotBuiltDependencies.add(dependency)) {
                dependency.myTasksDependsOnThis.add(this);
            }
        }

        public List<BuildChunkTask> markAsFinishedAndGetNextReadyTasks() {
            SmartList nextTasks = new SmartList();
            for (BuildChunkTask task : this.myTasksDependsOnThis) {
                boolean removed = task.myNotBuiltDependencies.remove(this);
                LOG.assertTrue(removed, (Object)(task.getChunk().toString() + " didn't have " + this.getChunk().toString()));
                if (!task.isReady()) continue;
                nextTasks.add(task);
            }
            return nextTasks;
        }
    }
}

