/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.util.Collection;
import org.jetbrains.jps.builders.java.dependencyView.CollectionFactory;
import org.jetbrains.jps.builders.java.dependencyView.IntObjectMultiMaplet;
import org.jetbrains.jps.builders.java.dependencyView.Streamable;

class IntObjectTransientMultiMaplet<V extends Streamable>
extends IntObjectMultiMaplet<V> {
    private final TIntObjectHashMap<Collection<V>> myMap = new TIntObjectHashMap();
    private final CollectionFactory<V> myCollectionFactory;

    public IntObjectTransientMultiMaplet(CollectionFactory<V> collectionFactory) {
        this.myCollectionFactory = collectionFactory;
    }

    @Override
    public boolean containsKey(int key) {
        return this.myMap.containsKey(key);
    }

    @Override
    public Collection<V> get(int key) {
        return (Collection)this.myMap.get(key);
    }

    @Override
    public void putAll(IntObjectMultiMaplet<V> m) {
        m.forEachEntry(new TIntObjectProcedure<Collection<V>>(){

            public boolean execute(int key, Collection<V> value) {
                IntObjectTransientMultiMaplet.this.put(key, value);
                return true;
            }
        });
    }

    @Override
    public void put(int key, Collection<V> value) {
        Collection x = (Collection)this.myMap.get(key);
        if (x == null) {
            this.myMap.put(key, value);
        } else {
            x.addAll(value);
        }
    }

    @Override
    public void replace(int key, Collection<V> value) {
        if (value == null || value.isEmpty()) {
            this.myMap.remove(key);
        } else {
            this.myMap.put(key, value);
        }
    }

    @Override
    public void put(int key, V value) {
        Collection collection = (Collection)this.myMap.get(key);
        if (collection == null) {
            Collection<V> x = this.myCollectionFactory.create();
            x.add(value);
            this.myMap.put(key, x);
        } else {
            collection.add(value);
        }
    }

    @Override
    public void removeFrom(int key, V value) {
        Collection collection = (Collection)this.myMap.get(key);
        if (collection != null && collection.remove(value) && collection.isEmpty()) {
            this.myMap.remove(key);
        }
    }

    @Override
    public void removeAll(int key, Collection<V> values) {
        Collection collection = (Collection)this.myMap.get(key);
        if (collection != null && collection.removeAll(values) && collection.isEmpty()) {
            this.myMap.remove(key);
        }
    }

    @Override
    public void remove(int key) {
        this.myMap.remove(key);
    }

    @Override
    public void replaceAll(IntObjectMultiMaplet<V> m) {
        m.forEachEntry(new TIntObjectProcedure<Collection<V>>(){

            public boolean execute(int key, Collection<V> value) {
                IntObjectTransientMultiMaplet.this.replace(key, value);
                return true;
            }
        });
    }

    @Override
    public void forEachEntry(TIntObjectProcedure<Collection<V>> procedure) {
        this.myMap.forEachEntry(procedure);
    }

    @Override
    public void close() {
        this.myMap.clear();
    }

    @Override
    public void flush(boolean memoryCachesOnly) {
    }
}

