/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.Processor;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import gnu.trove.TIntObjectProcedure;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.IntObjectMaplet;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;

public class IntObjectPersistentMaplet<V>
extends IntObjectMaplet<V> {
    private static final Object NULL_OBJ = new Object();
    private static final int CACHE_SIZE = 512;
    private final PersistentHashMap<Integer, V> myMap;
    private final SLRUCache<Integer, Object> myCache;

    public IntObjectPersistentMaplet(File file, DataExternalizer<V> externalizer) {
        try {
            this.myMap = new PersistentHashMap(file, (KeyDescriptor)new IntInlineKeyDescriptor(), externalizer);
            this.myCache = new SLRUCache<Integer, Object>(512, 512){

                @NotNull
                public Object createValue(Integer key) {
                    Object object;
                    try {
                        Object v1 = IntObjectPersistentMaplet.this.myMap.get((Object)key);
                        object = v1 == null ? NULL_OBJ : v1;
                    }
                    catch (IOException e) {
                        throw new BuildDataCorruptedException(e);
                    }
                    if (object == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/dependencyView/IntObjectPersistentMaplet$1", "createValue"));
                    }
                    return object;
                }
            };
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public boolean containsKey(int key) {
        try {
            return this.myMap.containsMapping((Object)key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public V get(int key) {
        Object obj = this.myCache.get((Object)key);
        return (V)(obj == NULL_OBJ ? null : obj);
    }

    @Override
    public void put(int key, V value) {
        try {
            this.myCache.remove((Object)key);
            this.myMap.put((Object)key, value);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void putAll(IntObjectMaplet<V> m) {
        m.forEachEntry(new TIntObjectProcedure<V>(){

            public boolean execute(int key, V value) {
                IntObjectPersistentMaplet.this.put(key, value);
                return true;
            }
        });
    }

    @Override
    public void remove(int key) {
        try {
            this.myCache.remove((Object)key);
            this.myMap.remove((Object)key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.myCache.clear();
            this.myMap.close();
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void flush(boolean memoryCachesOnly) {
        if (memoryCachesOnly) {
            if (this.myMap.isDirty()) {
                this.myMap.dropMemoryCaches();
            }
        } else {
            this.myMap.force();
        }
    }

    @Override
    public void forEachEntry(final TIntObjectProcedure<V> proc) {
        try {
            this.myMap.processKeysWithExistingMapping((Processor)new Processor<Integer>(){

                public boolean process(Integer key) {
                    try {
                        Object value = IntObjectPersistentMaplet.this.myMap.get((Object)key);
                        return value == null ? proc.execute(key.intValue(), null) : proc.execute(key.intValue(), value);
                    }
                    catch (IOException e) {
                        throw new BuildDataCorruptedException(e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }
}

