/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.incremental.ResourcesTarget;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class ResourcesTargetType
extends ModuleBasedBuildTargetType<ResourcesTarget> {
    public static final ResourcesTargetType PRODUCTION = new ResourcesTargetType("resources-production", false);
    public static final ResourcesTargetType TEST = new ResourcesTargetType("resources-test", true);
    public static final List<ResourcesTargetType> ALL_TYPES = Arrays.asList(PRODUCTION, TEST);
    private boolean myTests;

    private ResourcesTargetType(String typeId, boolean tests) {
        super(typeId);
        this.myTests = tests;
    }

    @Override
    @NotNull
    public List<ResourcesTarget> computeAllTargets(@NotNull JpsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/builders/java/ResourcesTargetType", "computeAllTargets"));
        }
        List modules = model.getProject().getModules();
        ArrayList<ResourcesTarget> targets = new ArrayList<ResourcesTarget>(modules.size());
        for (JpsModule module : modules) {
            targets.add(new ResourcesTarget(module, this));
        }
        ArrayList<ResourcesTarget> arrayList = targets;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/ResourcesTargetType", "computeAllTargets"));
        }
        return arrayList;
    }

    @NotNull
    public Loader createLoader(@NotNull JpsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/builders/java/ResourcesTargetType", "createLoader"));
        }
        Loader loader = new Loader(model);
        if (loader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/ResourcesTargetType", "createLoader"));
        }
        return loader;
    }

    public boolean isTests() {
        return this.myTests;
    }

    public static ResourcesTargetType getInstance(boolean tests) {
        return tests ? TEST : PRODUCTION;
    }

    private class Loader
    extends BuildTargetLoader<ResourcesTarget> {
        private final Map<String, JpsModule> myModules = new HashMap<String, JpsModule>();

        public Loader(JpsModel model) {
            for (JpsModule module : model.getProject().getModules()) {
                this.myModules.put(module.getName(), module);
            }
        }

        @Override
        @Nullable
        public ResourcesTarget createTarget(@NotNull String targetId) {
            if (targetId == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/builders/java/ResourcesTargetType$Loader", "createTarget"));
            }
            JpsModule module = this.myModules.get(targetId);
            return module != null ? new ResourcesTarget(module, ResourcesTargetType.this) : null;
        }
    }
}

