/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class JavaModuleBuildTargetType
extends ModuleBasedBuildTargetType<ModuleBuildTarget> {
    public static final JavaModuleBuildTargetType PRODUCTION = new JavaModuleBuildTargetType("java-production", false);
    public static final JavaModuleBuildTargetType TEST = new JavaModuleBuildTargetType("java-test", true);
    public static final List<JavaModuleBuildTargetType> ALL_TYPES = Arrays.asList(PRODUCTION, TEST);
    private boolean myTests;

    private JavaModuleBuildTargetType(String typeId, boolean tests) {
        super(typeId);
        this.myTests = tests;
    }

    @Override
    @NotNull
    public List<ModuleBuildTarget> computeAllTargets(@NotNull JpsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/builders/java/JavaModuleBuildTargetType", "computeAllTargets"));
        }
        List modules = model.getProject().getModules();
        ArrayList<ModuleBuildTarget> targets = new ArrayList<ModuleBuildTarget>(modules.size());
        for (JpsModule module : modules) {
            targets.add(new ModuleBuildTarget(module, this));
        }
        ArrayList<ModuleBuildTarget> arrayList = targets;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/JavaModuleBuildTargetType", "computeAllTargets"));
        }
        return arrayList;
    }

    @NotNull
    public Loader createLoader(@NotNull JpsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/builders/java/JavaModuleBuildTargetType", "createLoader"));
        }
        Loader loader = new Loader(model);
        if (loader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/JavaModuleBuildTargetType", "createLoader"));
        }
        return loader;
    }

    public boolean isTests() {
        return this.myTests;
    }

    public static JavaModuleBuildTargetType getInstance(boolean tests) {
        return tests ? TEST : PRODUCTION;
    }

    private class Loader
    extends BuildTargetLoader<ModuleBuildTarget> {
        private final Map<String, JpsModule> myModules = new HashMap<String, JpsModule>();

        public Loader(JpsModel model) {
            for (JpsModule module : model.getProject().getModules()) {
                this.myModules.put(module.getName(), module);
            }
        }

        @Override
        @Nullable
        public ModuleBuildTarget createTarget(@NotNull String targetId) {
            if (targetId == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/builders/java/JavaModuleBuildTargetType$Loader", "createTarget"));
            }
            JpsModule module = this.myModules.get(targetId);
            return module != null ? new ModuleBuildTarget(module, JavaModuleBuildTargetType.this) : null;
        }
    }
}

