/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.builders.java.dependencyView.Mappings;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompileScope;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.service.JpsServiceManager;

public class JavaBuilderUtil {
    private static final Key<Set<File>> ALL_AFFECTED_FILES_KEY = Key.create((String)"_all_affected_files_");
    private static final Key<Set<File>> ALL_COMPILED_FILES_KEY = Key.create((String)"_all_compiled_files_");
    public static final Key<Callbacks.ConstantAffectionResolver> CONSTANT_SEARCH_SERVICE = Key.create((String)"_constant_search_service_");
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.Builder");

    public static boolean updateMappings(CompileContext context, Mappings delta, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleChunk chunk, Collection<File> filesToCompile, Collection<File> successfullyCompiled) throws IOException {
        try {
            boolean additionalPassRequired = false;
            Set<String> removedPaths = JavaBuilderUtil.getRemovedPaths(chunk, dirtyFilesHolder);
            Mappings globalMappings = context.getProjectDescriptor().dataManager.getMappings();
            boolean errorsDetected = Utils.errorsDetected(context);
            if (!JavaBuilderUtil.isForcedRecompilationAllJavaModules(context)) {
                if (context.shouldDifferentiate(chunk)) {
                    context.processMessage(new ProgressMessage("Checking dependencies... [" + chunk.getPresentableShortName() + "]"));
                    Set<File> allCompiledFiles = JavaBuilderUtil.getAllCompiledFilesContainer(context);
                    Set<File> allAffectedFiles = JavaBuilderUtil.getAllAffectedFilesContainer(context);
                    allAffectedFiles.addAll(filesToCompile);
                    allCompiledFiles.addAll(successfullyCompiled);
                    allAffectedFiles.removeAll(successfullyCompiled);
                    THashSet affectedBeforeDif = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                    affectedBeforeDif.addAll(allAffectedFiles);
                    ModulesBasedFileFilter moduleBasedFilter = new ModulesBasedFileFilter(context, chunk);
                    boolean incremental = globalMappings.differentiateOnIncrementalMake(delta, removedPaths, filesToCompile, allCompiledFiles, allAffectedFiles, moduleBasedFilter, (Callbacks.ConstantAffectionResolver)CONSTANT_SEARCH_SERVICE.get((UserDataHolder)context));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Differentiate Results:");
                        LOG.debug("   Compiled Files:");
                        for (File c : allCompiledFiles) {
                            LOG.debug("      " + c.getAbsolutePath());
                        }
                        LOG.debug("   Affected Files:");
                        for (File c : allAffectedFiles) {
                            LOG.debug("      " + c.getAbsolutePath());
                        }
                        LOG.debug("End Of Differentiate Results.");
                    }
                    if (incremental) {
                        HashSet<File> newlyAffectedFiles = new HashSet<File>(allAffectedFiles);
                        newlyAffectedFiles.removeAll((Collection<?>)affectedBeforeDif);
                        String infoMessage = "Dependency analysis found " + newlyAffectedFiles.size() + " affected files";
                        LOG.info(infoMessage);
                        context.processMessage(new ProgressMessage(infoMessage));
                        if (!newlyAffectedFiles.isEmpty()) {
                            if (LOG.isDebugEnabled()) {
                                for (File file : newlyAffectedFiles) {
                                    LOG.debug("affected file: " + file.getPath());
                                }
                                List<Pair<File, JpsModule>> wrongFiles = JavaBuilderUtil.checkAffectedFilesInCorrectModules(context, newlyAffectedFiles, moduleBasedFilter);
                                if (!wrongFiles.isEmpty()) {
                                    LOG.debug("Wrong affected files for module chunk " + chunk.getName() + ": ");
                                    for (Pair<File, JpsModule> pair : wrongFiles) {
                                        String name = pair.second != null ? ((JpsModule)pair.second).getName() : "null";
                                        LOG.debug("\t[" + name + "] " + ((File)pair.first).getPath());
                                    }
                                }
                            }
                            for (File file : newlyAffectedFiles) {
                                FSOperations.markDirtyIfNotDeleted(context, file);
                            }
                            additionalPassRequired = JavaBuilderUtil.isCompileJavaIncrementally(context) && JavaBuilderUtil.chunkContainsAffectedFiles(context, chunk, newlyAffectedFiles);
                        }
                    } else {
                        String messageText = "Marking " + chunk.getPresentableShortName() + " and direct dependants for recompilation";
                        LOG.info("Non-incremental mode: " + messageText);
                        context.processMessage(new ProgressMessage(messageText));
                        additionalPassRequired = JavaBuilderUtil.isCompileJavaIncrementally(context);
                        FSOperations.markDirtyRecursively(context, chunk);
                    }
                } else if (!errorsDetected) {
                    globalMappings.differentiateOnNonIncrementalMake(delta, removedPaths, filesToCompile);
                }
            } else if (!errorsDetected) {
                globalMappings.differentiateOnRebuild(delta);
            }
            if (errorsDetected) {
                boolean bl = false;
                return bl;
            }
            context.processMessage(new ProgressMessage("Updating dependency information... [" + chunk.getPresentableShortName() + "]"));
            globalMappings.integrate(delta);
            boolean bl = additionalPassRequired;
            return bl;
        }
        catch (BuildDataCorruptedException e) {
            throw e.getCause();
        }
        finally {
            context.processMessage(new ProgressMessage(""));
        }
    }

    public static boolean isForcedRecompilationAllJavaModules(CompileContext context) {
        CompileScope scope = context.getScope();
        return scope.isBuildForcedForAllTargets(JavaModuleBuildTargetType.PRODUCTION) && scope.isBuildForcedForAllTargets(JavaModuleBuildTargetType.TEST);
    }

    public static boolean isCompileJavaIncrementally(CompileContext context) {
        CompileScope scope = context.getScope();
        return scope.isBuildIncrementally(JavaModuleBuildTargetType.PRODUCTION) || scope.isBuildIncrementally(JavaModuleBuildTargetType.TEST);
    }

    private static List<Pair<File, JpsModule>> checkAffectedFilesInCorrectModules(CompileContext context, Collection<File> affected, ModulesBasedFileFilter moduleBasedFilter) {
        if (affected.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Pair<File, JpsModule>> result = new ArrayList<Pair<File, JpsModule>>();
        for (File file : affected) {
            if (moduleBasedFilter.accept(file)) continue;
            JavaSourceRootDescriptor moduleAndRoot = context.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(context, file);
            result.add((Pair<File, JpsModule>)Pair.create((Object)file, moduleAndRoot != null ? moduleAndRoot.target.getModule() : null));
        }
        return result;
    }

    private static boolean chunkContainsAffectedFiles(CompileContext context, ModuleChunk chunk, Set<File> affected) throws IOException {
        Set<JpsModule> chunkModules = chunk.getModules();
        if (!chunkModules.isEmpty()) {
            for (File file : affected) {
                JavaSourceRootDescriptor moduleAndRoot = context.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(context, file);
                if (moduleAndRoot == null || !chunkModules.contains(moduleAndRoot.target.getModule())) continue;
                return true;
            }
        }
        return false;
    }

    private static Set<File> getAllAffectedFilesContainer(CompileContext context) {
        Set allAffectedFiles = (Set)ALL_AFFECTED_FILES_KEY.get((UserDataHolder)context);
        if (allAffectedFiles == null) {
            allAffectedFiles = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            ALL_AFFECTED_FILES_KEY.set((UserDataHolder)context, (Object)allAffectedFiles);
        }
        return allAffectedFiles;
    }

    private static Set<File> getAllCompiledFilesContainer(CompileContext context) {
        Set allCompiledFiles = (Set)ALL_COMPILED_FILES_KEY.get((UserDataHolder)context);
        if (allCompiledFiles == null) {
            allCompiledFiles = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            ALL_COMPILED_FILES_KEY.set((UserDataHolder)context, (Object)allCompiledFiles);
        }
        return allCompiledFiles;
    }

    private static Set<String> getRemovedPaths(ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder) {
        if (!dirtyFilesHolder.hasRemovedFiles()) {
            return Collections.emptySet();
        }
        THashSet removed = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        for (ModuleBuildTarget target : chunk.getTargets()) {
            removed.addAll(dirtyFilesHolder.getRemovedFiles(target));
        }
        return removed;
    }

    public static void cleanupChunkResources(CompileContext context) {
        ALL_AFFECTED_FILES_KEY.set((UserDataHolder)context, null);
        ALL_COMPILED_FILES_KEY.set((UserDataHolder)context, null);
    }

    @NotNull
    public static JpsSdk<JpsDummyElement> ensureModuleHasJdk(JpsModule module, CompileContext context, String compilerName) throws ProjectBuildException {
        JpsSdkReference reference = module.getSdkReference((JpsSdkType)JpsJavaSdkType.INSTANCE);
        if (reference == null) {
            context.processMessage(new CompilerMessage(compilerName, BuildMessage.Kind.ERROR, "JDK isn't specified for module '" + module.getName() + "'"));
            throw new StopBuildException();
        }
        JpsTypedLibrary sdkLibrary = (JpsTypedLibrary)reference.resolve();
        if (sdkLibrary == null) {
            context.processMessage(new CompilerMessage(compilerName, BuildMessage.Kind.ERROR, "Cannot find JDK '" + reference.getSdkName() + "' for module '" + module.getName() + "'"));
            throw new StopBuildException();
        }
        JpsSdk jpsSdk = (JpsSdk)sdkLibrary.getProperties();
        if (jpsSdk == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/JavaBuilderUtil", "ensureModuleHasJdk"));
        }
        return jpsSdk;
    }

    @Nullable
    public static JavaCompilingTool findCompilingTool(@NotNull String compilerId) {
        if (compilerId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/builders/java/JavaBuilderUtil", "findCompilingTool"));
        }
        for (JavaCompilingTool tool : JpsServiceManager.getInstance().getExtensions(JavaCompilingTool.class)) {
            if (!compilerId.equals(tool.getId()) && !compilerId.equals(tool.getAlternativeId())) continue;
            return tool;
        }
        return null;
    }

    private static class ModulesBasedFileFilter
    implements Mappings.DependentFilesFilter {
        private final CompileContext myContext;
        private final Set<JpsModule> myChunkModules;
        private final Set<ModuleBuildTarget> myChunkTargets;
        private final Map<JpsModule, Set<JpsModule>> myCache = new HashMap<JpsModule, Set<JpsModule>>();
        private final BuildRootIndex myBuildRootIndex;

        private ModulesBasedFileFilter(CompileContext context, ModuleChunk chunk) {
            this.myContext = context;
            this.myChunkModules = chunk.getModules();
            this.myChunkTargets = chunk.getTargets();
            this.myBuildRootIndex = context.getProjectDescriptor().getBuildRootIndex();
        }

        @Override
        public boolean accept(File file) {
            JavaSourceRootDescriptor rd = this.myBuildRootIndex.findJavaRootDescriptor(this.myContext, file);
            if (rd == null) {
                return true;
            }
            JpsModule moduleOfFile = rd.target.getModule();
            if (this.myChunkModules.contains(moduleOfFile)) {
                return true;
            }
            Set<JpsModule> moduleOfFileWithDependencies = this.myCache.get(moduleOfFile);
            if (moduleOfFileWithDependencies == null) {
                moduleOfFileWithDependencies = ProjectPaths.getModulesWithDependentsRecursively(moduleOfFile, true);
                this.myCache.put(moduleOfFile, moduleOfFileWithDependencies);
            }
            return Utils.intersects(moduleOfFileWithDependencies, this.myChunkModules);
        }

        @Override
        public boolean belongsToCurrentTargetChunk(File file) {
            JavaSourceRootDescriptor rd = this.myBuildRootIndex.findJavaRootDescriptor(this.myContext, file);
            return rd != null && this.myChunkTargets.contains(rd.target);
        }
    }
}

