/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl.java;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import javax.tools.JavaCompiler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.CannotCreateJavaCompilerException;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.cmdline.ClasspathBootstrap;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.Utils;

public class EclipseCompilerTool
extends JavaCompilingTool {
    @Override
    @NotNull
    public String getId() {
        if ("Eclipse" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/java/EclipseCompilerTool", "getId"));
        }
        return "Eclipse";
    }

    @Override
    @Nullable
    public String getAlternativeId() {
        return "EclipseEmbedded";
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Eclipse compiler" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/java/EclipseCompilerTool", "getDescription"));
        }
        return "Eclipse compiler";
    }

    @Override
    @NotNull
    public JavaCompiler createCompiler() throws CannotCreateJavaCompilerException {
        for (JavaCompiler javaCompiler : ServiceLoader.load(JavaCompiler.class)) {
            if (!"EclipseCompiler".equals(StringUtil.getShortName(javaCompiler.getClass()))) continue;
            JavaCompiler javaCompiler2 = javaCompiler;
            if (javaCompiler2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/java/EclipseCompilerTool", "createCompiler"));
            }
            return javaCompiler2;
        }
        throw new CannotCreateJavaCompilerException("Eclipse Batch Compiler was not found in classpath");
    }

    @Override
    @NotNull
    public List<File> getAdditionalClasspath() {
        for (JavaCompiler javaCompiler : ServiceLoader.load(JavaCompiler.class)) {
            File compilerResource = ClasspathBootstrap.getResourceFile(javaCompiler.getClass());
            String name = compilerResource.getName();
            if (!name.startsWith("ecj-") || !name.endsWith(".jar")) continue;
            List<File> list = Collections.singletonList(compilerResource);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/java/EclipseCompilerTool", "getAdditionalClasspath"));
            }
            return list;
        }
        List<File> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/java/EclipseCompilerTool", "getAdditionalClasspath"));
        }
        return list;
    }

    @Override
    public void processCompilerOptions(@NotNull CompileContext context, @NotNull List<String> options) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/builders/impl/java/EclipseCompilerTool", "processCompilerOptions"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/builders/impl/java/EclipseCompilerTool", "processCompilerOptions"));
        }
        for (String option : options) {
            if (!option.startsWith("-proceedOnError")) continue;
            Utils.PROCEED_ON_ERROR_KEY.set((UserDataHolder)context, (Object)Boolean.TRUE);
            break;
        }
    }

    @Override
    public List<String> getDefaultCompilerOptions() {
        return Collections.singletonList("-noExit");
    }
}

