/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.builders.impl.TargetOutputIndexImpl;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class BuildTargetIndexImpl
implements BuildTargetIndex {
    private Map<BuildTargetType<?>, List<? extends BuildTarget<?>>> myTargets;
    private Map<JpsModule, List<ModuleBasedTarget>> myModuleBasedTargets;
    private Map<BuildTarget<?>, Collection<BuildTarget<?>>> myDependencies;
    private List<BuildTargetChunk> myTargetChunks;
    private final List<BuildTarget<?>> myAllTargets;

    public BuildTargetIndexImpl(@NotNull JpsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/builders/impl/BuildTargetIndexImpl", "<init>"));
        }
        this.myTargets = new THashMap();
        this.myModuleBasedTargets = new THashMap();
        ArrayList targetsByType = new ArrayList();
        for (BuildTargetType<?> type : TargetTypeRegistry.getInstance().getTargetTypes()) {
            List<?> targets = type.computeAllTargets(model);
            this.myTargets.put(type, targets);
            targetsByType.add(targets);
            for (BuildTarget target : targets) {
                if (!(target instanceof ModuleBasedTarget)) continue;
                ModuleBasedTarget t = (ModuleBasedTarget)target;
                JpsModule module = t.getModule();
                List<ModuleBasedTarget> list = this.myModuleBasedTargets.get(module);
                if (list == null) {
                    list = new ArrayList<ModuleBasedTarget>();
                    this.myModuleBasedTargets.put(module, list);
                }
                list.add(t);
            }
        }
        this.myDependencies = new THashMap();
        this.myAllTargets = Collections.unmodifiableList(ContainerUtil.concat(targetsByType));
    }

    @Override
    public Collection<ModuleBasedTarget<?>> getModuleBasedTargets(@NotNull JpsModule module, @NotNull BuildTargetRegistry.ModuleTargetSelector selector) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/builders/impl/BuildTargetIndexImpl", "getModuleBasedTargets"));
        }
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/builders/impl/BuildTargetIndexImpl", "getModuleBasedTargets"));
        }
        List<ModuleBasedTarget> targets = this.myModuleBasedTargets.get(module);
        if (targets == null || targets.isEmpty()) {
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        for (ModuleBasedTarget target : targets) {
            switch (selector) {
                case ALL: {
                    result.add(target);
                    break;
                }
                case PRODUCTION: {
                    if (target.isTests()) break;
                    result.add(target);
                    break;
                }
                case TEST: {
                    if (!target.isTests()) break;
                    result.add(target);
                }
            }
        }
        return result;
    }

    @Override
    @NotNull
    public <T extends BuildTarget<?>> List<T> getAllTargets(@NotNull BuildTargetType<T> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/builders/impl/BuildTargetIndexImpl", "getAllTargets"));
        }
        List<? extends BuildTarget<?>> list = this.myTargets.get(type);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/BuildTargetIndexImpl", "getAllTargets"));
        }
        return list;
    }

    @Override
    public List<BuildTargetChunk> getSortedTargetChunks(@NotNull CompileContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/builders/impl/BuildTargetIndexImpl", "getSortedTargetChunks"));
        }
        this.initializeChunks(context);
        return this.myTargetChunks;
    }

    private synchronized void initializeChunks(@NotNull CompileContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/builders/impl/BuildTargetIndexImpl", "initializeChunks"));
        }
        if (this.myTargetChunks != null) {
            return;
        }
        List<BuildTarget<?>> allTargets = this.getAllTargets();
        TargetOutputIndexImpl outputIndex = new TargetOutputIndexImpl(allTargets, context);
        for (BuildTarget<?> target : allTargets) {
            this.myDependencies.put(target, target.computeDependencies(this, outputIndex));
        }
        GraphGenerator graph = GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new GraphGenerator.SemiGraph<BuildTarget<?>>(){

            public Collection<BuildTarget<?>> getNodes() {
                return BuildTargetIndexImpl.this.myAllTargets;
            }

            public Iterator<BuildTarget<?>> getIn(BuildTarget<?> n) {
                return ((Collection)BuildTargetIndexImpl.this.myDependencies.get(n)).iterator();
            }
        }));
        final DFSTBuilder builder = new DFSTBuilder((Graph)graph);
        TIntArrayList sccs = builder.getSCCs();
        this.myTargetChunks = new ArrayList<BuildTargetChunk>(sccs.size());
        sccs.forEach(new TIntProcedure(){
            int myTNumber = 0;

            public boolean execute(int size) {
                LinkedHashSet chunkNodes = new LinkedHashSet();
                for (int j = 0; j < size; ++j) {
                    BuildTarget node = (BuildTarget)builder.getNodeByTNumber(this.myTNumber + j);
                    chunkNodes.add(node);
                }
                BuildTargetIndexImpl.this.myTargetChunks.add(new BuildTargetChunk(chunkNodes));
                this.myTNumber += size;
                return true;
            }
        });
    }

    @Override
    public List<? extends BuildTarget<?>> getAllTargets() {
        return this.myAllTargets;
    }

    @Override
    public Set<BuildTarget<?>> getDependenciesRecursively(@NotNull BuildTarget<?> target, @NotNull CompileContext context) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/builders/impl/BuildTargetIndexImpl", "getDependenciesRecursively"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/builders/impl/BuildTargetIndexImpl", "getDependenciesRecursively"));
        }
        this.initializeChunks(context);
        LinkedHashSet result = new LinkedHashSet();
        for (BuildTarget<?> dep : this.myDependencies.get(target)) {
            this.collectDependenciesRecursively(dep, result);
        }
        return result;
    }

    private void collectDependenciesRecursively(BuildTarget<?> target, LinkedHashSet<BuildTarget<?>> result) {
        if (result.add(target)) {
            for (BuildTarget<?> dep : this.myDependencies.get(target)) {
                this.collectDependenciesRecursively(dep, result);
            }
        }
    }

    @Override
    @NotNull
    public Collection<BuildTarget<?>> getDependencies(@NotNull BuildTarget<?> target, @NotNull CompileContext context) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/builders/impl/BuildTargetIndexImpl", "getDependencies"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/builders/impl/BuildTargetIndexImpl", "getDependencies"));
        }
        this.initializeChunks(context);
        Collection<BuildTarget<?>> collection = this.myDependencies.get(target);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/BuildTargetIndexImpl", "getDependencies"));
        }
        return collection;
    }
}

