/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jediterm.terminal.CharacterUtils;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.StyledTextConsumer;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.LinesBuffer;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalModelListener;
import com.jediterm.terminal.model.TerminalSelection;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TerminalTextBuffer {
    private static final Logger LOG = Logger.getLogger(TerminalTextBuffer.class);
    @NotNull
    private final StyleState myStyleState;
    private LinesBuffer myHistoryBuffer = new LinesBuffer();
    private LinesBuffer myScreenBuffer = new LinesBuffer();
    private int myWidth;
    private int myHeight;
    private final Lock myLock = new ReentrantLock();
    private LinesBuffer myHistoryBufferBackup;
    private LinesBuffer myScreenBufferBackup;
    private boolean myAlternateBuffer = false;
    private boolean myUsingAlternateBuffer = false;
    private List<TerminalModelListener> myListeners = Lists.newArrayList();

    public TerminalTextBuffer(int width, int height, @NotNull StyleState styleState) {
        this.myStyleState = styleState;
        this.myWidth = width;
        this.myHeight = height;
        this.myScreenBuffer = new LinesBuffer();
    }

    public Dimension resize(@NotNull Dimension pendingResize, @NotNull RequestOrigin origin, int cursorY, @NotNull JediTerminal.ResizeHandler resizeHandler, @Nullable TerminalSelection mySelection) {
        int newWidth = pendingResize.width;
        int newHeight = pendingResize.height;
        int textLinesCountOld = this.myScreenBuffer.getLineCount();
        if (newHeight < cursorY) {
            int count = cursorY - newHeight;
            if (!this.myAlternateBuffer) {
                this.myScreenBuffer.moveTopLinesTo(count, this.myHistoryBuffer);
            }
            if (mySelection != null) {
                mySelection.shiftY(-count);
            }
        } else if (newHeight > cursorY && this.myHistoryBuffer.getLineCount() > 0) {
            if (!this.myAlternateBuffer) {
                this.myHistoryBuffer.moveBottomLinesTo(newHeight - cursorY, this.myScreenBuffer);
            }
            if (mySelection != null) {
                mySelection.shiftY(newHeight - cursorY);
            }
        }
        this.myWidth = newWidth;
        this.myHeight = newHeight;
        if (this.myScreenBuffer.getLineCount() > this.myHeight) {
            this.myScreenBuffer.moveTopLinesTo(this.myScreenBuffer.getLineCount() - this.myHeight, this.myHistoryBuffer);
        }
        int myCursorY = cursorY + (this.myScreenBuffer.getLineCount() - textLinesCountOld);
        resizeHandler.sizeUpdated(this.myWidth, this.myHeight, myCursorY);
        this.fireModelChangeEvent();
        return pendingResize;
    }

    public void addModelListener(TerminalModelListener listener) {
        this.myListeners.add(listener);
    }

    public void removeModelListener(TerminalModelListener listener) {
        this.myListeners.remove(listener);
    }

    private void fireModelChangeEvent() {
        for (TerminalModelListener modelListener : this.myListeners) {
            modelListener.modelChanged();
        }
    }

    private TextStyle createEmptyStyleWithCurrentColor() {
        return this.myStyleState.getCurrent().createEmptyWithColors();
    }

    public void deleteCharacters(int x, int y, int count) {
        if (y > this.myHeight - 1 || y < 0) {
            LOG.error((Object)("attempt to delete in line " + y + "\n" + "args were x:" + x + " count:" + count));
        } else if (count < 0) {
            LOG.error((Object)("Attempt to delete negative chars number: count:" + count));
        } else {
            if (count == 0) {
                return;
            }
            int to = y * this.myWidth + x;
            int from = to + count;
            int remain = this.myWidth - x - count;
            LOG.debug((Object)("About to delete " + count + " chars on line " + y + ", starting from " + x + " (from : " + from + " to : " + to + " remain : " + remain + ")"));
            this.myScreenBuffer.deleteCharacters(x, y, count);
            this.fireModelChangeEvent();
        }
    }

    public void insertBlankCharacters(int x, int y, int count) {
        if (y > this.myHeight - 1 || y < 0) {
            LOG.error((Object)("attempt to insert blank chars in line " + y + "\n" + "args were x:" + x + " count:" + count));
        } else if (count < 0) {
            LOG.error((Object)("Attempt to insert negative blank chars number: count:" + count));
        } else if (count > 0) {
            int from = y * this.myWidth + x;
            this.myScreenBuffer.insertBlankCharacters(x, y, count, this.myWidth);
            this.fireModelChangeEvent();
        }
    }

    public void writeBytes(int x, int y, char[] bytes, int start, int len) {
        int adjY = y - 1;
        if (adjY >= this.myHeight || adjY < 0) {
            if (LOG.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder("Attempt to draw line ").append(adjY).append(" at (").append(x).append(",").append(y).append(")");
                CharacterUtils.appendBuf(sb, bytes, start, len);
                LOG.debug((Object)sb);
            }
            return;
        }
        TextStyle style = this.myStyleState.getCurrent();
        this.myScreenBuffer.writeString(x, adjY, new String(bytes, start, len), style);
        this.fireModelChangeEvent();
    }

    public void writeString(int x, int y, @NotNull String str) {
        this.writeString(x, y, str, this.myStyleState.getCurrent());
    }

    private void writeString(int x, int y, @NotNull String str, @NotNull TextStyle style) {
        this.myScreenBuffer.writeString(x, y - 1, str, style);
        this.fireModelChangeEvent();
    }

    public void scrollArea(int scrollRegionTop, int dy, int scrollRegionBottom) {
        if (dy == 0) {
            return;
        }
        if (dy > 0) {
            this.insertLines(scrollRegionTop - 1, dy, scrollRegionBottom);
        } else {
            LinesBuffer removed = this.deleteLines(scrollRegionTop - 1, -dy, scrollRegionBottom);
            if (scrollRegionTop == 1) {
                removed.moveTopLinesTo(removed.getLineCount(), this.myHistoryBuffer);
            }
            this.fireModelChangeEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStyleLines() {
        final HashMap hashMap = Maps.newHashMap();
        this.myLock.lock();
        try {
            final StringBuilder sb = new StringBuilder();
            this.myScreenBuffer.processLines(0, this.myHeight, new StyledTextConsumer(){
                int count = 0;

                public void consume(int x, int y, @NotNull TextStyle style, @NotNull CharBuffer characters, int startRow) {
                    int styleNum;
                    if (x == 0) {
                        sb.append("\n");
                    }
                    if (!hashMap.containsKey(styleNum = style.getId())) {
                        hashMap.put(styleNum, this.count++);
                    }
                    sb.append(String.format("%02d ", hashMap.get(styleNum)));
                }
            });
            String string = sb.toString();
            return string;
        }
        finally {
            this.myLock.unlock();
        }
    }

    public TerminalLine getLine(int index) {
        if (index >= 0) {
            if (index >= this.getHeight()) {
                LOG.error((Object)("Attempt to get line out of bounds: " + index + " >= " + this.getHeight()));
                return TerminalLine.createEmpty();
            }
            return this.myScreenBuffer.getLine(index);
        }
        if (index < -this.getHistoryLinesCount()) {
            LOG.error((Object)("Attempt to get line out of bounds: " + index + " < " + -this.getHistoryLinesCount()));
            return TerminalLine.createEmpty();
        }
        return this.myHistoryBuffer.getLine(this.getHistoryLinesCount() + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScreenLines() {
        this.myLock.lock();
        try {
            StringBuilder sb = new StringBuilder();
            for (int row = 0; row < this.myHeight; ++row) {
                StringBuilder line = new StringBuilder(this.myScreenBuffer.getLine(row).getText());
                for (int i = line.length(); i < this.myWidth; ++i) {
                    line.append(' ');
                }
                if (line.length() > this.myWidth) {
                    line.setLength(this.myWidth);
                }
                sb.append((CharSequence)line);
                sb.append('\n');
            }
            String string = sb.toString();
            return string;
        }
        finally {
            this.myLock.unlock();
        }
    }

    public void processScreenLines(int yStart, int yCount, @NotNull StyledTextConsumer consumer) {
        this.myScreenBuffer.processLines(yStart, yCount, consumer);
    }

    public void lock() {
        this.myLock.lock();
    }

    public void unlock() {
        this.myLock.unlock();
    }

    public boolean tryLock() {
        return this.myLock.tryLock();
    }

    public int getWidth() {
        return this.myWidth;
    }

    public int getHeight() {
        return this.myHeight;
    }

    public int getHistoryLinesCount() {
        return this.myHistoryBuffer.getLineCount();
    }

    public int getScreenLinesCount() {
        return this.myScreenBuffer.getLineCount();
    }

    public char getBuffersCharAt(int x, int y) {
        String lineText = this.getLine(y).getText();
        return x < lineText.length() ? lineText.charAt(x) : (char)' ';
    }

    public TextStyle getStyleAt(int x, int y) {
        TerminalLine line = this.myScreenBuffer.getLine(y);
        return line.getStyleAt(x);
    }

    public void useAlternateBuffer(boolean enabled) {
        this.myAlternateBuffer = enabled;
        if (enabled) {
            if (!this.myUsingAlternateBuffer) {
                this.myScreenBufferBackup = this.myScreenBuffer;
                this.myHistoryBufferBackup = this.myHistoryBuffer;
                this.myScreenBuffer = new LinesBuffer();
                this.myHistoryBuffer = new LinesBuffer();
                this.myUsingAlternateBuffer = true;
            }
        } else if (this.myUsingAlternateBuffer) {
            this.myScreenBuffer = this.myScreenBufferBackup;
            this.myHistoryBuffer = this.myHistoryBufferBackup;
            this.myUsingAlternateBuffer = false;
            this.myScreenBufferBackup = new LinesBuffer();
            this.myHistoryBufferBackup = new LinesBuffer();
        }
        this.fireModelChangeEvent();
    }

    public LinesBuffer getHistoryBuffer() {
        return this.myHistoryBuffer;
    }

    public void insertLines(int y, int count, int scrollRegionBottom) {
        this.myScreenBuffer.insertLines(y, count, scrollRegionBottom - 1);
        this.fireModelChangeEvent();
    }

    public LinesBuffer deleteLines(int y, int count, int scrollRegionBottom) {
        LinesBuffer linesBuffer = this.myScreenBuffer.deleteLines(y, count, scrollRegionBottom - 1);
        this.fireModelChangeEvent();
        return linesBuffer;
    }

    public void clearLines(int startRow, int endRow) {
        this.myScreenBuffer.clearLines(startRow, endRow);
        this.fireModelChangeEvent();
    }

    public void eraseCharacters(int leftX, int rightX, int y) {
        TextStyle style = this.createEmptyStyleWithCurrentColor();
        if (y >= 0) {
            this.myScreenBuffer.clearArea(leftX, y, rightX, y + 1, style);
            this.fireModelChangeEvent();
        } else {
            LOG.error((Object)("Attempt to erase characters in line: " + y));
        }
    }

    public void clearAll() {
        this.myScreenBuffer.clearAll();
        this.fireModelChangeEvent();
    }

    public void processHistoryAndScreenLines(int scrollOrigin, StyledTextConsumer consumer) {
        int linesFromHistory = Math.min(-scrollOrigin, this.myHeight);
        this.myHistoryBuffer.processLines(this.myHistoryBuffer.getLineCount() + scrollOrigin, linesFromHistory, consumer, this.myHistoryBuffer.getLineCount() + scrollOrigin);
        if (this.myHeight - linesFromHistory + 1 > 0) {
            this.myScreenBuffer.processLines(0, this.myHeight - linesFromHistory, consumer, -linesFromHistory);
        }
    }
}

