/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.google.common.collect.Lists;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.LinesBuffer;
import com.jediterm.terminal.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerminalLine {
    private TextEntries myTextEntries = new TextEntries();
    private boolean myWrapped = false;

    public TerminalLine() {
    }

    public TerminalLine(@NotNull TextEntry entry) {
        this.myTextEntries.add(entry);
    }

    public static TerminalLine createEmpty() {
        return new TerminalLine();
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        for (TextEntry textEntry : Lists.newArrayList((Iterable)this.myTextEntries)) {
            sb.append(textEntry.getText());
        }
        return sb.toString();
    }

    public boolean isWrapped() {
        return this.myWrapped;
    }

    public void setWrapped(boolean wrapped) {
        this.myWrapped = wrapped;
    }

    public void clear() {
        this.myTextEntries.clear();
        this.setWrapped(false);
    }

    public void writeString(int x, @NotNull String str, @NotNull TextStyle style) {
        this.writeCharacters(x, style, new CharBuffer(str));
    }

    private void writeCharacters(int x, @NotNull TextStyle style, @NotNull CharBuffer characters) {
        int len = this.myTextEntries.length();
        if (x >= len) {
            if (x - len > 0) {
                this.myTextEntries.add(new TextEntry(TextStyle.EMPTY, new CharBuffer(' ', x - len)));
            }
            this.myTextEntries.add(new TextEntry(style, characters));
        } else {
            len = Math.max(len, x + characters.length());
            this.myTextEntries = TerminalLine.merge(x, characters, style, this.myTextEntries, len);
        }
    }

    private static TextEntries merge(int x, @NotNull CharBuffer str, @NotNull TextStyle style, @NotNull TextEntries entries, int lineLength) {
        Pair<char[], TextStyle[]> pair = TerminalLine.toBuf(entries, lineLength);
        for (int i = 0; i < str.length(); ++i) {
            ((char[])pair.first)[i + x] = str.charAt(i);
            ((TextStyle[])pair.second)[i + x] = style;
        }
        return TerminalLine.collectFromBuffer((char[])pair.first, (TextStyle[])pair.second);
    }

    private static Pair<char[], TextStyle[]> toBuf(TextEntries entries, int lineLength) {
        Pair<char[], TextStyle[]> pair = Pair.create(new char[lineLength], new TextStyle[lineLength]);
        int p = 0;
        for (TextEntry entry : entries) {
            for (int i = 0; i < entry.getLength(); ++i) {
                ((char[])pair.first)[p + i] = entry.getText().charAt(i);
                ((TextStyle[])pair.second)[p + i] = entry.getStyle();
            }
            p += entry.getLength();
        }
        return pair;
    }

    private static TextEntries collectFromBuffer(@NotNull char[] buf, @NotNull TextStyle[] styles) {
        TextEntries result = new TextEntries();
        TextStyle curStyle = styles[0];
        int start = 0;
        for (int i = 1; i < buf.length; ++i) {
            if (styles[i] == curStyle) continue;
            result.add(new TextEntry(curStyle, new CharBuffer(buf, start, i - start)));
            curStyle = styles[i];
            start = i;
        }
        result.add(new TextEntry(curStyle, new CharBuffer(buf, start, buf.length - start)));
        return result;
    }

    public void deleteCharacters(int x) {
        this.deleteCharacters(x, this.myTextEntries.length() - x);
        this.setWrapped(false);
    }

    public void deleteCharacters(int x, int count) {
        int p = 0;
        TextEntries newEntries = new TextEntries();
        for (TextEntry entry : this.myTextEntries) {
            if (count == 0) {
                newEntries.add(entry);
                continue;
            }
            int len = entry.getLength();
            if (p + len <= x) {
                p += len;
                newEntries.add(entry);
                continue;
            }
            int dx = x - p;
            if (dx > 0) {
                newEntries.add(new TextEntry(entry.getStyle(), entry.getText().subBuffer(0, dx)));
                p = x;
            }
            if (dx + count < len) {
                newEntries.add(new TextEntry(entry.getStyle(), entry.getText().subBuffer(dx + count, len - (dx + count))));
                count = 0;
                continue;
            }
            count -= len - dx;
            p = x;
        }
        this.myTextEntries = newEntries;
    }

    public void insertBlankCharacters(int x, int count, int maxLen) {
        int len = this.myTextEntries.length();
        len = Math.min(len + count, maxLen);
        char[] buf = new char[len];
        TextStyle[] styles = new TextStyle[len];
        int p = 0;
        for (TextEntry entry : this.myTextEntries) {
            for (int i = 0; i < entry.getLength() && p < len; ++i) {
                if (p == x) {
                    for (int j = 0; j < count; ++j) {
                        buf[p] = 32;
                        styles[p] = TextStyle.EMPTY;
                        ++p;
                    }
                }
                if (p >= len) continue;
                buf[p] = entry.getText().charAt(i);
                styles[p] = entry.getStyle();
                ++p;
            }
            if (p < len) continue;
            break;
        }
        this.myTextEntries = TerminalLine.collectFromBuffer(buf, styles);
    }

    public void clearArea(int leftX, int rightX, @NotNull TextStyle style) {
        if (leftX < this.myTextEntries.length()) {
            this.writeCharacters(leftX, style, new CharBuffer(' ', Math.min(this.myTextEntries.length(), rightX) - leftX));
        }
    }

    @Nullable
    public TextStyle getStyleAt(int x) {
        int i = 0;
        for (TextEntry te : Lists.newArrayList((Iterable)this.myTextEntries)) {
            if (x >= i && x < i + te.getLength()) {
                return te.getStyle();
            }
            i += te.getLength();
        }
        return null;
    }

    public void process(int y, LinesBuffer.TextEntryProcessor processor) {
        int x = 0;
        for (TextEntry te : Lists.newArrayList((Iterable)this.myTextEntries)) {
            processor.process(x, y, te);
            x += te.getLength();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TextEntries
    implements Iterable<TextEntry> {
        private ArrayList<TextEntry> myTextEntries = new ArrayList();
        private int myLength = 0;

        private TextEntries() {
        }

        public void add(TextEntry entry) {
            this.myTextEntries.add(entry);
            this.myLength += entry.getLength();
        }

        private Collection<TextEntry> entries() {
            return Collections.unmodifiableCollection(this.myTextEntries);
        }

        @Override
        public Iterator<TextEntry> iterator() {
            return this.entries().iterator();
        }

        public int length() {
            return this.myLength;
        }

        public void clear() {
            this.myTextEntries.clear();
            this.myLength = 0;
        }
    }

    static class TextEntry {
        private final TextStyle myStyle;
        private final CharBuffer myText;

        public TextEntry(@NotNull TextStyle style, @NotNull CharBuffer text) {
            this.myStyle = style;
            this.myText = text.clone();
        }

        public TextStyle getStyle() {
            return this.myStyle;
        }

        public CharBuffer getText() {
            return this.myText;
        }

        public int getLength() {
            return this.myText.getLength();
        }
    }
}

