/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.google.common.collect.Lists;
import com.jediterm.terminal.StyledTextConsumer;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.TerminalLine;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinesBuffer {
    private static final Logger LOG = Logger.getLogger(LinesBuffer.class);
    private static final int BUFFER_MAX_LINES = 1000;
    private ArrayList<TerminalLine> myLines = Lists.newArrayList();

    public synchronized String getLines() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (TerminalLine line : this.myLines) {
            if (!first) {
                sb.append("\n");
            }
            sb.append(line.getText());
            first = false;
        }
        return sb.toString();
    }

    public synchronized void addNewLine(@NotNull TextStyle style, @NotNull CharBuffer characters) {
        this.addNewLine(new TerminalLine.TextEntry(style, characters));
    }

    private synchronized void addNewLine(@NotNull TerminalLine.TextEntry entry) {
        this.addLine(new TerminalLine(entry));
    }

    private synchronized void addLine(@NotNull TerminalLine line) {
        if (this.myLines.size() > 1000) {
            this.removeTopLines(1);
        }
        this.myLines.add(line);
    }

    public synchronized int getLineCount() {
        return this.myLines.size();
    }

    public synchronized void removeTopLines(int count) {
        this.myLines = Lists.newArrayList(this.myLines.subList(count, this.myLines.size()));
    }

    public String getLineText(int row) {
        TerminalLine line = this.getLine(row);
        return line.getText();
    }

    public synchronized void insertLines(int y, int count, int lastLine) {
        LinesBuffer tail = new LinesBuffer();
        if (lastLine < this.getLineCount() - 1) {
            this.moveBottomLinesTo(this.getLineCount() - lastLine - 1, tail);
        }
        LinesBuffer head = new LinesBuffer();
        if (y > 0) {
            this.moveTopLinesTo(y, head);
        }
        for (int i = 0; i < count; ++i) {
            head.addNewLine(TextStyle.EMPTY, CharBuffer.EMPTY);
        }
        head.moveBottomLinesTo(head.getLineCount(), this);
        this.removeBottomLines(count);
        tail.moveTopLinesTo(tail.getLineCount(), this);
    }

    public synchronized LinesBuffer deleteLines(int y, int count, int lastLine) {
        LinesBuffer tail = new LinesBuffer();
        if (lastLine < this.getLineCount() - 1) {
            this.moveBottomLinesTo(this.getLineCount() - lastLine - 1, tail);
        }
        LinesBuffer head = new LinesBuffer();
        if (y > 0) {
            this.moveTopLinesTo(y, head);
        }
        int toRemove = Math.min(count, this.getLineCount());
        LinesBuffer removed = new LinesBuffer();
        this.moveTopLinesTo(toRemove, removed);
        head.moveBottomLinesTo(head.getLineCount(), this);
        for (int i = 0; i < toRemove; ++i) {
            this.addNewLine(TextStyle.EMPTY, CharBuffer.EMPTY);
        }
        tail.moveTopLinesTo(tail.getLineCount(), this);
        return removed;
    }

    public synchronized void writeString(int x, int y, String str, @NotNull TextStyle style) {
        TerminalLine line = this.getLine(y);
        line.writeString(x, str, style);
    }

    public synchronized void clearLines(int startRow, int endRow) {
        for (int i = startRow; i <= endRow && i < this.myLines.size(); ++i) {
            TerminalLine line = this.myLines.get(i);
            line.clear();
        }
    }

    public synchronized void clearAll() {
        this.myLines.clear();
    }

    public synchronized void deleteCharacters(int x, int y, int count) {
        TerminalLine line = this.getLine(y);
        line.deleteCharacters(x, count);
    }

    public synchronized void insertBlankCharacters(int x, int y, int count, int maxLen) {
        TerminalLine line = this.getLine(y);
        line.insertBlankCharacters(x, count, maxLen);
    }

    public synchronized void clearArea(int leftX, int topY, int rightX, int bottomY, @NotNull TextStyle style) {
        for (int y = topY; y < bottomY; ++y) {
            TerminalLine line = this.getLine(y);
            line.clearArea(leftX, rightX, style);
        }
    }

    public synchronized void processLines(int yStart, int yCount, final @NotNull StyledTextConsumer consumer, final int startRow) {
        this.iterateLines(yStart, yCount, new TextEntryProcessor(){

            public void process(int x, int y, @NotNull TerminalLine.TextEntry entry) {
                consumer.consume(x, y, entry.getStyle(), entry.getText(), startRow);
            }
        });
    }

    public synchronized void processLines(int yStart, int yCount, @NotNull StyledTextConsumer consumer) {
        this.processLines(yStart, yCount, consumer, -this.getLineCount());
    }

    public synchronized void iterateLines(int firstLine, int count, @NotNull TextEntryProcessor processor) {
        for (int y = firstLine; y < Math.min(firstLine + count, this.myLines.size()); ++y) {
            TerminalLine line = this.myLines.get(y);
            line.process(y, processor);
        }
    }

    public synchronized void moveTopLinesTo(int count, @NotNull LinesBuffer buffer) {
        count = Math.min(count, this.getLineCount());
        buffer.addLines(this.myLines.subList(0, count));
        this.removeTopLines(count);
    }

    public synchronized void addLines(@NotNull List<TerminalLine> lines) {
        this.myLines.addAll(lines);
    }

    @NotNull
    public synchronized TerminalLine getLine(int row) {
        if (row >= this.getLineCount()) {
            for (int i = this.getLineCount(); i <= row; ++i) {
                this.addLine(TerminalLine.createEmpty());
            }
        }
        return this.myLines.get(row);
    }

    public synchronized void moveBottomLinesTo(int count, @NotNull LinesBuffer buffer) {
        count = Math.min(count, this.getLineCount());
        buffer.addLinesFirst(this.myLines.subList(this.getLineCount() - count, this.getLineCount()));
        this.removeBottomLines(count);
    }

    private synchronized void addLinesFirst(@NotNull List<TerminalLine> lines) {
        ArrayList list = Lists.newArrayList(lines);
        list.addAll(this.myLines);
        this.myLines = Lists.newArrayList((Iterable)list);
    }

    private synchronized void removeBottomLines(int count) {
        this.myLines = Lists.newArrayList(this.myLines.subList(0, this.getLineCount() - count));
    }

    static interface TextEntryProcessor {
        public void process(int var1, int var2, @NotNull TerminalLine.TextEntry var3);
    }
}

