/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.debug;

import com.jediterm.terminal.LoggingTtyConnector;
import com.jediterm.terminal.debug.ControlSequenceVisualizer;
import com.jediterm.terminal.ui.TerminalSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DebugBufferType {
    Back{

        public String getValue(TerminalSession session) {
            return session.getBackBuffer().getScreenLines();
        }
    }
    ,
    BackStyle{

        public String getValue(TerminalSession session) {
            return session.getBackBuffer().getStyleLines();
        }
    }
    ,
    Scroll{

        public String getValue(TerminalSession session) {
            return session.getBackBuffer().getHistoryBuffer().getLines();
        }
    }
    ,
    ControlSequences{
        private ControlSequenceVisualizer myVisualizer = new ControlSequenceVisualizer();

        public String getValue(TerminalSession session) {
            if (session.getTtyConnector() instanceof LoggingTtyConnector) {
                return this.myVisualizer.getVisualizedString(((LoggingTtyConnector)((Object)session.getTtyConnector())).getChunks());
            }
            return "Control sequences aren't logged";
        }
    };


    public abstract String getValue(TerminalSession var1);
}

