/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.common.PomManager;
import org.apache.maven.archetype.downloader.DownloadException;
import org.apache.maven.archetype.downloader.DownloadNotFoundException;
import org.apache.maven.archetype.downloader.Downloader;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.metadata.io.xpp3.ArchetypeDescriptorXpp3Reader;
import org.apache.maven.archetype.old.descriptor.ArchetypeDescriptor;
import org.apache.maven.archetype.old.descriptor.ArchetypeDescriptorBuilder;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.model.Model;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultArchetypeArtifactManager
extends AbstractLogEnabled
implements ArchetypeArtifactManager {
    private Downloader downloader;
    private PomManager pomManager;
    private RepositoryMetadataManager repositoryMetadataManager;
    private Map archetypeCache = new TreeMap();

    public File getArchetypeFile(String groupId, String artifactId, String version, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List repositories) throws UnknownArchetype {
        try {
            File archetype = this.getArchetype(groupId, artifactId, version);
            if (archetype == null) {
                archetype = this.downloader.download(groupId, artifactId, version, archetypeRepository, localRepository, repositories);
                this.setArchetype(groupId, artifactId, version, archetype);
            }
            return archetype;
        }
        catch (DownloadNotFoundException ex) {
            throw new UnknownArchetype(ex);
        }
        catch (DownloadException ex) {
            throw new UnknownArchetype(ex);
        }
    }

    public ClassLoader getArchetypeJarLoader(File archetypeFile) throws UnknownArchetype {
        try {
            URL[] urls = new URL[]{archetypeFile.toURI().toURL()};
            return new URLClassLoader(urls);
        }
        catch (MalformedURLException e) {
            throw new UnknownArchetype(e);
        }
    }

    public Model getArchetypePom(File jar) throws XmlPullParserException, UnknownArchetype, IOException {
        String pomFileName = null;
        ZipFile zipFile = this.getArchetypeZipFile(jar);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry el = enumeration.nextElement();
            String entry = el.getName();
            if (!entry.startsWith("META-INF") || !entry.endsWith("pom.xml")) continue;
            pomFileName = entry;
        }
        if (pomFileName == null) {
            return null;
        }
        ZipEntry pom = zipFile.getEntry(StringUtils.replace(pomFileName, (String)File.separator, (String)"/"));
        if (pom == null) {
            pom = zipFile.getEntry(StringUtils.replace(pomFileName, (String)"/", (String)File.separator));
        }
        if (pom == null) {
            return null;
        }
        return this.pomManager.readPom(zipFile.getInputStream(pom));
    }

    public ZipFile getArchetypeZipFile(File archetypeFile) throws UnknownArchetype {
        try {
            return new ZipFile(archetypeFile);
        }
        catch (ZipException e) {
            throw new UnknownArchetype(e);
        }
        catch (IOException e) {
            throw new UnknownArchetype(e);
        }
    }

    public boolean isFileSetArchetype(File archetypeFile) {
        try {
            ZipFile zipFile = this.getArchetypeZipFile(archetypeFile);
            return this.isFileSetArchetype(zipFile);
        }
        catch (XmlPullParserException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        catch (UnknownArchetype e) {
            return false;
        }
    }

    public boolean isFileSetArchetype(String groupId, String artifactId, String version, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List repositories) {
        try {
            ZipFile zipFile = this.getArchetypeZipFile(this.getArchetypeFile(groupId, artifactId, version, archetypeRepository, localRepository, repositories));
            return this.isFileSetArchetype(zipFile);
        }
        catch (XmlPullParserException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        catch (UnknownArchetype e) {
            return false;
        }
    }

    public boolean isOldArchetype(File archetypeFile) {
        try {
            ZipFile zipFile = this.getArchetypeZipFile(archetypeFile);
            return this.isOldArchetype(zipFile);
        }
        catch (XmlPullParserException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        catch (UnknownArchetype e) {
            return false;
        }
    }

    public boolean isOldArchetype(String groupId, String artifactId, String version, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List repositories) {
        try {
            ZipFile zipFile = this.getArchetypeZipFile(this.getArchetypeFile(groupId, artifactId, version, archetypeRepository, localRepository, repositories));
            return this.isOldArchetype(zipFile);
        }
        catch (XmlPullParserException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        catch (UnknownArchetype e) {
            return false;
        }
    }

    public boolean exists(String archetypeGroupId, String archetypeArtifactId, String archetypeVersion, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List remoteRepositories) {
        try {
            File archetype = this.getArchetype(archetypeGroupId, archetypeArtifactId, archetypeVersion);
            if (archetype == null) {
                archetype = this.downloader.download(archetypeGroupId, archetypeArtifactId, archetypeVersion, archetypeRepository, localRepository, remoteRepositories);
                this.setArchetype(archetypeGroupId, archetypeArtifactId, archetypeVersion, archetype);
            }
            return archetype.exists();
        }
        catch (DownloadException e) {
            this.getLogger().debug("Archetype don't exist", (Throwable)e);
            return false;
        }
        catch (DownloadNotFoundException e) {
            this.getLogger().debug("Archetype don't exist", (Throwable)e);
            return false;
        }
    }

    public org.apache.maven.archetype.metadata.ArchetypeDescriptor getFileSetArchetypeDescriptor(File archetypeFile) throws UnknownArchetype {
        try {
            ZipFile zipFile = this.getArchetypeZipFile(archetypeFile);
            return this.loadFileSetArchetypeDescriptor(zipFile);
        }
        catch (XmlPullParserException e) {
            throw new UnknownArchetype(e);
        }
        catch (IOException e) {
            throw new UnknownArchetype(e);
        }
    }

    public org.apache.maven.archetype.metadata.ArchetypeDescriptor getFileSetArchetypeDescriptor(String groupId, String artifactId, String version, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List repositories) throws UnknownArchetype {
        try {
            ZipFile zipFile = this.getArchetypeZipFile(this.getArchetypeFile(groupId, artifactId, version, archetypeRepository, localRepository, repositories));
            return this.loadFileSetArchetypeDescriptor(zipFile);
        }
        catch (XmlPullParserException e) {
            throw new UnknownArchetype(e);
        }
        catch (IOException e) {
            throw new UnknownArchetype(e);
        }
    }

    public List getFilesetArchetypeResources(File archetypeFile) throws UnknownArchetype {
        ArrayList<String> archetypeResources = new ArrayList<String>();
        ZipFile zipFile = this.getArchetypeZipFile(archetypeFile);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry entry = enumeration.nextElement();
            if (!entry.isDirectory() && entry.getName().startsWith("archetype-resources")) {
                String resource = StringUtils.replace((String)entry.getName(), (String)"archetype-resources/", (String)"");
                this.getLogger().debug("Found resource " + resource);
                archetypeResources.add(resource);
                continue;
            }
            this.getLogger().debug("Not resource " + entry.getName());
        }
        return archetypeResources;
    }

    public ArchetypeDescriptor getOldArchetypeDescriptor(File archetypeFile) throws UnknownArchetype {
        try {
            ZipFile zipFile = this.getArchetypeZipFile(archetypeFile);
            return this.loadOldArchetypeDescriptor(zipFile);
        }
        catch (XmlPullParserException e) {
            throw new UnknownArchetype(e);
        }
        catch (IOException e) {
            throw new UnknownArchetype(e);
        }
    }

    public ArchetypeDescriptor getOldArchetypeDescriptor(String groupId, String artifactId, String version, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List repositories) throws UnknownArchetype {
        try {
            ZipFile zipFile = this.getArchetypeZipFile(this.getArchetypeFile(groupId, artifactId, version, archetypeRepository, localRepository, repositories));
            return this.loadOldArchetypeDescriptor(zipFile);
        }
        catch (XmlPullParserException e) {
            throw new UnknownArchetype(e);
        }
        catch (IOException e) {
            throw new UnknownArchetype(e);
        }
    }

    private File getArchetype(String archetypeGroupId, String archetypeArtifactId, String archetypeVersion) {
        String key = archetypeGroupId + ":" + archetypeArtifactId + ":" + archetypeVersion;
        if (this.archetypeCache.containsKey(key)) {
            this.getLogger().debug("Found archetype " + key + " in cache: " + this.archetypeCache.get(key));
            return (File)this.archetypeCache.get(key);
        }
        this.getLogger().debug("Not found archetype " + key + " in cache");
        return null;
    }

    private void setArchetype(String archetypeGroupId, String archetypeArtifactId, String archetypeVersion, File archetype) {
        String key = archetypeGroupId + ":" + archetypeArtifactId + ":" + archetypeVersion;
        this.archetypeCache.put(key, archetype);
    }

    private Reader getArchetypeDescriptorReader(ZipFile zipFile) throws IOException {
        ZipEntry entry = zipFile.getEntry(StringUtils.replace((String)"META-INF/maven/archetype-metadata.xml", (String)File.separator, (String)"/"));
        if (entry == null) {
            this.getLogger().debug("No found META-INF/maven/archetype-metadata.xml retrying with windows path");
            entry = zipFile.getEntry(StringUtils.replace((String)"META-INF/maven/archetype-metadata.xml", (String)"/", (String)File.separator));
        }
        if (entry == null) {
            throw new IOException("The META-INF/maven/archetype-metadata.xml descriptor cannot be found.");
        }
        InputStream is = zipFile.getInputStream(entry);
        if (is == null) {
            throw new IOException("The META-INF/maven/archetype-metadata.xml descriptor cannot be found.");
        }
        return new InputStreamReader(is);
    }

    private boolean isFileSetArchetype(ZipFile zipFile) throws IOException, XmlPullParserException {
        org.apache.maven.archetype.metadata.ArchetypeDescriptor descriptor = this.loadFileSetArchetypeDescriptor(zipFile);
        return descriptor.getName() != null;
    }

    private boolean isOldArchetype(ZipFile zipFile) throws IOException, XmlPullParserException {
        ArchetypeDescriptor descriptor = this.loadOldArchetypeDescriptor(zipFile);
        return descriptor.getId() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.apache.maven.archetype.metadata.ArchetypeDescriptor loadFileSetArchetypeDescriptor(ZipFile zipFile) throws IOException, XmlPullParserException {
        Reader reader = this.getArchetypeDescriptorReader(zipFile);
        ArchetypeDescriptorXpp3Reader archetypeReader = new ArchetypeDescriptorXpp3Reader();
        try {
            org.apache.maven.archetype.metadata.ArchetypeDescriptor archetypeDescriptor = archetypeReader.read(reader, true);
            return archetypeDescriptor;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArchetypeDescriptor loadOldArchetypeDescriptor(ZipFile zipFile) throws IOException, XmlPullParserException {
        ArchetypeDescriptorBuilder builder = new ArchetypeDescriptorBuilder();
        ArchetypeDescriptor descriptor = null;
        Reader reader = null;
        try {
            reader = this.getOldArchetypeDescriptorReader(zipFile);
            descriptor = builder.build(reader);
        }
        catch (IOException ex) {
            this.getLogger().debug("Can not load old archetype", (Throwable)ex);
        }
        catch (XmlPullParserException ex) {
            this.getLogger().debug("Can not load old archetype", (Throwable)ex);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (descriptor == null) {
            try {
                reader = this.getOlderArchetypeDescriptorReader(zipFile);
                descriptor = builder.build(reader);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        return descriptor;
    }

    private Reader getOldArchetypeDescriptorReader(ZipFile zipFile) throws IOException {
        ZipEntry entry = zipFile.getEntry(StringUtils.replace((String)"META-INF/maven/archetype.xml", (String)File.separator, (String)"/"));
        if (entry == null) {
            this.getLogger().debug("No found META-INF/maven/archetype.xml retrying with windows path");
            entry = zipFile.getEntry(StringUtils.replace((String)"META-INF/maven/archetype.xml", (String)"/", (String)File.separator));
        }
        if (entry == null) {
            throw new IOException("The META-INF/maven/archetype.xml descriptor cannot be found.");
        }
        InputStream is = zipFile.getInputStream(entry);
        if (is == null) {
            throw new IOException("The META-INF/maven/archetype.xml descriptor cannot be found.");
        }
        return new InputStreamReader(is);
    }

    private Reader getOlderArchetypeDescriptorReader(ZipFile zipFile) throws IOException {
        ZipEntry entry = zipFile.getEntry(StringUtils.replace((String)"META-INF/archetype.xml", (String)File.separator, (String)"/"));
        if (entry == null) {
            this.getLogger().debug("No found META-INF/archetype.xml retrying with windows path");
            entry = zipFile.getEntry(StringUtils.replace((String)"META-INF/archetype.xml", (String)"/", (String)File.separator));
        }
        if (entry == null) {
            throw new IOException("The META-INF/archetype.xml descriptor cannot be found.");
        }
        InputStream is = zipFile.getInputStream(entry);
        if (is == null) {
            throw new IOException("The META-INF/archetype.xml descriptor cannot be found.");
        }
        return new InputStreamReader(is);
    }
}

