/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StringLiteralReference
implements PsiReference {
    protected final PsiLiteral myValue;

    public StringLiteralReference(PsiLiteral value) {
        this.myValue = value;
    }

    public PsiElement getElement() {
        return this.myValue;
    }

    public TextRange getRangeInElement() {
        return ElementManipulators.getValueTextRange((PsiElement)this.myValue);
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myValue.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/util/StringLiteralReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this.myValue;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/intelliLang/util/StringLiteralReference", "bindToElement"));
        }
        return this.myValue;
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.resolve() == element;
    }

    @Nullable
    protected String getValue() {
        return (String)this.myValue.getValue();
    }
}

