/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.references;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedReferenceVisitor;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.TemporaryPlacesRegistry;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectedReferencesContributor
extends PsiReferenceContributor {
    private static final Key<PsiReference[]> INJECTED_REFERENCES = Key.create((String)"injected references");

    public static boolean isInjected(@Nullable PsiReference reference) {
        return reference != null && reference.getElement().getUserData(INJECTED_REFERENCES) != null;
    }

    @Nullable
    public static PsiReference[] getInjectedReferences(PsiElement element) {
        element.getReferences();
        return (PsiReference[])element.getUserData(INJECTED_REFERENCES);
    }

    public void registerReferenceProviders(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/intelliLang/references/InjectedReferencesContributor$1", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/plugins/intelliLang/references/InjectedReferencesContributor$1", "getReferencesByElement"));
                }
                ReferenceInjector[] extensions = (ReferenceInjector[])ReferenceInjector.EXTENSION_POINT_NAME.getExtensions();
                SmartList references = new SmartList();
                Configuration configuration = Configuration.getProjectInstance(element.getProject());
                final Ref injected = new Ref((Object)Boolean.FALSE);
                for (ReferenceInjector injector : extensions) {
                    Collection<BaseInjection> injections = configuration.getInjectionsByLanguageId(injector.getId());
                    for (BaseInjection injection : injections) {
                        if (!injection.acceptForReference(element)) continue;
                        injected.set((Object)Boolean.TRUE);
                        LanguageInjectionSupport support = InjectorUtils.findInjectionSupport(injection.getSupportId());
                        element.putUserData(LanguageInjectionSupport.INJECTOR_SUPPORT, (Object)support);
                        List<TextRange> area = injection.getInjectedArea(element);
                        for (TextRange range : area) {
                            references.addAll(Arrays.asList(injector.getReferences(element, context, range)));
                        }
                    }
                }
                if (element instanceof PsiLanguageInjectionHost) {
                    final TemporaryPlacesRegistry registry = TemporaryPlacesRegistry.getInstance(element.getProject());
                    InjectedLanguage language = registry.getLanguageFor((PsiLanguageInjectionHost)element, element.getContainingFile());
                    if (language != null) {
                        ReferenceInjector injector = ReferenceInjector.findById((String)language.getID());
                        if (injector != null) {
                            injected.set((Object)Boolean.TRUE);
                            element.putUserData(LanguageInjectionSupport.INJECTOR_SUPPORT, (Object)registry.getLanguageInjectionSupport());
                            TextRange range = ElementManipulators.getValueTextRange((PsiElement)element);
                            references.addAll(Arrays.asList(injector.getReferences(element, context, range)));
                        }
                    } else {
                        InjectedLanguageUtil.enumerate((PsiElement)element, (PsiFile)element.getContainingFile(), (boolean)false, (PsiLanguageInjectionHost.InjectedPsiVisitor)new InjectedReferenceVisitor((List)references, context){
                            final /* synthetic */ List val$references;
                            final /* synthetic */ ProcessingContext val$context;
                            {
                                this.val$references = list;
                                this.val$context = processingContext;
                            }

                            public void visitInjectedReference(@NotNull ReferenceInjector injector, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                                if (injector == null) {
                                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/intelliLang/references/InjectedReferencesContributor$1$1", "visitInjectedReference"));
                                }
                                if (places == null) {
                                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/plugins/intelliLang/references/InjectedReferencesContributor$1$1", "visitInjectedReference"));
                                }
                                injected.set((Object)Boolean.TRUE);
                                element.putUserData(LanguageInjectionSupport.INJECTOR_SUPPORT, (Object)registry.getLanguageInjectionSupport());
                                for (PsiLanguageInjectionHost.Shred place : places) {
                                    this.val$references.addAll(Arrays.asList(injector.getReferences(element, this.val$context, place.getRangeInsideHost())));
                                }
                            }
                        });
                    }
                }
                PsiReference[] array = references.toArray(new PsiReference[references.size()]);
                element.putUserData(INJECTED_REFERENCES, (Boolean)injected.get() != false ? array : null);
                if (array == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/references/InjectedReferencesContributor$1", "getReferencesByElement"));
                }
                return array;
            }
        });
    }
}

