/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.pattern.compiler;

import com.intellij.compiler.PsiClassWriter;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.ClassInstrumentingCompiler;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.util.Processor;
import java.io.DataInput;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.intellij.plugins.intelliLang.pattern.compiler.InstrumentationException;
import org.intellij.plugins.intelliLang.pattern.compiler.InstrumentationItem;
import org.intellij.plugins.intelliLang.pattern.compiler.Instrumenter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public abstract class AnnotationBasedInstrumentingCompiler
implements ClassInstrumentingCompiler {
    private static final Logger LOG = Logger.getInstance((String)"org.intellij.lang.pattern.compiler.AnnotationBasedInstrumentingCompiler");

    @NotNull
    public FileProcessingCompiler.ProcessingItem[] getProcessingItems(final CompileContext context) {
        if (!this.isEnabled()) {
            if (FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/pattern/compiler/AnnotationBasedInstrumentingCompiler", "getProcessingItems"));
            }
            return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
        }
        final Project project = context.getProject();
        final HashSet result = new HashSet();
        final PsiSearchHelper searchHelper = PsiSearchHelper.SERVICE.getInstance((Project)context.getProject());
        DumbService.getInstance((Project)project).runReadActionInSmartMode(new Runnable(){

            @Override
            public void run() {
                String[] names;
                for (String name : names = AnnotationBasedInstrumentingCompiler.this.getAnnotationNames(project)) {
                    GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
                    PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(name, GlobalSearchScope.allScope((Project)project));
                    if (psiClass == null) {
                        context.addMessage(CompilerMessageCategory.ERROR, "Cannot find class " + name, null, -1, -1);
                        continue;
                    }
                    searchHelper.processAllFilesWithWord(StringUtil.getShortName((String)name), scope, (Processor)new Processor<PsiFile>(){

                        public boolean process(PsiFile psifile) {
                            if (StdLanguages.JAVA == psifile.getLanguage() && psifile.getVirtualFile() != null && psifile instanceof PsiJavaFile) {
                                AnnotationBasedInstrumentingCompiler.addClassFiles((PsiJavaFile)psifile, result, project);
                            }
                            return true;
                        }
                    }, true);
                }
            }
        });
        FileProcessingCompiler.ProcessingItem[] processingItemArray = result.toArray(new FileProcessingCompiler.ProcessingItem[result.size()]);
        if (processingItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/pattern/compiler/AnnotationBasedInstrumentingCompiler", "getProcessingItems"));
        }
        return processingItemArray;
    }

    private static void addClassFiles(PsiJavaFile srcFile, Set<InstrumentationItem> result, Project project) {
        VirtualFile sourceFile = srcFile.getVirtualFile();
        assert (sourceFile != null);
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = index.getModuleForFile(sourceFile);
        if (module != null) {
            VirtualFile compilerOutputPath;
            Sdk jdk = ModuleRootManager.getInstance((Module)module).getSdk();
            boolean jdk6 = jdk != null && JavaSdk.getInstance().isOfVersionOrHigher(jdk, JavaSdkVersion.JDK_1_6);
            CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
            VirtualFile virtualFile = compilerOutputPath = extension != null ? extension.getCompilerOutputPath() : null;
            if (compilerOutputPath != null) {
                VirtualFile packageDir;
                String packageName = srcFile.getPackageName();
                VirtualFile virtualFile2 = packageDir = packageName.length() > 0 ? compilerOutputPath.findFileByRelativePath(packageName.replace('.', '/')) : compilerOutputPath;
                if (packageDir != null && packageDir.isDirectory()) {
                    VirtualFile[] children;
                    PsiClass[] classes = srcFile.getClasses();
                    for (VirtualFile classFile : children = packageDir.getChildren()) {
                        if (classFile.isDirectory() || !"class".equals(classFile.getExtension())) continue;
                        String name = classFile.getName();
                        for (PsiClass clazz : classes) {
                            String className = clazz.getName();
                            if (className == null || !name.startsWith(className)) continue;
                            result.add(new InstrumentationItem(classFile, jdk6));
                        }
                    }
                }
            }
        }
    }

    public FileProcessingCompiler.ProcessingItem[] process(final CompileContext context, final FileProcessingCompiler.ProcessingItem[] items) {
        final ProgressIndicator progressIndicator = context.getProgressIndicator();
        progressIndicator.setText(this.getProgressMessage());
        final Project project = context.getProject();
        final ArrayList result = new ArrayList(items.length);
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int filesProcessed = 0;
                for (FileProcessingCompiler.ProcessingItem pi : items) {
                    InstrumentationItem item = (InstrumentationItem)pi;
                    VirtualFile classFile = item.getClassFile();
                    try {
                        ClassReader classreader;
                        byte[] bytes = classFile.contentsToByteArray();
                        try {
                            classreader = new ClassReader(bytes, 0, bytes.length);
                        }
                        catch (Exception e) {
                            LOG.debug("ASM failed to read class file <" + classFile.getPresentableUrl() + ">", (Throwable)e);
                            continue;
                        }
                        PsiClassWriter classwriter = new PsiClassWriter(project, item.isJDK6());
                        Instrumenter instrumenter = AnnotationBasedInstrumentingCompiler.this.createInstrumenter((ClassWriter)classwriter);
                        classreader.accept((ClassVisitor)instrumenter, 0);
                        if (instrumenter.instrumented()) {
                            FileOutputStream out = new FileOutputStream(classFile.getPath());
                            try {
                                out.write(classwriter.toByteArray());
                            }
                            finally {
                                out.close();
                            }
                        }
                        result.add(item);
                        progressIndicator.setFraction((double)(++filesProcessed) / (double)items.length);
                    }
                    catch (InstrumentationException e) {
                        context.addMessage(CompilerMessageCategory.ERROR, "[" + AnnotationBasedInstrumentingCompiler.this.getDescription() + "]: " + e.getLocalizedMessage(), null, -1, -1);
                    }
                    catch (IOException e) {
                        context.addMessage(CompilerMessageCategory.ERROR, "[" + AnnotationBasedInstrumentingCompiler.this.getDescription() + "]: " + e.getLocalizedMessage(), null, -1, -1);
                    }
                }
            }
        });
        return result.toArray(new FileProcessingCompiler.ProcessingItem[result.size()]);
    }

    protected abstract boolean isEnabled();

    protected abstract String[] getAnnotationNames(Project var1);

    protected abstract Instrumenter createInstrumenter(ClassWriter var1);

    protected abstract String getProgressMessage();

    public boolean validateConfiguration(CompileScope compilescope) {
        return true;
    }

    @Nullable
    public ValidityState createValidityState(DataInput datainputstream) throws IOException {
        return null;
    }
}

