/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.java;

import com.intellij.lang.Language;
import com.intellij.lang.injection.ConcatenationAwareInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.java.stubs.index.JavaAnnotationIndex;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PatternValuesIndex;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.TemporaryPlacesRegistry;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.intellij.plugins.intelliLang.util.ContextComputationProcessor;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.jetbrains.annotations.NotNull;

public class ConcatenationInjector
implements ConcatenationAwareInjector {
    private final Configuration myConfiguration;
    private final Project myProject;
    private final TemporaryPlacesRegistry myTemporaryPlacesRegistry;
    private final CachedValue<Collection<String>> myAnnoIndex;
    private final CachedValue<Collection<String>> myXmlIndex;
    private final LanguageInjectionSupport mySupport;

    public ConcatenationInjector(Configuration configuration, Project project, TemporaryPlacesRegistry temporaryPlacesRegistry) {
        this.myConfiguration = configuration;
        this.myProject = project;
        this.myTemporaryPlacesRegistry = temporaryPlacesRegistry;
        this.mySupport = InjectorUtils.findNotNullInjectionSupport("java");
        this.myXmlIndex = CachedValuesManager.getManager((Project)this.myProject).createCachedValue((CachedValueProvider)new CachedValueProvider<Collection<String>>(){

            public CachedValueProvider.Result<Collection<String>> compute() {
                THashMap map = new THashMap();
                for (BaseInjection injection : ConcatenationInjector.this.myConfiguration.getInjections("java")) {
                    for (InjectionPlace place : injection.getInjectionPlaces()) {
                        if (!place.isEnabled() || place.getElementPattern() == null) continue;
                        map.put(place.getElementPattern(), injection);
                    }
                }
                Set stringSet = PatternValuesIndex.buildStringIndex(map.keySet());
                return new CachedValueProvider.Result((Object)stringSet, new Object[]{ConcatenationInjector.this.myConfiguration});
            }
        }, false);
        this.myAnnoIndex = CachedValuesManager.getManager((Project)this.myProject).createCachedValue((CachedValueProvider)new CachedValueProvider<Collection<String>>(){

            public CachedValueProvider.Result<Collection<String>> compute() {
                String annotationClass = ConcatenationInjector.this.myConfiguration.getAdvancedConfiguration().getLanguageAnnotationClass();
                THashSet result = new THashSet();
                ArrayList<String> annoClasses = new ArrayList<String>(3);
                annoClasses.add(StringUtil.getShortName((String)annotationClass));
                for (int cursor = 0; cursor < annoClasses.size(); ++cursor) {
                    String annoClass = (String)annoClasses.get(cursor);
                    for (PsiAnnotation annotation : JavaAnnotationIndex.getInstance().get(annoClass, ConcatenationInjector.this.myProject, GlobalSearchScope.allScope((Project)ConcatenationInjector.this.myProject))) {
                        PsiElement modList = annotation.getParent();
                        if (!(modList instanceof PsiModifierList)) continue;
                        PsiElement element = modList.getParent();
                        if (element instanceof PsiParameter) {
                            PsiElement scope = ((PsiParameter)element).getDeclarationScope();
                            if (scope instanceof PsiNamedElement) {
                                ContainerUtil.addIfNotNull((Object)((PsiNamedElement)scope).getName(), (Collection)result);
                                continue;
                            }
                            ContainerUtil.addIfNotNull((Object)((PsiNamedElement)element).getName(), (Collection)result);
                            continue;
                        }
                        if (!(element instanceof PsiNamedElement)) continue;
                        if (element instanceof PsiClass && ((PsiClass)element).isAnnotationType()) {
                            String s = ((PsiClass)element).getName();
                            if (annoClasses.contains(s)) continue;
                            annoClasses.add(s);
                            continue;
                        }
                        ContainerUtil.addIfNotNull((Object)((PsiNamedElement)element).getName(), (Collection)result);
                    }
                }
                return new CachedValueProvider.Result((Object)result, new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ConcatenationInjector.this.myConfiguration});
            }
        }, false);
    }

    public void getLanguagesToInject(final @NotNull MultiHostRegistrar registrar, PsiElement ... operands) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/intelliLang/inject/java/ConcatenationInjector", "getLanguagesToInject"));
        }
        if (operands == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/plugins/intelliLang/inject/java/ConcatenationInjector", "getLanguagesToInject"));
        }
        if (operands.length == 0) {
            return;
        }
        boolean hasLiteral = false;
        InjectedLanguage tempInjectedLanguage = null;
        PsiFile containingFile = null;
        for (PsiElement operand : operands) {
            if (!PsiUtilEx.isStringOrCharacterLiteral(operand)) continue;
            if (containingFile == null) {
                containingFile = operands[0].getContainingFile();
            }
            tempInjectedLanguage = this.myTemporaryPlacesRegistry.getLanguageFor((PsiLanguageInjectionHost)operand, containingFile);
            hasLiteral = true;
            if (tempInjectedLanguage != null) break;
        }
        if (!hasLiteral) {
            return;
        }
        Language tempLanguage = tempInjectedLanguage == null ? null : tempInjectedLanguage.getLanguage();
        final PsiFile finalContainingFile = containingFile;
        InjectionProcessor injectionProcessor = new InjectionProcessor(this.myConfiguration, this.mySupport, operands){

            @Override
            protected void processInjection(Language language, List<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>> list, boolean settingsAvailable, boolean unparsable) {
                InjectorUtils.registerInjection(language, list, finalContainingFile, registrar);
                InjectorUtils.registerSupport(ConcatenationInjector.this.mySupport, settingsAvailable, registrar);
                InjectorUtils.putInjectedFileUserData(registrar, InjectedLanguageUtil.FRANKENSTEIN_INJECTION, unparsable ? Boolean.TRUE : null);
            }

            @Override
            protected boolean areThereInjectionsWithName(String methodName, boolean annoOnly) {
                if (ConcatenationInjector.this.getAnnotatedElementsValue().contains(methodName)) {
                    return true;
                }
                return !annoOnly && ConcatenationInjector.this.getXmlAnnotatedElementsValue().contains(methodName);
            }
        };
        if (tempLanguage != null) {
            BaseInjection baseInjection = new BaseInjection("java");
            baseInjection.setInjectedLanguageId(tempInjectedLanguage.getID());
            injectionProcessor.processInjectionInner(baseInjection, false);
            InjectorUtils.putInjectedFileUserData(registrar, LanguageInjectionSupport.TEMPORARY_INJECTED_LANGUAGE, tempInjectedLanguage);
        } else {
            injectionProcessor.processInjections();
        }
    }

    private static boolean checkUnparsableReference(PsiExpression refExpression) {
        PsiElement parent = refExpression.getParent();
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            IElementType operation = assignmentExpression.getOperationTokenType();
            if (assignmentExpression.getLExpression() == refExpression && JavaTokenType.PLUSEQ.equals(operation)) {
                return true;
            }
        } else if (parent instanceof PsiPolyadicExpression) {
            return true;
        }
        return false;
    }

    public Collection<String> getAnnotatedElementsValue() {
        return (Collection)this.myAnnoIndex.getValue();
    }

    private Collection<String> getXmlAnnotatedElementsValue() {
        return (Collection)this.myXmlIndex.getValue();
    }

    public static class InjectionProcessor {
        private final Configuration myConfiguration;
        private final LanguageInjectionSupport mySupport;
        private final PsiElement[] myOperands;
        private boolean myShouldStop;
        private boolean myUnparsable;

        public InjectionProcessor(Configuration configuration, LanguageInjectionSupport support, PsiElement ... operands) {
            this.myConfiguration = configuration;
            this.mySupport = support;
            this.myOperands = operands;
        }

        public void processInjections() {
            PsiElement firstOperand = this.myOperands[0];
            PsiElement topBlock = PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)firstOperand, null);
            final LocalSearchScope searchScope = new LocalSearchScope(new PsiElement[]{topBlock instanceof PsiCodeBlock ? topBlock : firstOperand.getContainingFile()}, "", true);
            final THashSet visitedVars = new THashSet();
            final LinkedList<PsiElement> places = new LinkedList<PsiElement>();
            places.add(firstOperand);
            AnnotationUtilEx.AnnotatedElementVisitor visitor = new AnnotationUtilEx.AnnotatedElementVisitor(){

                @Override
                public boolean visitMethodParameter(PsiExpression expression, PsiCallExpression psiCallExpression) {
                    String methodName;
                    PsiExpressionList list = psiCallExpression.getArgumentList();
                    assert (list != null);
                    int index = ArrayUtil.indexOf((Object[])list.getExpressions(), (Object)expression);
                    if (psiCallExpression instanceof PsiMethodCallExpression) {
                        String referenceName = ((PsiMethodCallExpression)psiCallExpression).getMethodExpression().getReferenceName();
                        if ("super".equals(referenceName) || "this".equals(referenceName)) {
                            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiCallExpression, PsiClass.class, (boolean)true);
                            PsiClass psiTargetClass = "super".equals(referenceName) ? (psiClass == null ? null : psiClass.getSuperClass()) : psiClass;
                            methodName = psiTargetClass == null ? null : psiTargetClass.getName();
                        } else {
                            methodName = referenceName;
                        }
                    } else {
                        PsiJavaCodeReferenceElement classRef;
                        methodName = psiCallExpression instanceof PsiNewExpression ? ((classRef = ((PsiNewExpression)psiCallExpression).getClassOrAnonymousClassReference()) == null ? null : classRef.getReferenceName()) : null;
                    }
                    if (methodName != null && InjectionProcessor.this.areThereInjectionsWithName(methodName, false)) {
                        PsiParameter[] parameters;
                        PsiMethod method = psiCallExpression.resolveMethod();
                        PsiParameter[] psiParameterArray = parameters = method == null ? PsiParameter.EMPTY_ARRAY : method.getParameterList().getParameters();
                        if (index >= 0 && index < parameters.length && method != null) {
                            InjectionProcessor.this.process((PsiModifierListOwner)parameters[index], method, index);
                        }
                    }
                    return false;
                }

                @Override
                public boolean visitMethodReturnStatement(PsiReturnStatement parent, PsiMethod method) {
                    if (InjectionProcessor.this.areThereInjectionsWithName(method.getName(), false)) {
                        InjectionProcessor.this.process((PsiModifierListOwner)method, method, -1);
                    }
                    return false;
                }

                @Override
                public boolean visitVariable(PsiVariable variable) {
                    if (InjectionProcessor.this.myConfiguration.getAdvancedConfiguration().getDfaOption() != Configuration.DfaOption.OFF && visitedVars.add((Object)variable)) {
                        ReferencesSearch.search((PsiElement)variable, (SearchScope)searchScope).forEach((Processor)new Processor<PsiReference>(){

                            public boolean process(PsiReference psiReference) {
                                PsiElement element = psiReference.getElement();
                                if (element instanceof PsiExpression) {
                                    PsiExpression refExpression = (PsiExpression)element;
                                    places.add(refExpression);
                                    if (!InjectionProcessor.this.myUnparsable) {
                                        InjectionProcessor.this.myUnparsable = ConcatenationInjector.checkUnparsableReference(refExpression);
                                    }
                                }
                                return true;
                            }
                        });
                    }
                    if (!InjectionProcessor.this.processCommentInjections(variable)) {
                        InjectionProcessor.this.myShouldStop = true;
                    } else if (InjectionProcessor.this.areThereInjectionsWithName(variable.getName(), false)) {
                        InjectionProcessor.this.process((PsiModifierListOwner)variable, null, -1);
                    }
                    return false;
                }

                @Override
                public boolean visitAnnotationParameter(PsiNameValuePair nameValuePair, PsiAnnotation psiAnnotation) {
                    String methodName;
                    String paramName = nameValuePair.getName();
                    String string = methodName = paramName != null ? paramName : "value";
                    if (InjectionProcessor.this.areThereInjectionsWithName(methodName, false)) {
                        PsiElement element;
                        PsiReference reference = nameValuePair.getReference();
                        PsiElement psiElement = element = reference == null ? null : reference.resolve();
                        if (element instanceof PsiMethod) {
                            InjectionProcessor.this.process((PsiModifierListOwner)((PsiMethod)element), (PsiMethod)element, -1);
                        }
                    }
                    return false;
                }

                @Override
                public boolean visitReference(PsiReferenceExpression expression) {
                    if (InjectionProcessor.this.myConfiguration.getAdvancedConfiguration().getDfaOption() == Configuration.DfaOption.OFF) {
                        return true;
                    }
                    PsiElement e = expression.resolve();
                    if (e instanceof PsiVariable) {
                        if (e instanceof PsiParameter) {
                            PsiParameterList parameterList;
                            PsiParameter p = (PsiParameter)e;
                            PsiElement declarationScope = p.getDeclarationScope();
                            PsiMethod method = declarationScope instanceof PsiMethod ? (PsiMethod)declarationScope : null;
                            PsiParameterList psiParameterList = parameterList = method == null ? null : method.getParameterList();
                            if (parameterList != null && parameterList == e.getParent() && InjectionProcessor.this.areThereInjectionsWithName(method.getName(), false)) {
                                int parameterIndex = parameterList.getParameterIndex((PsiParameter)e);
                                InjectionProcessor.this.process((PsiModifierListOwner)e, method, parameterIndex);
                            }
                        }
                        this.visitVariable((PsiVariable)e);
                    }
                    return !InjectionProcessor.this.myShouldStop;
                }
            };
            while (!places.isEmpty() && !this.myShouldStop) {
                PsiElement curPlace = (PsiElement)places.removeFirst();
                AnnotationUtilEx.visitAnnotatedElements(curPlace, visitor);
            }
        }

        private boolean processCommentInjections(PsiVariable owner) {
            PsiVariable anchor;
            Ref causeRef = Ref.create();
            Object object = owner.getFirstChild() instanceof PsiComment ? (owner.getModifierList() != null ? owner.getModifierList() : owner.getTypeElement()) : (anchor = owner);
            if (anchor == null) {
                return true;
            }
            BaseInjection injection = this.mySupport.findCommentInjection((PsiElement)anchor, (Ref<PsiElement>)causeRef);
            return injection == null || this.processCommentInjectionInner(owner, (PsiElement)causeRef.get(), injection);
        }

        protected boolean processCommentInjectionInner(PsiVariable owner, PsiElement comment, BaseInjection injection) {
            this.processInjectionWithContext(injection, false);
            return false;
        }

        private void process(PsiModifierListOwner owner, PsiMethod method, int paramIndex) {
            if (!this.processAnnotationInjections(owner)) {
                this.myShouldStop = true;
            }
            for (BaseInjection injection : this.myConfiguration.getInjections("java")) {
                if (!injection.acceptsPsiElement((PsiElement)owner) || this.processXmlInjections(injection, owner, method, paramIndex)) continue;
                this.myShouldStop = true;
                break;
            }
        }

        private boolean processAnnotationInjections(PsiModifierListOwner annoElement) {
            PsiElement scope;
            String checkName = annoElement instanceof PsiParameter ? ((scope = ((PsiParameter)annoElement).getDeclarationScope()) instanceof PsiMethod ? ((PsiNamedElement)scope).getName() : ((PsiNamedElement)annoElement).getName()) : (annoElement instanceof PsiNamedElement ? ((PsiNamedElement)annoElement).getName() : null);
            if (checkName == null || !this.areThereInjectionsWithName(checkName, true)) {
                return true;
            }
            PsiAnnotation[] annotations = AnnotationUtilEx.getAnnotationFrom(annoElement, this.myConfiguration.getAdvancedConfiguration().getLanguageAnnotationPair(), true);
            if (annotations.length > 0) {
                return this.processAnnotationInjectionInner(annoElement, annotations);
            }
            return true;
        }

        protected boolean processAnnotationInjectionInner(PsiModifierListOwner owner, PsiAnnotation[] annotations) {
            String id = AnnotationUtilEx.calcAnnotationValue(annotations, "value");
            String prefix = AnnotationUtilEx.calcAnnotationValue(annotations, "prefix");
            String suffix = AnnotationUtilEx.calcAnnotationValue(annotations, "suffix");
            BaseInjection injection = new BaseInjection("java");
            if (prefix != null) {
                injection.setPrefix(prefix);
            }
            if (suffix != null) {
                injection.setSuffix(suffix);
            }
            if (id != null) {
                injection.setInjectedLanguageId(id);
            }
            this.processInjectionWithContext(injection, false);
            return false;
        }

        protected boolean processXmlInjections(BaseInjection injection, PsiModifierListOwner owner, PsiMethod method, int paramIndex) {
            this.processInjectionWithContext(injection, true);
            return !injection.isTerminal();
        }

        protected void processInjectionInner(BaseInjection injection, boolean settingsAvailable) {
            this.processInjectionWithContext(injection, settingsAvailable);
        }

        /*
         * WARNING - void declaration
         */
        private void processInjectionWithContext(BaseInjection injection, boolean settingsAvailable) {
            Language language = InjectedLanguage.findLanguageById(injection.getInjectedLanguageId());
            if (language == null) {
                ReferenceInjector injector = ReferenceInjector.findById((String)injection.getInjectedLanguageId());
                if (injector != null) {
                    language = injector.toLanguage();
                } else {
                    return;
                }
            }
            boolean separateFiles = !injection.isSingleFile() && StringUtil.isNotEmpty((String)injection.getValuePattern());
            Ref unparsableRef = Ref.create((Object)this.myUnparsable);
            List<Object> objects = ContextComputationProcessor.collectOperands(injection.getPrefix(), injection.getSuffix(), (Ref<Boolean>)unparsableRef, this.myOperands);
            if (objects.isEmpty()) {
                return;
            }
            ArrayList<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>> result = new ArrayList<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>>();
            int len = objects.size();
            for (int i = 0; i < len; ++i) {
                void var10_12;
                Object var10_13 = null;
                Object o = objects.get(i);
                if (o instanceof String) {
                    String string = (String)o;
                    if (i == len - 1) {
                        return;
                    }
                    o = objects.get(++i);
                }
                String curSuffix = null;
                PsiLanguageInjectionHost curHost = null;
                if (o instanceof PsiLanguageInjectionHost) {
                    Object next;
                    curHost = (PsiLanguageInjectionHost)o;
                    if (i == len - 2 && (next = objects.get(i + 1)) instanceof String) {
                        ++i;
                        curSuffix = (String)next;
                    }
                }
                if (curHost == null) {
                    unparsableRef.set((Object)Boolean.TRUE);
                    continue;
                }
                if (!(curHost instanceof PsiLiteralExpression)) {
                    TextRange textRange = ElementManipulators.getManipulator((PsiElement)curHost).getRangeInElement((PsiElement)curHost);
                    ProperTextRange.assertProperRange((Segment)textRange, (Object)injection);
                    result.add((Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>)Trinity.create((Object)curHost, (Object)InjectedLanguage.create(injection.getInjectedLanguageId(), (String)var10_12, curSuffix, true), (Object)textRange));
                    continue;
                }
                List<TextRange> injectedArea = injection.getInjectedArea((PsiElement)curHost);
                int injectedAreaSize = injectedArea.size();
                for (int j = 0; j < injectedAreaSize; ++j) {
                    TextRange textRange = injectedArea.get(j);
                    ProperTextRange.assertProperRange((Segment)textRange, (Object)injection);
                    result.add((Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>)Trinity.create((Object)curHost, (Object)InjectedLanguage.create(injection.getInjectedLanguageId(), (String)(separateFiles || j == 0 ? var10_12 : ""), separateFiles || j == injectedAreaSize - 1 ? curSuffix : "", true), (Object)textRange));
                }
            }
            if (!result.isEmpty()) {
                if (separateFiles) {
                    for (Trinity trinity : result) {
                        this.processInjection(language, Collections.singletonList(trinity), settingsAvailable, false);
                    }
                } else {
                    this.processInjection(language, result, settingsAvailable, (Boolean)unparsableRef.get());
                }
            }
        }

        protected void processInjection(Language language, List<Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>> list, boolean xmlInjection, boolean unparsable) {
        }

        protected boolean areThereInjectionsWithName(String methodName, boolean annoOnly) {
            return true;
        }
    }
}

