/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.config.AbstractTagInjection;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.intellij.plugins.intelliLang.inject.config.XmlTagInjection;
import org.intellij.plugins.intelliLang.util.StringMatcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlAttributeInjection
extends AbstractTagInjection {
    @NotNull
    @NonNls
    private StringMatcher myAttributeNameMatcher = StringMatcher.NONE;
    @NotNull
    @NonNls
    private String myAttributeNamespace = "";

    @NotNull
    public String getAttributeName() {
        String string = this.myAttributeNameMatcher.getPattern();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/config/XmlAttributeInjection", "getAttributeName"));
        }
        return string;
    }

    public void setAttributeName(@NotNull String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/intelliLang/inject/config/XmlAttributeInjection", "setAttributeName"));
        }
        this.myAttributeNameMatcher = StringMatcher.create(attributeName);
    }

    @NotNull
    public String getAttributeNamespace() {
        String string = this.myAttributeNamespace;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/config/XmlAttributeInjection", "getAttributeNamespace"));
        }
        return string;
    }

    public void setAttributeNamespace(@NotNull String attributeNamespace) {
        if (attributeNamespace == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/intelliLang/inject/config/XmlAttributeInjection", "setAttributeNamespace"));
        }
        this.myAttributeNamespace = attributeNamespace;
    }

    public boolean isApplicable(@NotNull XmlAttributeValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/intelliLang/inject/config/XmlAttributeInjection", "isApplicable"));
        }
        PsiElement element = value.getParent();
        return element instanceof XmlAttribute && this.matches((XmlAttribute)element);
    }

    public String getGeneratedName() {
        String tag = this.getTagName();
        String attributeName = this.getAttributeName();
        if (!attributeName.equals(StringMatcher.NONE.getPattern())) {
            if (tag.length() > 0) {
                return tag + "/@" + (attributeName.length() > 0 ? attributeName : "*");
            }
            return "*/@" + (attributeName.length() > 0 ? attributeName : "*");
        }
        return attributeName;
    }

    @Override
    public void generatePlaces() {
        if (StringUtil.isEmpty((String)this.getDisplayName())) {
            this.setDisplayName(this.getGeneratedName());
        }
        this.setInjectionPlaces(new InjectionPlace((ElementPattern<PsiElement>)this.getCompiler().createElementPattern(XmlAttributeInjection.getPatternString(this), this.getDisplayName()), true));
    }

    private boolean matches(@NotNull XmlAttribute attr) {
        if (attr == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/intelliLang/inject/config/XmlAttributeInjection", "matches"));
        }
        boolean b = this.myAttributeNameMatcher.matches(attr.getLocalName()) && (attr.getName().indexOf(58) == -1 || this.myAttributeNamespace.equals(attr.getNamespace())) && this.matches(attr.getParent());
        return b && this.matchXPath((XmlElement)attr);
    }

    @Override
    public XmlAttributeInjection copy() {
        return new XmlAttributeInjection().copyFrom(this);
    }

    @Override
    public XmlAttributeInjection copyFrom(@NotNull BaseInjection o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/intelliLang/inject/config/XmlAttributeInjection", "copyFrom"));
        }
        super.copyFrom(o);
        if (o instanceof XmlAttributeInjection) {
            XmlAttributeInjection other = (XmlAttributeInjection)o;
            this.setApplyToSubTags(other.isApplyToSubTags());
            this.setAttributeName(other.getAttributeName());
            this.setAttributeNamespace(other.getAttributeNamespace());
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        XmlAttributeInjection that = (XmlAttributeInjection)o;
        if (!this.myAttributeNameMatcher.getPattern().equals(that.myAttributeNameMatcher.getPattern())) {
            return false;
        }
        return this.myAttributeNamespace.equals(that.myAttributeNamespace);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myAttributeNameMatcher.getPattern().hashCode();
        result = 31 * result + this.myAttributeNamespace.hashCode();
        return result;
    }

    public static String getPatternString(XmlAttributeInjection injection) {
        String name = injection.getAttributeName();
        String namespace = injection.getAttributeNamespace();
        StringBuilder result = new StringBuilder("xmlAttribute()");
        if (StringUtil.isNotEmpty((String)name)) {
            InjectorUtils.appendStringPattern(result, ".withLocalName(", name, ")");
        }
        if (StringUtil.isNotEmpty((String)namespace)) {
            InjectorUtils.appendStringPattern(result, ".withNamespace(", namespace, ")");
        }
        if (StringUtil.isNotEmpty((String)injection.getTagName()) || StringUtil.isNotEmpty((String)injection.getTagNamespace())) {
            result.append(".").append(injection.isApplyToSubTags() ? "inside" : "withParent").append("(").append(XmlTagInjection.getPatternString(injection)).append(")");
        }
        return result.toString();
    }
}

