/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config;

import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.NotNull;

public class InjectionPlace {
    public static final InjectionPlace[] EMPTY_ARRAY = new InjectionPlace[0];
    public static final ArrayFactory<InjectionPlace> ARRAY_FACTORY = new ArrayFactory<InjectionPlace>(){

        @NotNull
        public InjectionPlace[] create(int count) {
            InjectionPlace[] injectionPlaceArray = count == 0 ? EMPTY_ARRAY : new InjectionPlace[count];
            if (injectionPlaceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/config/InjectionPlace$1", "create"));
            }
            return injectionPlaceArray;
        }
    };
    private final ElementPattern<PsiElement> myElementPattern;
    private final boolean myEnabled;

    public InjectionPlace(ElementPattern<PsiElement> myElementPattern, boolean enabled) {
        this.myElementPattern = myElementPattern;
        this.myEnabled = enabled;
    }

    public InjectionPlace enabled(boolean enabled) {
        return new InjectionPlace(this.myElementPattern, enabled);
    }

    public String getText() {
        return this.myElementPattern.toString();
    }

    public ElementPattern<PsiElement> getElementPattern() {
        return this.myElementPattern;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InjectionPlace place = (InjectionPlace)o;
        return this.myElementPattern.equals(place.myElementPattern);
    }

    public int hashCode() {
        return this.myElementPattern.hashCode();
    }
}

