/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InjectedLanguage {
    private static Map<String, Language> ourLanguageCache;
    private static int ourLanguageCount;
    private final String myID;
    private final String myPrefix;
    private final String mySuffix;
    private final boolean myDynamic;

    private InjectedLanguage(@NotNull String id, @NotNull String prefix, @NotNull String suffix, boolean dynamic) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/intellij/plugins/intelliLang/inject/InjectedLanguage", "<init>"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/intellij/plugins/intelliLang/inject/InjectedLanguage", "<init>"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/intellij/plugins/intelliLang/inject/InjectedLanguage", "<init>"));
        }
        this.myID = id;
        this.myPrefix = prefix;
        this.mySuffix = suffix;
        this.myDynamic = dynamic;
    }

    @NotNull
    public String getID() {
        String string = this.myID;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/InjectedLanguage", "getID"));
        }
        return string;
    }

    @Nullable
    public Language getLanguage() {
        return InjectedLanguage.findLanguageById(this.myID);
    }

    @NotNull
    public String getPrefix() {
        String string = this.myPrefix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/InjectedLanguage", "getPrefix"));
        }
        return string;
    }

    @NotNull
    public String getSuffix() {
        String string = this.mySuffix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/InjectedLanguage", "getSuffix"));
        }
        return string;
    }

    public boolean isDynamic() {
        return this.myDynamic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Language findLanguageById(@Nullable String langID) {
        if (langID == null || langID.length() == 0) {
            return null;
        }
        Class<InjectedLanguage> clazz = InjectedLanguage.class;
        synchronized (InjectedLanguage.class) {
            if (ourLanguageCache == null || ourLanguageCount != Language.getRegisteredLanguages().size()) {
                InjectedLanguage.initLanguageCache();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ourLanguageCache.get(langID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String[] getAvailableLanguageIDs() {
        Class<InjectedLanguage> clazz = InjectedLanguage.class;
        synchronized (InjectedLanguage.class) {
            if (ourLanguageCache == null || ourLanguageCount != Language.getRegisteredLanguages().size()) {
                InjectedLanguage.initLanguageCache();
            }
            Set<String> keys = ourLanguageCache.keySet();
            String[] stringArray = ArrayUtil.toStringArray(keys);
            // ** MonitorExit[var0] (shouldn't be in output)
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/InjectedLanguage", "getAvailableLanguageIDs"));
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Language[] getAvailableLanguages() {
        Class<InjectedLanguage> clazz = InjectedLanguage.class;
        synchronized (InjectedLanguage.class) {
            if (ourLanguageCache == null || ourLanguageCount != Language.getRegisteredLanguages().size()) {
                InjectedLanguage.initLanguageCache();
            }
            Collection<Language> keys = ourLanguageCache.values();
            Language[] languageArray = keys.toArray(new Language[keys.size()]);
            // ** MonitorExit[var0] (shouldn't be in output)
            if (languageArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/InjectedLanguage", "getAvailableLanguages"));
            }
            return languageArray;
        }
    }

    private static void initLanguageCache() {
        ArrayList registeredLanguages;
        ourLanguageCache = new HashMap<String, Language>();
        do {
            registeredLanguages = new ArrayList(Language.getRegisteredLanguages());
            for (Language language : registeredLanguages) {
                if (!LanguageUtil.isInjectableLanguage((Language)language)) continue;
                ourLanguageCache.put(language.getID(), language);
            }
        } while (Language.getRegisteredLanguages().size() != registeredLanguages.size());
        ourLanguageCount = registeredLanguages.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InjectedLanguage that = (InjectedLanguage)o;
        return !(this.myID == null ? that.myID != null : !this.myID.equals(that.myID));
    }

    public int hashCode() {
        return this.myID != null ? this.myID.hashCode() : 0;
    }

    @Nullable
    public static InjectedLanguage create(String id) {
        return InjectedLanguage.create(id, "", "", false);
    }

    @Nullable
    public static InjectedLanguage create(@Nullable String id, String prefix, String suffix, boolean isDynamic) {
        return id == null ? null : new InjectedLanguage(id, prefix == null ? "" : prefix, suffix == null ? "" : suffix, isDynamic);
    }
}

