/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.util;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgContentRevision;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgLogCommand;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.provider.HgCommittedChangeList;
import org.zmlx.hg4idea.util.HgChangesetUtil;

public class HgHistoryUtil {
    private HgHistoryUtil() {
    }

    @NotNull
    public static List<? extends VcsCommitMetadata> loadMetadata(@NotNull Project project, final @NotNull VirtualFile root, int limit, List<String> parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/util/HgHistoryUtil", "loadMetadata"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/util/HgHistoryUtil", "loadMetadata"));
        }
        final VcsLogObjectsFactory factory = (VcsLogObjectsFactory)ServiceManager.getService((Project)project, VcsLogObjectsFactory.class);
        List<HgCommittedChangeList> result = HgHistoryUtil.getCommittedChangeList(project, root, limit, false, parameters);
        List list = ContainerUtil.mapNotNull(result, (Function)new Function<HgCommittedChangeList, VcsCommitMetadata>(){

            public VcsCommitMetadata fun(HgCommittedChangeList record) {
                HgRevisionNumber revNumber = (HgRevisionNumber)record.getRevisionNumber();
                return factory.createCommitMetadata(factory.createHash(revNumber.getChangeset()), HgHistoryUtil.getParentHashes(factory, revNumber), record.getCommitDate().getTime(), root, revNumber.getSubject(), revNumber.getAuthor(), revNumber.getEmail(), revNumber.getCommitMessage(), record.getCommitterName(), "", record.getCommitDate().getTime());
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgHistoryUtil", "loadMetadata"));
        }
        return list;
    }

    @NotNull
    public static List<? extends VcsFullCommitDetails> history(@NotNull Project project, final @NotNull VirtualFile root, int limit, List<String> parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/util/HgHistoryUtil", "history"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/util/HgHistoryUtil", "history"));
        }
        final VcsLogObjectsFactory factory = (VcsLogObjectsFactory)ServiceManager.getService((Project)project, VcsLogObjectsFactory.class);
        List<HgCommittedChangeList> result = HgHistoryUtil.getCommittedChangeList(project, root, limit, true, parameters);
        List list = ContainerUtil.mapNotNull(result, (Function)new Function<HgCommittedChangeList, VcsFullCommitDetails>(){

            public VcsFullCommitDetails fun(HgCommittedChangeList record) {
                return HgHistoryUtil.createCommit(root, record, factory);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgHistoryUtil", "history"));
        }
        return list;
    }

    @NotNull
    private static List<HgCommittedChangeList> getCommittedChangeList(@NotNull Project project, @NotNull VirtualFile root, int limit, boolean withFiles, List<String> parameters) {
        List<HgFileRevision> localRevisions;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/util/HgHistoryUtil", "getCommittedChangeList"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/util/HgHistoryUtil", "getCommittedChangeList"));
        }
        HgFile hgFile = new HgFile(root, VcsUtil.getFilePath((String)root.getPath()));
        LinkedList<HgCommittedChangeList> result = new LinkedList<HgCommittedChangeList>();
        HgLogCommand hgLogCommand = new HgLogCommand(project);
        ArrayList<String> args = new ArrayList<String>(parameters);
        hgLogCommand.setLogFile(false);
        HgVcs hgvcs = HgVcs.getInstance(project);
        assert (hgvcs != null);
        try {
            if (!hgvcs.getVersion().isParentRevisionTemplateSupported()) {
                args.add("--debug");
            }
            localRevisions = hgLogCommand.execute(hgFile, limit, withFiles, args);
        }
        catch (HgCommandException e) {
            new HgCommandResultNotifier(project).notifyError(null, HgVcsMessages.message("hg4idea.error.log.command.execution", new Object[0]), e.getMessage());
            List<HgCommittedChangeList> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgHistoryUtil", "getCommittedChangeList"));
            }
            return list;
        }
        Collections.reverse(localRevisions);
        for (HgFileRevision revision : localRevisions) {
            HgRevisionNumber vcsRevisionNumber = revision.getRevisionNumber();
            List<HgRevisionNumber> parents = vcsRevisionNumber.getParents();
            HgRevisionNumber firstParent = parents.isEmpty() ? null : parents.get(0);
            ArrayList<Change> changes = new ArrayList<Change>();
            for (String string : revision.getModifiedFiles()) {
                changes.add(HgHistoryUtil.createChange(project, root, string, firstParent, string, vcsRevisionNumber, FileStatus.MODIFIED));
            }
            for (String string : revision.getAddedFiles()) {
                changes.add(HgHistoryUtil.createChange(project, root, null, null, string, vcsRevisionNumber, FileStatus.ADDED));
            }
            for (String string : revision.getDeletedFiles()) {
                changes.add(HgHistoryUtil.createChange(project, root, string, firstParent, null, vcsRevisionNumber, FileStatus.DELETED));
            }
            for (Map.Entry entry : revision.getCopiedFiles().entrySet()) {
                changes.add(HgHistoryUtil.createChange(project, root, (String)entry.getKey(), firstParent, (String)entry.getValue(), vcsRevisionNumber, FileStatus.ADDED));
            }
            result.add(new HgCommittedChangeList(hgvcs, vcsRevisionNumber, revision.getBranchName(), revision.getCommitMessage(), revision.getAuthor(), revision.getRevisionDate(), changes));
        }
        Collections.reverse(result);
        LinkedList<HgCommittedChangeList> linkedList = result;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgHistoryUtil", "getCommittedChangeList"));
        }
        return linkedList;
    }

    @NotNull
    public static List<? extends VcsShortCommitDetails> readMiniDetails(Project project, final VirtualFile root, List<String> hashes) throws VcsException {
        final VcsLogObjectsFactory factory = (VcsLogObjectsFactory)ServiceManager.getService((Project)project, VcsLogObjectsFactory.class);
        List list = ContainerUtil.map(HgHistoryUtil.getCommittedChangeList(project, root, -1, false, HgHistoryUtil.prepareHashes(hashes)), (Function)new Function<HgCommittedChangeList, VcsShortCommitDetails>(){

            public VcsShortCommitDetails fun(HgCommittedChangeList record) {
                HgRevisionNumber revNumber = (HgRevisionNumber)record.getRevisionNumber();
                SmartList parents = new SmartList();
                for (HgRevisionNumber parent : revNumber.getParents()) {
                    parents.add(factory.createHash(parent.getChangeset()));
                }
                return factory.createShortDetails(factory.createHash(revNumber.getChangeset()), (List)parents, record.getCommitDate().getTime(), root, revNumber.getSubject(), revNumber.getAuthor(), revNumber.getEmail());
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgHistoryUtil", "readMiniDetails"));
        }
        return list;
    }

    @NotNull
    public static List<TimedVcsCommit> readAllHashes(@NotNull Project project, @NotNull VirtualFile root, final @NotNull Consumer<VcsUser> userRegistry, List<String> params) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/util/HgHistoryUtil", "readAllHashes"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/util/HgHistoryUtil", "readAllHashes"));
        }
        if (userRegistry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/zmlx/hg4idea/util/HgHistoryUtil", "readAllHashes"));
        }
        final VcsLogObjectsFactory factory = (VcsLogObjectsFactory)ServiceManager.getService((Project)project, VcsLogObjectsFactory.class);
        List list = ContainerUtil.map(HgHistoryUtil.getCommittedChangeList(project, root, -1, false, params), (Function)new Function<HgCommittedChangeList, TimedVcsCommit>(){

            public TimedVcsCommit fun(HgCommittedChangeList record) {
                HgRevisionNumber revNumber = (HgRevisionNumber)record.getRevisionNumber();
                SmartList parents = new SmartList();
                for (HgRevisionNumber parent : revNumber.getParents()) {
                    parents.add(factory.createHash(parent.getChangeset()));
                }
                userRegistry.consume((Object)factory.createUser(record.getRevision().getAuthor(), revNumber.getEmail()));
                return factory.createTimedCommit(factory.createHash(revNumber.getChangeset()), (List)parents, record.getCommitDate().getTime());
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgHistoryUtil", "readAllHashes"));
        }
        return list;
    }

    @NotNull
    public static Change createChange(Project project, VirtualFile root, @Nullable String fileBefore, @Nullable HgRevisionNumber revisionBefore, @Nullable String fileAfter, HgRevisionNumber revisionAfter, FileStatus aStatus) {
        HgContentRevision beforeRevision = fileBefore == null ? null : new HgContentRevision(project, new HgFile(root, new File(root.getPath(), fileBefore)), revisionBefore);
        HgContentRevision afterRevision = fileAfter == null ? null : new HgContentRevision(project, new HgFile(root, new File(root.getPath(), fileAfter)), revisionAfter);
        Change change = new Change((ContentRevision)beforeRevision, (ContentRevision)afterRevision, aStatus);
        if (change == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgHistoryUtil", "createChange"));
        }
        return change;
    }

    @NotNull
    private static VcsFullCommitDetails createCommit(@NotNull VirtualFile root, @NotNull HgCommittedChangeList record, @NotNull VcsLogObjectsFactory factory) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/util/HgHistoryUtil", "createCommit"));
        }
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/util/HgHistoryUtil", "createCommit"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/zmlx/hg4idea/util/HgHistoryUtil", "createCommit"));
        }
        HgRevisionNumber revNumber = (HgRevisionNumber)record.getRevisionNumber();
        final Collection changes = record.getChanges();
        VcsFullCommitDetails vcsFullCommitDetails = factory.createFullDetails(factory.createHash(revNumber.getChangeset()), HgHistoryUtil.getParentHashes(factory, revNumber), record.getCommitDate().getTime(), root, revNumber.getSubject(), revNumber.getAuthor(), revNumber.getEmail(), revNumber.getCommitMessage(), record.getCommitterName(), "", record.getCommitDate().getTime(), (ThrowableComputable)new ThrowableComputable<Collection<Change>, Exception>(){

            public Collection<Change> compute() throws Exception {
                return changes;
            }
        });
        if (vcsFullCommitDetails == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgHistoryUtil", "createCommit"));
        }
        return vcsFullCommitDetails;
    }

    @NotNull
    private static List<Hash> getParentHashes(final @NotNull VcsLogObjectsFactory factory, @NotNull HgRevisionNumber revNumber) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/util/HgHistoryUtil", "getParentHashes"));
        }
        if (revNumber == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/util/HgHistoryUtil", "getParentHashes"));
        }
        List list = ContainerUtil.map(revNumber.getParents(), (Function)new Function<HgRevisionNumber, Hash>(){

            public Hash fun(HgRevisionNumber parent) {
                return factory.createHash(parent.getChangeset());
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgHistoryUtil", "getParentHashes"));
        }
        return list;
    }

    @Nullable
    public static List<String> prepareHashes(@NotNull List<String> hashes) {
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/util/HgHistoryUtil", "prepareHashes"));
        }
        ArrayList<String> hashArgs = new ArrayList<String>();
        for (String hash : hashes) {
            hashArgs.add("-r");
            hashArgs.add(hash);
        }
        return hashArgs;
    }

    @NotNull
    public static Collection<String> getDescendingHeadsOfBranches(@NotNull Project project, @NotNull VirtualFile root, @NotNull Hash hash) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/util/HgHistoryUtil", "getDescendingHeadsOfBranches"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/util/HgHistoryUtil", "getDescendingHeadsOfBranches"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/zmlx/hg4idea/util/HgHistoryUtil", "getDescendingHeadsOfBranches"));
        }
        HashSet<String> branchHeads = new HashSet<String>();
        ArrayList<String> params = new ArrayList<String>();
        params.add("-r");
        params.add("descendants(" + hash.asString() + ") and head()");
        HgLogCommand hgLogCommand = new HgLogCommand(project);
        hgLogCommand.setLogFile(false);
        String template = HgChangesetUtil.makeTemplate("{branch}", "{bookmarks}");
        HgCommandResult logResult = hgLogCommand.execute(root, template, -1, null, params);
        if (logResult == null || logResult.getExitValue() != 0) {
            throw new VcsException("Couldn't get commit details: log command execution error.");
        }
        String output = logResult.getRawOutput();
        List changeSets = StringUtil.split((String)output, (String)"\u0003");
        for (String line : changeSets) {
            List attributes = StringUtil.split((String)line, (String)"\u0017");
            branchHeads.addAll(attributes);
        }
        HashSet<String> hashSet = branchHeads;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgHistoryUtil", "getDescendingHeadsOfBranches"));
        }
        return hashSet;
    }
}

