/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryFiles;

final class HgRepositoryUpdater
implements Disposable,
BulkFileListener {
    @NotNull
    private final HgRepositoryFiles myRepositoryFiles;
    @Nullable
    private final MessageBusConnection myMessageBusConnection;
    @NotNull
    private final QueueProcessor<Object> myUpdateQueue;
    @Nullable
    private final VirtualFile myBranchHeadsDir;
    @Nullable
    private final LocalFileSystem.WatchRequest myWatchRequest;
    @NotNull
    private final QueueProcessor<Object> myUpdateConfigQueue;

    HgRepositoryUpdater(final @NotNull HgRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/repo/HgRepositoryUpdater", "<init>"));
        }
        VirtualFile hgDir = repository.getHgDir();
        this.myWatchRequest = LocalFileSystem.getInstance().addRootToWatch(hgDir.getPath(), true);
        this.myRepositoryFiles = HgRepositoryFiles.getInstance(hgDir);
        RepositoryUtil.visitVcsDirVfs((VirtualFile)hgDir, HgRepositoryFiles.getSubDirRelativePaths());
        this.myBranchHeadsDir = VcsUtil.getVirtualFile((String)this.myRepositoryFiles.getBranchHeadsDirPath());
        Project project = repository.getProject();
        this.myUpdateQueue = new QueueProcessor((Consumer)new RepositoryUtil.Updater((Repository)repository), project.getDisposed());
        this.myUpdateConfigQueue = new QueueProcessor((Consumer)new Consumer<Object>(){

            public void consume(Object dummy) {
                repository.updateConfig();
            }
        }, project.getDisposed());
        if (!project.isDisposed()) {
            this.myMessageBusConnection = project.getMessageBus().connect();
            this.myMessageBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
        } else {
            this.myMessageBusConnection = null;
        }
    }

    public void dispose() {
        if (this.myWatchRequest != null) {
            LocalFileSystem.getInstance().removeWatchedRoot(this.myWatchRequest);
        }
        if (this.myMessageBusConnection != null) {
            this.myMessageBusConnection.disconnect();
        }
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/repo/HgRepositoryUpdater", "before"));
        }
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/repo/HgRepositoryUpdater", "after"));
        }
        boolean branchHeadsChanged = false;
        boolean branchFileChanged = false;
        boolean mergeFileChanged = false;
        boolean rebaseFileChanged = false;
        boolean bookmarksFileChanged = false;
        boolean tagsFileChanged = false;
        boolean localTagsFileChanged = false;
        boolean currentBookmarkFileChanged = false;
        boolean configHgrcChanged = false;
        for (VFileEvent vFileEvent : events) {
            String filePath = vFileEvent.getPath();
            if (filePath == null) continue;
            if (this.myRepositoryFiles.isbranchHeadsFile(filePath)) {
                branchHeadsChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isBranchFile(filePath)) {
                branchFileChanged = true;
                RepositoryUtil.visitAllChildrenRecursively((VirtualFile)this.myBranchHeadsDir);
                continue;
            }
            if (this.myRepositoryFiles.isMergeFile(filePath)) {
                mergeFileChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isRebaseFile(filePath)) {
                rebaseFileChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isBookmarksFile(filePath)) {
                bookmarksFileChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isTagsFile(filePath)) {
                tagsFileChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isLocalTagsFile(filePath)) {
                localTagsFileChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isCurrentBookmarksFile(filePath)) {
                currentBookmarkFileChanged = true;
                continue;
            }
            if (!this.myRepositoryFiles.isConfigHgrcFile(filePath)) continue;
            configHgrcChanged = true;
        }
        if (branchHeadsChanged || branchFileChanged || mergeFileChanged || rebaseFileChanged || bookmarksFileChanged || currentBookmarkFileChanged || tagsFileChanged || localTagsFileChanged) {
            this.myUpdateQueue.add(Void.TYPE);
        }
        if (configHgrcChanged) {
            this.myUpdateConfigQueue.add(Void.TYPE);
        }
    }
}

