/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.util.HgUtil;

public class HgDiffFromHistoryHandler
implements DiffFromHistoryHandler {
    private static final Logger LOG = Logger.getInstance(HgDiffFromHistoryHandler.class);
    @NotNull
    private final Project myProject;

    public HgDiffFromHistoryHandler(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "<init>"));
        }
        this.myProject = project;
    }

    public void showDiffForOne(@NotNull AnActionEvent e, @NotNull FilePath filePath, @NotNull VcsFileRevision previousRevision, @NotNull VcsFileRevision revision) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "showDiffForOne"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "showDiffForOne"));
        }
        if (previousRevision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "showDiffForOne"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "showDiffForOne"));
        }
        this.doShowDiff(filePath, previousRevision, revision, false);
    }

    public void showDiffForTwo(@NotNull FilePath filePath, @NotNull VcsFileRevision revision1, @NotNull VcsFileRevision revision2) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "showDiffForTwo"));
        }
        if (revision1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "showDiffForTwo"));
        }
        if (revision2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "showDiffForTwo"));
        }
        this.doShowDiff(filePath, revision1, revision2, true);
    }

    private void doShowDiff(@NotNull FilePath filePath, @NotNull VcsFileRevision revision1, @NotNull VcsFileRevision revision2, boolean autoSort) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "doShowDiff"));
        }
        if (revision1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "doShowDiff"));
        }
        if (revision2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "doShowDiff"));
        }
        if (!filePath.isDirectory()) {
            VcsHistoryUtil.showDifferencesInBackground((Project)this.myProject, (FilePath)filePath, (VcsFileRevision)revision1, (VcsFileRevision)revision2, (boolean)autoSort);
        } else if (revision2 instanceof CurrentRevision) {
            HgFileRevision left = (HgFileRevision)revision1;
            this.showDiffForDirectory(filePath, left, null);
        } else if (revision1.equals(VcsFileRevision.NULL)) {
            HgFileRevision right = (HgFileRevision)revision2;
            this.showDiffForDirectory(filePath, null, right);
        } else {
            HgFileRevision left = (HgFileRevision)revision1;
            HgFileRevision right = (HgFileRevision)revision2;
            if (autoSort) {
                Pair pair = VcsHistoryUtil.sortRevisions((VcsFileRevision)revision1, (VcsFileRevision)revision2);
                left = (HgFileRevision)pair.first;
                right = (HgFileRevision)pair.second;
            }
            this.showDiffForDirectory(filePath, left, right);
        }
    }

    private void showDiffForDirectory(final @NotNull FilePath path, final @Nullable HgFileRevision rev1, final @Nullable HgFileRevision rev2) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "showDiffForDirectory"));
        }
        VirtualFile root = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)path);
        LOG.assertTrue(root != null, (Object)("Repository is null for " + path));
        this.calculateDiffInBackground(root, path, rev1, rev2, new Consumer<List<Change>>(){

            public void consume(List<Change> changes) {
                HgDiffFromHistoryHandler.this.showDirDiffDialog(path, rev1 != null ? rev1.getRevisionNumber().getChangeset() : null, rev2 != null ? rev2.getRevisionNumber().getChangeset() : null, changes);
            }
        });
    }

    private void calculateDiffInBackground(final @NotNull VirtualFile root, final @NotNull FilePath path, final @Nullable HgFileRevision rev1, final @Nullable HgFileRevision rev2, final Consumer<List<Change>> successHandler) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "calculateDiffInBackground"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "calculateDiffInBackground"));
        }
        new Task.Backgroundable(this.myProject, "Comparing revisions..."){
            private List<Change> myChanges;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler$2", "run"));
                }
                if (this.myProject != null) {
                    this.myChanges = HgUtil.getDiff(HgDiffFromHistoryHandler.this.myProject, root, path, rev1, rev2);
                }
            }

            public void onSuccess() {
                successHandler.consume(this.myChanges);
            }
        }.queue();
    }

    private void showDirDiffDialog(@NotNull FilePath path, @Nullable String hash1, @Nullable String hash2, @NotNull List<Change> diff) {
        String title;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "showDirDiffDialog"));
        }
        if (diff == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/zmlx/hg4idea/provider/HgDiffFromHistoryHandler", "showDirDiffDialog"));
        }
        DialogBuilder dialogBuilder = new DialogBuilder(this.myProject);
        if (hash2 != null) {
            title = hash1 != null ? String.format("Difference between %s and %s in %s", hash1, hash2, path.getName()) : String.format("Initial commit %s in %s", hash2, path.getName());
        } else {
            LOG.assertTrue(hash1 != null, (Object)("hash1 and hash2 can't both be null. Path: " + path));
            title = String.format("Difference between %s and local version in %s", hash1, path.getName());
        }
        dialogBuilder.setTitle(title);
        dialogBuilder.setActionDescriptors(new DialogBuilder.ActionDescriptor[]{new DialogBuilder.CloseDialogAction()});
        ChangesBrowser changesBrowser = new ChangesBrowser(this.myProject, null, diff, null, false, true, null, ChangesBrowser.MyUseCase.COMMITTED_CHANGES, null);
        changesBrowser.setChangesToDisplay(diff);
        dialogBuilder.setCenterPanel((JComponent)changesBrowser);
        dialogBuilder.showNotModal();
    }
}

