/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.PasswordSafeException;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImpl;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.MasterKeyPasswordSafe;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.vcsUtil.AuthDialog;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgGlobalSettings;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;

class HgCommandAuthenticator {
    private static final Logger LOG = Logger.getInstance((String)HgCommandAuthenticator.class.getName());
    private GetPasswordRunnable myRunnable;
    private final Project myProject;
    private boolean myForceAuthorization;

    public HgCommandAuthenticator(Project project, boolean forceAuthorization) {
        this.myProject = project;
        this.myForceAuthorization = forceAuthorization;
    }

    public void saveCredentials() {
        if (this.myRunnable == null) {
            return;
        }
        PasswordSafeImpl passwordSafe = (PasswordSafeImpl)PasswordSafe.getInstance();
        String url = VirtualFileManager.extractPath((String)this.myRunnable.getURL());
        String key = HgCommandAuthenticator.keyForUrlAndLogin(url, this.myRunnable.getUserName());
        MasterKeyPasswordSafe provider = this.myRunnable.isRememberPassword() ? passwordSafe.getMasterKeyProvider() : passwordSafe.getMemoryProvider();
        try {
            provider.storePassword(this.myProject, HgCommandAuthenticator.class, key, this.myRunnable.getPassword());
            HgVcs vcs = HgVcs.getInstance(this.myProject);
            if (vcs != null) {
                vcs.getGlobalSettings().addRememberedUrl(url, this.myRunnable.getUserName());
            }
        }
        catch (PasswordSafeException e) {
            LOG.info("Couldn't store the password for key [" + key + "]", (Throwable)e);
        }
    }

    public boolean promptForAuthentication(Project project, String proposedLogin, String uri, String path, @Nullable ModalityState state) {
        GetPasswordRunnable runnable = new GetPasswordRunnable(project, proposedLogin, uri, path, this.myForceAuthorization);
        ApplicationManager.getApplication().invokeAndWait((Runnable)runnable, state == null ? ModalityState.defaultModalityState() : state);
        this.myRunnable = runnable;
        return runnable.isOk();
    }

    public String getUserName() {
        return this.myRunnable.getUserName();
    }

    public String getPassword() {
        return this.myRunnable.getPassword();
    }

    private static String keyForUrlAndLogin(String stringUrl, String login) {
        return login + ":" + stringUrl;
    }

    private static class GetPasswordRunnable
    implements Runnable {
        private static final Logger LOG = Logger.getInstance((String)GetPasswordRunnable.class.getName());
        private String myUserName;
        private String myPassword;
        private Project myProject;
        private final String myProposedLogin;
        private boolean ok = false;
        @Nullable
        private String myURL;
        private boolean myRememberPassword;
        private boolean myForceAuthorization;

        public GetPasswordRunnable(Project project, String proposedLogin, String uri, String path, boolean forceAuthorization) {
            this.myProject = project;
            this.myProposedLogin = proposedLogin;
            this.myURL = uri + path;
            this.myForceAuthorization = forceAuthorization;
        }

        @Override
        public void run() {
            String login;
            HgVcs vcs = HgVcs.getInstance(this.myProject);
            if (vcs == null) {
                return;
            }
            HgGlobalSettings hgGlobalSettings = vcs.getGlobalSettings();
            String rememberedLoginsForUrl = null;
            if (!StringUtil.isEmptyOrSpaces((String)this.myURL)) {
                rememberedLoginsForUrl = hgGlobalSettings.getRememberedUserName(VirtualFileManager.extractPath((String)this.myURL));
            }
            if (StringUtil.isEmptyOrSpaces((String)(login = this.myProposedLogin))) {
                login = rememberedLoginsForUrl;
            }
            String password = null;
            if (!StringUtil.isEmptyOrSpaces((String)login) && this.myURL != null) {
                String key = HgCommandAuthenticator.keyForUrlAndLogin(this.myURL, login);
                try {
                    MasterKeyPasswordSafe masterKeyProvider;
                    PasswordSafeImpl passwordSafe = (PasswordSafeImpl)PasswordSafe.getInstance();
                    password = passwordSafe.getMemoryProvider().getPassword(this.myProject, HgCommandAuthenticator.class, key);
                    if (password == null && !(masterKeyProvider = passwordSafe.getMasterKeyProvider()).isEmpty()) {
                        password = masterKeyProvider.getPassword(this.myProject, HgCommandAuthenticator.class, key);
                    }
                }
                catch (PasswordSafeException e) {
                    LOG.info("Couldn't get password for key [" + key + "]", (Throwable)e);
                }
            }
            if (!(this.myForceAuthorization || StringUtil.isEmptyOrSpaces(password) || StringUtil.isEmptyOrSpaces((String)login))) {
                this.myUserName = login;
                this.myPassword = password;
                this.ok = true;
                return;
            }
            AuthDialog dialog = new AuthDialog(this.myProject, HgVcsMessages.message("hg4idea.dialog.login.password.required", new Object[0]), HgVcsMessages.message("hg4idea.dialog.login.description", this.myURL), login, password, true);
            dialog.show();
            if (dialog.isOK()) {
                this.myUserName = dialog.getUsername();
                this.myPassword = dialog.getPassword();
                this.myRememberPassword = dialog.isRememberPassword();
                this.ok = true;
            }
        }

        public String getUserName() {
            return this.myUserName;
        }

        public String getPassword() {
            return this.myPassword;
        }

        public boolean isOk() {
            return this.ok;
        }

        @Nullable
        public String getURL() {
            return this.myURL;
        }

        public boolean isRememberPassword() {
            return this.myRememberPassword;
        }
    }
}

