/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.util.HgChangesetUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgWorkingCopyRevisionsCommand {
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance(HgWorkingCopyRevisionsCommand.class);

    public HgWorkingCopyRevisionsCommand(Project project) {
        this.myProject = project;
    }

    @NotNull
    public List<HgRevisionNumber> parents(@NotNull VirtualFile repo) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "parents"));
        }
        List<HgRevisionNumber> list = this.getRevisions(repo, "parents", null, null, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "parents"));
        }
        return list;
    }

    @NotNull
    public Pair<HgRevisionNumber, HgRevisionNumber> parents(@NotNull VirtualFile repo, @Nullable VirtualFile file) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "parents"));
        }
        Pair<HgRevisionNumber, HgRevisionNumber> pair = this.parents(repo, file, null);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "parents"));
        }
        return pair;
    }

    @NotNull
    public Pair<HgRevisionNumber, HgRevisionNumber> parents(@NotNull VirtualFile repo, @Nullable VirtualFile file, @Nullable HgRevisionNumber revision) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "parents"));
        }
        Pair<HgRevisionNumber, HgRevisionNumber> pair = this.parents(repo, (FilePath)ObjectsConvertor.VIRTUAL_FILEPATH.convert((Object)file), revision);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "parents"));
        }
        return pair;
    }

    @NotNull
    public Pair<HgRevisionNumber, HgRevisionNumber> parents(@NotNull VirtualFile repo, @Nullable FilePath file) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "parents"));
        }
        Pair<HgRevisionNumber, HgRevisionNumber> pair = this.parents(repo, file, null);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "parents"));
        }
        return pair;
    }

    @NotNull
    public Pair<HgRevisionNumber, HgRevisionNumber> parents(@NotNull VirtualFile repo, @Nullable FilePath file, @Nullable HgRevisionNumber revision) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "parents"));
        }
        List<HgRevisionNumber> revisions = this.getRevisions(repo, "parents", file, revision, true);
        switch (revisions.size()) {
            case 1: {
                Pair pair = Pair.create((Object)revisions.get(0), null);
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "parents"));
                }
                return pair;
            }
            case 2: {
                Pair pair = Pair.create((Object)revisions.get(0), (Object)revisions.get(1));
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "parents"));
                }
                return pair;
            }
        }
        Pair pair = Pair.create(null, null);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "parents"));
        }
        return pair;
    }

    @Nullable
    public HgRevisionNumber firstParent(@NotNull VirtualFile repo) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "firstParent"));
        }
        List<HgRevisionNumber> parents = this.parents(repo);
        if (parents.isEmpty()) {
            return HgRevisionNumber.NULL_REVISION_NUMBER;
        }
        return parents.get(0);
    }

    @Nullable
    public HgRevisionNumber tip(@NotNull VirtualFile repo) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "tip"));
        }
        List<HgRevisionNumber> tips = this.getRevisions(repo, "tip", null, null, true);
        if (tips.size() > 1) {
            throw new IllegalStateException("There cannot be multiple tips");
        }
        if (!tips.isEmpty()) {
            return tips.get(0);
        }
        return HgRevisionNumber.NULL_REVISION_NUMBER;
    }

    @NotNull
    public Pair<HgRevisionNumber, HgRevisionNumber> identify(@NotNull VirtualFile repo) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "identify"));
        }
        HgCommandExecutor commandExecutor = new HgCommandExecutor(this.myProject);
        commandExecutor.setSilent(true);
        HgCommandResult result = commandExecutor.executeInCurrentThread(repo, "identify", Arrays.asList("--num", "--id"));
        if (result == null) {
            Pair pair = Pair.create((Object)HgRevisionNumber.NULL_REVISION_NUMBER, null);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "identify"));
            }
            return pair;
        }
        List<String> lines = result.getOutputLines();
        if (lines != null && !lines.isEmpty()) {
            List parts = StringUtil.split((String)lines.get(0), (String)" ");
            String changesets = (String)parts.get(0);
            String revisions = (String)parts.get(1);
            if (parts.size() >= 2) {
                if (changesets.indexOf(43) != changesets.lastIndexOf(43)) {
                    List chsets = StringUtil.split((String)changesets, (String)"+");
                    List revs = StringUtil.split((String)revisions, (String)"+");
                    Pair pair = Pair.create((Object)HgRevisionNumber.getInstance((String)revs.get(0) + "+", (String)chsets.get(0) + "+"), (Object)HgRevisionNumber.getInstance((String)revs.get(1) + "+", (String)chsets.get(1) + "+"));
                    if (pair == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "identify"));
                    }
                    return pair;
                }
                Pair pair = Pair.create((Object)HgRevisionNumber.getInstance(revisions, changesets), null);
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "identify"));
                }
                return pair;
            }
        }
        Pair pair = Pair.create((Object)HgRevisionNumber.NULL_REVISION_NUMBER, null);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "identify"));
        }
        return pair;
    }

    @NotNull
    public List<HgRevisionNumber> getRevisions(@NotNull VirtualFile repo, @NotNull String command, @Nullable FilePath file, @Nullable HgRevisionNumber revision, boolean silent) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "getRevisions"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "getRevisions"));
        }
        LinkedList<String> args = new LinkedList<String>();
        args.add("--template");
        args.add(HgChangesetUtil.makeTemplate("{rev}", "{node}"));
        if (revision != null) {
            args.add("-r");
            args.add(revision.getChangeset());
        }
        if (file != null) {
            args.add(HgUtil.getOriginalFileName(file, ChangeListManager.getInstance((Project)this.myProject)).getPath());
        }
        HgCommandExecutor executor = new HgCommandExecutor(this.myProject);
        executor.setSilent(silent);
        HgCommandResult result = executor.executeInCurrentThread(repo, command, args);
        if (result == null) {
            ArrayList<HgRevisionNumber> arrayList = new ArrayList<HgRevisionNumber>(0);
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "getRevisions"));
            }
            return arrayList;
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : result.getRawOutput().split("\u0003")) {
            if (line.trim().isEmpty()) continue;
            lines.add(line);
        }
        if (lines.isEmpty()) {
            ArrayList<HgRevisionNumber> arrayList = new ArrayList<HgRevisionNumber>();
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "getRevisions"));
            }
            return arrayList;
        }
        ArrayList<HgRevisionNumber> revisions = new ArrayList<HgRevisionNumber>(lines.size());
        for (String line : lines) {
            List parts = StringUtil.split((String)line, (String)"\u0017");
            if (parts.size() < 2) {
                LOG.error("getRevisions output parse error in line [" + line + "]\n All lines: \n" + lines);
                continue;
            }
            revisions.add(HgRevisionNumber.getInstance((String)parts.get(0), (String)parts.get(1)));
        }
        ArrayList<HgRevisionNumber> arrayList = revisions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgWorkingCopyRevisionsCommand", "getRevisions"));
        }
        return arrayList;
    }
}

