/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;

public class HgRebaseCommand {
    @NotNull
    private final Project project;
    @NotNull
    private final HgRepository repo;

    public HgRebaseCommand(@NotNull Project project, @NotNull HgRepository repo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/command/HgRebaseCommand", "<init>"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/command/HgRebaseCommand", "<init>"));
        }
        this.project = project;
        this.repo = repo;
    }

    @Nullable
    public HgCommandResult startRebase() {
        HgCommandResult result = new HgCommandExecutor(this.project).executeInCurrentThread(this.repo.getRoot(), "rebase", Collections.<String>emptyList(), null);
        this.repo.update();
        ((HgUpdater)this.project.getMessageBus().syncPublisher(HgVcs.BRANCH_TOPIC)).update(this.project, null);
        return result;
    }

    @Nullable
    public HgCommandResult continueRebase() {
        HgCommandResult result = new HgCommandExecutor(this.project).executeInCurrentThread(this.repo.getRoot(), "rebase", Arrays.asList("--continue"), null);
        this.repo.update();
        ((HgUpdater)this.project.getMessageBus().syncPublisher(HgVcs.BRANCH_TOPIC)).update(this.project, null);
        return result;
    }

    @Nullable
    public HgCommandResult abortRebase() {
        HgCommandResult result = new HgCommandExecutor(this.project).executeInCurrentThread(this.repo.getRoot(), "rebase", Arrays.asList("--abort"), null);
        this.repo.update();
        ((HgUpdater)this.project.getMessageBus().syncPublisher(HgVcs.BRANCH_TOPIC)).update(this.project, null);
        return result;
    }
}

