/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgCommandResultHandler;

public class HgPushCommand {
    private final Project myProject;
    private final VirtualFile myRepo;
    private final String myDestination;
    private String myRevision;
    private boolean myForce;
    private String myBranchName;
    private String myBookmarkName;
    private boolean myIsNewBranch;

    public HgPushCommand(Project project, @NotNull VirtualFile repo, String destination) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/command/HgPushCommand", "<init>"));
        }
        this.myProject = project;
        this.myRepo = repo;
        this.myDestination = destination;
    }

    public void setRevision(String revision) {
        this.myRevision = revision;
    }

    public void setForce(boolean force) {
        this.myForce = force;
    }

    public void setBranchName(String branchName) {
        this.myBranchName = branchName;
    }

    public void setIsNewBranch(boolean isNewBranch) {
        this.myIsNewBranch = isNewBranch;
    }

    public void setBookmarkName(String bookmark) {
        this.myBookmarkName = bookmark;
    }

    public void execute(final HgCommandResultHandler resultHandler) {
        LinkedList<String> arguments = new LinkedList<String>();
        if (!StringUtil.isEmptyOrSpaces((String)this.myRevision)) {
            arguments.add("-r");
            arguments.add(this.myRevision);
        }
        if (this.myBranchName != null) {
            if (this.myIsNewBranch) {
                arguments.add("--new-branch");
            } else {
                arguments.add("-b");
                arguments.add(this.myBranchName);
            }
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myBookmarkName)) {
            arguments.add("-B");
            arguments.add(this.myBookmarkName);
        }
        if (this.myForce) {
            arguments.add("-f");
        }
        arguments.add(this.myDestination);
        HgCommandExecutor executor = new HgCommandExecutor(this.myProject, this.myDestination);
        executor.setShowOutput(true);
        executor.execute(this.myRepo, "push", arguments, new HgCommandResultHandler(){

            @Override
            public void process(@Nullable HgCommandResult result) {
                if (!HgPushCommand.this.myProject.isDisposed()) {
                    ((HgUpdater)HgPushCommand.this.myProject.getMessageBus().syncPublisher(HgVcs.REMOTE_TOPIC)).update(HgPushCommand.this.myProject, null);
                }
                resultHandler.process(result);
            }
        });
    }

    public VirtualFile getRepo() {
        return this.myRepo;
    }
}

