/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgDeleteModifyPromptHandler;

public class HgMergeCommand {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile repo;
    private String revision;

    public HgMergeCommand(@NotNull Project project, @NotNull VirtualFile repo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/command/HgMergeCommand", "<init>"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/command/HgMergeCommand", "<init>"));
        }
        this.project = project;
        this.repo = repo;
    }

    public void setRevision(@NotNull String revision) {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/command/HgMergeCommand", "setRevision"));
        }
        this.revision = revision;
    }

    @Nullable
    public HgCommandResult execute() {
        HgCommandExecutor commandExecutor = new HgCommandExecutor(this.project);
        commandExecutor.setShowOutput(true);
        LinkedList<String> arguments = new LinkedList<String>();
        if (!StringUtil.isEmptyOrSpaces((String)this.revision)) {
            arguments.add("--rev");
            arguments.add(this.revision);
        }
        HgCommandResult result = commandExecutor.executeInCurrentThread(this.repo, "merge", arguments, new HgDeleteModifyPromptHandler());
        ((HgUpdater)this.project.getMessageBus().syncPublisher(HgVcs.BRANCH_TOPIC)).update(this.project, null);
        return result;
    }
}

