/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;

public class HgBranchesCommand {
    private static final Pattern BRANCH_LINE = Pattern.compile("(.+)\\s([0-9]+):([0-9a-f]+).*");
    private static final int NAME_INDEX = 1;
    private final Project project;
    private final VirtualFile repo;

    public HgBranchesCommand(Project project, @NotNull VirtualFile repo) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/command/HgBranchesCommand", "<init>"));
        }
        this.project = project;
        this.repo = repo;
    }

    @Nullable
    public HgCommandResult collectBranches() {
        return new HgCommandExecutor(this.project).executeInCurrentThread(this.repo, "branches", null);
    }

    @NotNull
    public static Set<String> collectNames(@NotNull HgCommandResult result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/command/HgBranchesCommand", "collectNames"));
        }
        HashSet branches = new HashSet();
        for (String line : result.getOutputLines()) {
            Matcher matcher = BRANCH_LINE.matcher(line);
            if (!matcher.matches()) continue;
            branches.add(matcher.group(1).trim());
        }
        HashSet hashSet = branches;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/command/HgBranchesCommand", "collectNames"));
        }
        return hashSet;
    }
}

