/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.HgAbstractGlobalAction;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgUpdateCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.provider.update.HgConflictResolver;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.ui.HgUpdateToDialog;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgUpdateToAction
extends HgAbstractGlobalAction {
    @Override
    protected void execute(@NotNull Project project, @NotNull Collection<HgRepository> repositories, @Nullable HgRepository selectedRepo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/action/HgUpdateToAction", "execute"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/action/HgUpdateToAction", "execute"));
        }
        HgUpdateToDialog dialog = new HgUpdateToDialog(project, repositories, selectedRepo);
        dialog.show();
        if (dialog.isOK()) {
            FileDocumentManager.getInstance().saveAllDocuments();
            String updateToValue = dialog.getTargetValue();
            boolean clean = dialog.isRemoveLocalChanges();
            String title = HgVcsMessages.message("hg4idea.progress.updatingTo", updateToValue);
            HgUpdateToAction.runUpdateToInBackground(project, title, dialog.getRepository().getRoot(), updateToValue, clean);
        }
    }

    public static void runUpdateToInBackground(final @NotNull Project project, @NotNull String title, final @NotNull VirtualFile root, final @NotNull String updateToValue, final boolean clean) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/action/HgUpdateToAction", "runUpdateToInBackground"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/action/HgUpdateToAction", "runUpdateToInBackground"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/zmlx/hg4idea/action/HgUpdateToAction", "runUpdateToInBackground"));
        }
        if (updateToValue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/zmlx/hg4idea/action/HgUpdateToAction", "runUpdateToInBackground"));
        }
        new Task.Backgroundable(project, title){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/action/HgUpdateToAction$1", "run"));
                }
                HgUpdateCommand command = new HgUpdateCommand(project, root);
                command.setRevision(updateToValue);
                command.setClean(clean);
                HgCommandResult result = command.execute();
                new HgConflictResolver(project).resolve(root);
                if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
                    new HgCommandResultNotifier(project).notifyError(result, "", "Update failed");
                }
                HgAbstractGlobalAction.markDirtyAndHandleErrors(project, root);
            }
        }.queue();
    }
}

