/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.action.HgAbstractGlobalAction;
import org.zmlx.hg4idea.command.HgPullCommand;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.ui.HgPullDialog;

public class HgPullAction
extends HgAbstractGlobalAction {
    public HgPullAction() {
        super(AllIcons.Actions.CheckOut);
    }

    @Override
    protected void execute(final @NotNull Project project, @NotNull Collection<HgRepository> repos, @Nullable HgRepository selectedRepo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/action/HgPullAction", "execute"));
        }
        if (repos == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/action/HgPullAction", "execute"));
        }
        final HgPullDialog dialog = new HgPullDialog(project, repos, selectedRepo);
        dialog.show();
        if (dialog.isOK()) {
            dialog.rememberSettings();
            new Task.Backgroundable(project, "Pulling changes from " + dialog.getSource(), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/action/HgPullAction$1", "run"));
                    }
                    HgPullAction.executePull(dialog, project);
                    HgAbstractGlobalAction.markDirtyAndHandleErrors(project, dialog.getRepository());
                }
            }.queue();
        }
    }

    private static void executePull(HgPullDialog dialog, Project project) {
        HgPullCommand command = new HgPullCommand(project, dialog.getRepository());
        command.setSource(dialog.getSource());
        command.execute();
    }
}

