/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.action.HgAbstractGlobalAction;
import org.zmlx.hg4idea.command.HgMergeCommand;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.provider.update.HgConflictResolver;
import org.zmlx.hg4idea.provider.update.HgHeadMerger;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.ui.HgMergeDialog;

public class HgMerge
extends HgAbstractGlobalAction {
    @Override
    public void execute(final @NotNull Project project, @NotNull Collection<HgRepository> repos, @Nullable HgRepository selectedRepo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/action/HgMerge", "execute"));
        }
        if (repos == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/action/HgMerge", "execute"));
        }
        HgMergeDialog mergeDialog = new HgMergeDialog(project, repos, selectedRepo);
        mergeDialog.show();
        if (mergeDialog.isOK()) {
            final String targetValue = mergeDialog.getTargetValue();
            final VirtualFile repoRoot = mergeDialog.getRepository().getRoot();
            new Task.Backgroundable(project, "Merging changes..."){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/action/HgMerge$1", "run"));
                    }
                    try {
                        HgMerge.executeMerge(project, repoRoot, targetValue);
                        HgAbstractGlobalAction.markDirtyAndHandleErrors(project, repoRoot);
                    }
                    catch (HgCommandException e) {
                        HgAbstractGlobalAction.handleException(project, e);
                    }
                }
            }.queue();
        }
    }

    private static void executeMerge(@NotNull Project project, @NotNull VirtualFile repo, @NotNull String targetValue) throws HgCommandException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/action/HgMerge", "executeMerge"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/action/HgMerge", "executeMerge"));
        }
        if (targetValue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/zmlx/hg4idea/action/HgMerge", "executeMerge"));
        }
        UpdatedFiles updatedFiles = UpdatedFiles.create();
        HgMergeCommand hgMergeCommand = new HgMergeCommand(project, repo);
        hgMergeCommand.setRevision(targetValue);
        try {
            new HgHeadMerger(project, hgMergeCommand).merge(repo);
            new HgConflictResolver(project, updatedFiles).resolve(repo);
        }
        catch (VcsException e) {
            if (e.isWarning()) {
                VcsNotifier.getInstance((Project)project).notifyWarning("Warning during merge", e.getMessage());
            }
            VcsNotifier.getInstance((Project)project).notifyError("Exception during merge", e.getMessage());
        }
    }
}

