/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.HgAbstractGlobalAction;
import org.zmlx.hg4idea.action.HgBranchAbstractAction;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgMergeCommand;
import org.zmlx.hg4idea.command.HgUpdateCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.provider.update.HgConflictResolver;
import org.zmlx.hg4idea.provider.update.HgHeadMerger;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgCommonBranchActions
extends ActionGroup {
    @NotNull
    protected final Project myProject;
    @NotNull
    protected String myBranchName;
    @NotNull
    protected final HgRepository mySelectedRepository;

    HgCommonBranchActions(@NotNull Project project, @NotNull HgRepository selectedRepository, @NotNull String branchName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/action/HgCommonBranchActions", "<init>"));
        }
        if (selectedRepository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/action/HgCommonBranchActions", "<init>"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/zmlx/hg4idea/action/HgCommonBranchActions", "<init>"));
        }
        super("", true);
        this.myProject = project;
        this.myBranchName = branchName;
        this.mySelectedRepository = selectedRepository;
        this.getTemplatePresentation().setText(this.myBranchName, false);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = new AnAction[]{new UpdateAction(this.myProject, this.mySelectedRepository, this.myBranchName), new MergeAction(this.myProject, this.mySelectedRepository, this.myBranchName)};
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/action/HgCommonBranchActions", "getChildren"));
        }
        return anActionArray;
    }

    private static class UpdateAction
    extends HgBranchAbstractAction {
        public UpdateAction(@NotNull Project project, @NotNull HgRepository selectedRepository, @NotNull String branchName) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/action/HgCommonBranchActions$UpdateAction", "<init>"));
            }
            if (selectedRepository == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/action/HgCommonBranchActions$UpdateAction", "<init>"));
            }
            if (branchName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/zmlx/hg4idea/action/HgCommonBranchActions$UpdateAction", "<init>"));
            }
            super(project, "Update", selectedRepository, branchName);
        }

        public void actionPerformed(AnActionEvent e) {
            final VirtualFile repository = this.mySelectedRepository.getRoot();
            final HgUpdateCommand hgUpdateCommand = new HgUpdateCommand(this.myProject, repository);
            hgUpdateCommand.setBranch(this.myBranchName);
            new Task.Backgroundable(this.myProject, HgVcsMessages.message("action.hg4idea.updateTo.description", this.myBranchName)){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/action/HgCommonBranchActions$UpdateAction$1", "run"));
                    }
                    HgCommandResult result = hgUpdateCommand.execute();
                    assert (this.myProject != null);
                    if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
                        new HgCommandResultNotifier(this.myProject).notifyError(result, "", "Update failed");
                        new HgConflictResolver(this.myProject).resolve(repository);
                    }
                    ((HgUpdater)this.myProject.getMessageBus().syncPublisher(HgVcs.BRANCH_TOPIC)).update(this.myProject, null);
                }
            }.queue();
        }
    }

    private static class MergeAction
    extends HgBranchAbstractAction {
        public MergeAction(@NotNull Project project, @NotNull HgRepository selectedRepository, @NotNull String branchName) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/action/HgCommonBranchActions$MergeAction", "<init>"));
            }
            if (selectedRepository == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/action/HgCommonBranchActions$MergeAction", "<init>"));
            }
            if (branchName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/zmlx/hg4idea/action/HgCommonBranchActions$MergeAction", "<init>"));
            }
            super(project, "Merge", selectedRepository, branchName);
        }

        public void actionPerformed(AnActionEvent e) {
            final UpdatedFiles updatedFiles = UpdatedFiles.create();
            final HgMergeCommand hgMergeCommand = new HgMergeCommand(this.myProject, this.mySelectedRepository.getRoot());
            hgMergeCommand.setRevision(this.myBranchName);
            new Task.Backgroundable(this.myProject, "Merging changes..."){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/action/HgCommonBranchActions$MergeAction$1", "run"));
                    }
                    try {
                        new HgHeadMerger(this.myProject, hgMergeCommand).merge(MergeAction.this.mySelectedRepository.getRoot());
                        new HgConflictResolver(this.myProject, updatedFiles).resolve(MergeAction.this.mySelectedRepository.getRoot());
                    }
                    catch (VcsException exception) {
                        assert (this.myProject != null);
                        if (exception.isWarning()) {
                            VcsNotifier.getInstance((Project)this.myProject).notifyWarning("Warning during merge", exception.getMessage());
                        } else {
                            VcsNotifier.getInstance((Project)this.myProject).notifyError("Exception during merge", exception.getMessage());
                        }
                    }
                    catch (Exception e1) {
                        HgAbstractGlobalAction.handleException(this.myProject, e1);
                    }
                }
            }.queue();
        }
    }
}

