/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgPushCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgCommandResultHandler;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.ui.HgPushDialog;

public class HgPusher {
    private static final Logger LOG = Logger.getInstance(HgPusher.class);
    private static Pattern PUSH_COMMITS_PATTERN = Pattern.compile(".*added (\\d+) changesets.*");
    private static int PUSH_SUCCEEDED_EXIT_VALUE = 0;
    private static int NOTHING_TO_PUSH_EXIT_VALUE = 1;
    private final Project myProject;

    public HgPusher(Project project) {
        this.myProject = project;
    }

    public void showDialogAndPush(@NotNull Collection<HgRepository> repositories, @Nullable HgRepository selectedRepo) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/HgPusher", "showDialogAndPush"));
        }
        if (repositories.isEmpty()) {
            VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)"No Mercurial repositories in the project", (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
            return;
        }
        final AtomicReference<HgPushCommand> pushCommand = new AtomicReference<HgPushCommand>();
        HgPushDialog dialog = new HgPushDialog(this.myProject, repositories, selectedRepo);
        dialog.show();
        if (dialog.isOK()) {
            dialog.rememberSettings();
            pushCommand.set(HgPusher.preparePushCommand(this.myProject, dialog));
            new Task.Backgroundable(this.myProject, "Pushing...", false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/HgPusher$1", "run"));
                    }
                    if (pushCommand.get() != null) {
                        HgPusher.push(this.myProject, (HgPushCommand)pushCommand.get());
                    }
                }
            }.queue();
        }
    }

    private static void push(final Project project, HgPushCommand command) {
        final VirtualFile repo = command.getRepo();
        command.execute(new HgCommandResultHandler(){

            @Override
            public void process(@Nullable HgCommandResult result) {
                if (result == null) {
                    return;
                }
                if (result.getExitValue() == PUSH_SUCCEEDED_EXIT_VALUE) {
                    int commitsNum = HgPusher.getNumberOfPushedCommits(result);
                    String successTitle = "Pushed successfully";
                    String successDescription = String.format("Pushed %d %s [%s]", commitsNum, StringUtil.pluralize((String)"commit", (int)commitsNum), repo.getPresentableName());
                    VcsNotifier.getInstance((Project)project).notifySuccess(successTitle, successDescription);
                } else if (result.getExitValue() == NOTHING_TO_PUSH_EXIT_VALUE) {
                    VcsNotifier.getInstance((Project)project).notifySuccess("Nothing to push");
                } else {
                    new HgCommandResultNotifier(project).notifyError(result, "Push failed", "Failed to push to [" + repo.getPresentableName() + "]");
                }
            }
        });
    }

    private static HgPushCommand preparePushCommand(Project project, HgPushDialog dialog) {
        HgPushCommand command = new HgPushCommand(project, dialog.getRepository().getRoot(), dialog.getTarget());
        command.setRevision(dialog.getRevision());
        command.setForce(dialog.isForce());
        command.setBranchName(dialog.getBranch());
        command.setBookmarkName(dialog.getBookmarkName());
        command.setIsNewBranch(dialog.isNewBranch());
        return command;
    }

    private static int getNumberOfPushedCommits(HgCommandResult result) {
        int numberOfCommitsInAllSubrepos = 0;
        List<String> outputLines = result.getOutputLines();
        for (String outputLine : outputLines) {
            Matcher matcher = PUSH_COMMITS_PATTERN.matcher(outputLine = outputLine.trim());
            if (!matcher.matches()) continue;
            try {
                numberOfCommitsInAllSubrepos += Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException e) {
                LOG.error("getNumberOfPushedCommits ", (Throwable)e);
                return -1;
            }
        }
        return numberOfCommitsInAllSubrepos;
    }
}

