/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.google.common.base.Objects;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.util.HgUtil;

public class HgFile {
    private final VirtualFile vcsRoot;
    private final File file;
    private String relativePath;

    public HgFile(@NotNull VirtualFile vcsRoot, File file) {
        if (vcsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/HgFile", "<init>"));
        }
        this.vcsRoot = vcsRoot;
        this.file = file;
    }

    public HgFile(@NotNull VirtualFile vcsRoot, FilePath filePath) {
        if (vcsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/HgFile", "<init>"));
        }
        this(vcsRoot, filePath.getIOFile());
    }

    public HgFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/zmlx/hg4idea/HgFile", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/zmlx/hg4idea/HgFile", "<init>"));
        }
        this(HgUtil.getHgRootOrNull(project, file), VcsUtil.getFilePath((String)file.getPath()));
    }

    @NotNull
    public VirtualFile getRepo() {
        VirtualFile virtualFile = this.vcsRoot;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgFile", "getRepo"));
        }
        return virtualFile;
    }

    public File getFile() {
        return this.file;
    }

    @NotNull
    public String getRelativePath() {
        if (this.relativePath == null) {
            this.relativePath = HgFile.buildRelativePath(VfsUtil.virtualToIoFile((VirtualFile)this.vcsRoot), this.file);
        }
        String string = this.relativePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgFile", "getRelativePath"));
        }
        return string;
    }

    @NotNull
    public FilePath toFilePath() {
        FilePath filePath = VcsUtil.getFilePath((File)this.file);
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgFile", "toFilePath"));
        }
        return filePath;
    }

    private static String buildRelativePath(File anchestor, File descendant) {
        if (anchestor.equals(descendant)) {
            return ".";
        }
        if (anchestor.equals(descendant.getParentFile())) {
            return descendant.getName();
        }
        return HgFile.buildRelativePath(anchestor, descendant.getParentFile()) + File.separator + descendant.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HgFile that = (HgFile)o;
        if (!this.vcsRoot.equals(that.vcsRoot)) {
            return false;
        }
        return !(this.file != null ? !FileUtil.filesEqual((File)this.file, (File)that.file) : that.file != null);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.vcsRoot, this.file});
    }

    public String toString() {
        return Objects.toStringHelper(HgFile.class).add("repo", (Object)this.vcsRoot).add("file", (Object)this.file).add("relativePath", (Object)this.getRelativePath()).toString();
    }
}

