/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.TaskState;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="server")
public abstract class TaskRepository {
    protected static final int NO_FEATURES = 0;
    public static final int BASIC_HTTP_AUTHORIZATION = 1;
    public static final int LOGIN_ANONYMOUSLY = 2;
    public static final int TIME_MANAGEMENT = 4;
    public static final int STATE_UPDATING = 8;
    public static final int NATIVE_SEARCH = 16;
    private boolean myShared;
    private String myUrl = "";
    private TaskRepositoryType myType;
    protected boolean myShouldFormatCommitMessage;
    protected String myCommitMessageFormat = "{id} {summary}";

    @Attribute(value="url")
    public String getUrl() {
        return TaskRepository.trimTrailingSlashes(this.myUrl);
    }

    public void setUrl(String url) {
        this.myUrl = TaskRepository.trimTrailingSlashes(url);
    }

    public boolean isConfigured() {
        return StringUtil.isNotEmpty((String)this.getUrl());
    }

    @Attribute(value="shared")
    public boolean isShared() {
        return this.myShared;
    }

    public void setShared(boolean shared) {
        this.myShared = shared;
    }

    public String getPresentableName() {
        return StringUtil.isEmpty((String)this.getUrl()) ? "<undefined>" : this.getUrl();
    }

    public Icon getIcon() {
        return this.getRepositoryType().getIcon();
    }

    public void testConnection() throws Exception {
    }

    @Nullable
    public CancellableConnection createCancellableConnection() {
        return null;
    }

    public abstract Task[] getIssues(@Nullable String var1, int var2, long var3) throws Exception;

    public Task[] getIssues(@Nullable String query, int max, long since, @NotNull ProgressIndicator progressIndicator) throws Exception {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/tasks/TaskRepository", "getIssues"));
        }
        return this.getIssues(query, max, since);
    }

    @Nullable
    public abstract Task findTask(String var1) throws Exception;

    public abstract TaskRepository clone();

    @Nullable
    public abstract String extractId(String var1);

    public void setTaskState(Task task, TaskState state) throws Exception {
        throw new UnsupportedOperationException("Setting task to state " + (Object)((Object)state) + " is not supported");
    }

    public TaskRepository() {
        this.myType = null;
    }

    public TaskRepository(TaskRepositoryType type) {
        this.myType = type;
    }

    protected TaskRepository(TaskRepository other) {
        this.myType = other.myType;
        this.myShared = other.isShared();
        this.myUrl = other.getUrl();
        this.setShouldFormatCommitMessage(other.myShouldFormatCommitMessage);
        this.setCommitMessageFormat(other.myCommitMessageFormat);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskRepository)) {
            return false;
        }
        TaskRepository that = (TaskRepository)o;
        if (!Comparing.equal((Object)this.myType, (Object)that.myType)) {
            return false;
        }
        if (this.isShared() != that.isShared()) {
            return false;
        }
        if (this.getUrl() != null ? !this.getUrl().equals(that.getUrl()) : that.getUrl() != null) {
            return false;
        }
        if (this.getCommitMessageFormat() != null ? !this.getCommitMessageFormat().equals(that.getCommitMessageFormat()) : that.getCommitMessageFormat() != null) {
            return false;
        }
        return this.isShouldFormatCommitMessage() == that.isShouldFormatCommitMessage();
    }

    @Transient
    public final TaskRepositoryType getRepositoryType() {
        return this.myType;
    }

    public final void setRepositoryType(TaskRepositoryType type) {
        this.myType = type;
    }

    public boolean isShouldFormatCommitMessage() {
        return this.myShouldFormatCommitMessage;
    }

    public void setShouldFormatCommitMessage(boolean shouldFormatCommitMessage) {
        this.myShouldFormatCommitMessage = shouldFormatCommitMessage;
    }

    @Tag(value="commitMessageFormat")
    public String getCommitMessageFormat() {
        return this.myCommitMessageFormat;
    }

    public void setCommitMessageFormat(String commitMessageFormat) {
        this.myCommitMessageFormat = commitMessageFormat;
    }

    private static String trimTrailingSlashes(String url) {
        if (url == null) {
            return "";
        }
        for (int i = url.length() - 1; i >= 0; --i) {
            if (url.charAt(i) == '/') continue;
            return url.substring(0, i + 1);
        }
        return "";
    }

    @Nullable
    public String getTaskComment(Task task) {
        return this.isShouldFormatCommitMessage() ? this.myCommitMessageFormat.replace("{id}", task.getId()).replace("{summary}", task.getSummary()) : null;
    }

    public String getComment() {
        return "{id} (e.g. FOO-001), {summary}, {number} (e.g. 001), {project} (e.g. FOO)";
    }

    public void updateTimeSpent(@NotNull LocalTask task, @NotNull String timeSpent, @NotNull String comment) throws Exception {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/TaskRepository", "updateTimeSpent"));
        }
        if (timeSpent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/tasks/TaskRepository", "updateTimeSpent"));
        }
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/tasks/TaskRepository", "updateTimeSpent"));
        }
        throw new UnsupportedOperationException();
    }

    public boolean isSupported(int feature) {
        return (this.getFeatures() & feature) != 0;
    }

    protected int getFeatures() {
        return 16;
    }

    public static abstract class CancellableConnection
    implements Callable<Exception> {
        @Override
        @Nullable
        public final Exception call() {
            try {
                this.doTest();
                return null;
            }
            catch (Exception e) {
                return e;
            }
        }

        protected abstract void doTest() throws Exception;

        public abstract void cancel();
    }
}

