/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.TaskType;
import java.util.Date;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Task {
    public static Task[] EMPTY_ARRAY = new Task[0];

    @NotNull
    public abstract String getId();

    @NotNull
    public abstract String getSummary();

    @Nullable
    public abstract String getDescription();

    @NotNull
    public abstract Comment[] getComments();

    @NotNull
    public abstract Icon getIcon();

    @NotNull
    public abstract TaskType getType();

    @Nullable
    public abstract Date getUpdated();

    @Nullable
    public abstract Date getCreated();

    public abstract boolean isClosed();

    @Nullable
    public String getCustomIcon() {
        return null;
    }

    public abstract boolean isIssue();

    @Nullable
    public abstract String getIssueUrl();

    @Nullable
    public TaskRepository getRepository() {
        return null;
    }

    @Nullable
    public TaskState getState() {
        return null;
    }

    public final String toString() {
        String text = this.isIssue() ? this.getId() + ": " + this.getSummary() : this.getSummary();
        return StringUtil.first((String)text, (int)60, (boolean)true);
    }

    public String getPresentableName() {
        return this.toString();
    }

    public final boolean equals(Object obj) {
        return obj instanceof Task && ((Task)obj).getId().equals(this.getId());
    }

    public final int hashCode() {
        return this.getId().hashCode();
    }

    @NotNull
    public String getNumber() {
        int i = this.getId().lastIndexOf(45);
        String string = i > 0 ? this.getId().substring(i + 1) : this.getId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/Task", "getNumber"));
        }
        return string;
    }

    @Nullable
    public String getProject() {
        int i = this.getId().lastIndexOf(45);
        return i > 0 ? this.getId().substring(0, i) : null;
    }
}

